/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.recipe.ElvenTradeRecipe;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.LexicaBotaniaItem;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2371;
import net.minecraft.class_2960;

public class LexiconElvenTradeRecipe implements ElvenTradeRecipe {
	private final class_2960 id;

	LexiconElvenTradeRecipe(class_2960 id) {
		this.id = id;
	}

	@Override
	public boolean containsItem(class_1799 stack) {
		return stack.method_31574(BotaniaItems.lexicon) && !ItemNBTHelper.getBoolean(stack, LexicaBotaniaItem.TAG_ELVEN_UNLOCK, false);
	}

	@NotNull
	@Override
	public class_2371<class_1856> method_8117() {
		return class_2371.method_10213(1, class_1856.method_8091(BotaniaItems.lexicon));
	}

	@NotNull
	@Override
	public class_1799 method_17447() {
		return new class_1799(BotaniaBlocks.alfPortal);
	}

	@NotNull
	@Override
	public class_2960 method_8114() {
		return id;
	}

	@Override
	public List<class_1799> getOutputs() {
		class_1799 stack = new class_1799(BotaniaItems.lexicon);
		stack.method_7948().method_10556(LexicaBotaniaItem.TAG_ELVEN_UNLOCK, true);
		return Collections.singletonList(stack);
	}

	@Override
	public Optional<List<class_1799>> match(List<class_1799> stacks) {
		for (class_1799 stack : stacks) {
			if (containsItem(stack)) {
				return Optional.of(Collections.singletonList(stack));
			}
		}
		return Optional.empty();
	}

	@Override
	public List<class_1799> getOutputs(List<class_1799> inputs) {
		class_1799 stack = inputs.get(0).method_7972();
		stack.method_7948().method_10556(LexicaBotaniaItem.TAG_ELVEN_UNLOCK, true);
		return Collections.singletonList(stack);
	}

	@NotNull
	@Override
	public class_1865<LexiconElvenTradeRecipe> method_8119() {
		return BotaniaRecipeTypes.LEXICON_ELVEN_TRADE_SERIALIZER;
	}
}
