package vazkii.botania.test.block;

import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_4516;
import net.minecraft.class_6302;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ManaSpreaderBlockEntity;
import vazkii.botania.common.block.block_entity.mana.PowerGeneratorBlockEntity;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.test.TestingUtil;

public class ManaSpreaderTest {
	private static final String[] SPREADERS = { "Pulse Spreader", "Mana Spreader", "Elven Spreader", "Gaia Spreader" };
	private static final int NUM_SPREADERS = 4;
	private static final class_2338 SPREADER_POS = new class_2338(2, 1, 1);
	private static final class_2338 POOL_POS = new class_2338(3, 1, 1);
	private static final class_2338 SINK_POS = new class_2338(4, 1, 1);
	private static final class_2338 LEVER_POS = new class_2338(1, 2, 2);

	@class_6302(method_35936 = "botania:block/spreader_pool_default_aim")
	public void testSpreaderDefaultAimHittingPool(class_4516 helper) {
		var player = helper.method_36021();

		// point the spreaders at their corresponding sink block to aim them exactly horizontally
		for (int i = 0; i < NUM_SPREADERS; i++) {
			var spreaderName = SPREADERS[i];
			var pool = TestingUtil.assertBlockEntity(helper, POOL_POS.method_10077(i), BotaniaBlockEntities.POOL);
			TestingUtil.assertEquals(pool.getCurrentMana(), 0, () -> String.format("Pool for %s does not start empty", spreaderName));
			var spreader = TestingUtil.assertBlockEntity(helper, SPREADER_POS.method_10077(i), BotaniaBlockEntities.SPREADER);
			var bindPos = SINK_POS.method_10077(i);
			TestingUtil.assertThat(spreader.bindTo(player, new class_1799(BotaniaItems.twigWand), helper.method_36052(bindPos), class_2350.field_11036),
					() -> "Failed to bind spreader");
		}

		helper.method_36041()
				.method_36085(() -> helper.method_36039(LEVER_POS))
				.method_36077(10, () -> {
					for (int i = 0; i < NUM_SPREADERS; i++) {
						var spreaderName = SPREADERS[i];
						var pool = TestingUtil.assertBlockEntity(helper, POOL_POS.method_10077(i), BotaniaBlockEntities.POOL);
						var sink = TestingUtil.assertBlockEntity(helper, SINK_POS.method_10077(i), BotaniaBlockEntities.FLUXFIELD);
						TestingUtil.assertThat(pool.getCurrentMana() > 0, () -> String.format("Pool for %s did not receive mana", spreaderName));
						TestingUtil.assertEquals(sink.getCurrentMana(), 0, () -> String.format("Sink for %s should not have received", spreaderName));
					}
				})
				.method_36075();
	}
}
