/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.rod;

import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.item.BlockProvider;
import vazkii.botania.api.mana.ManaItemHandler;

public class DepthsRodItem extends class_1792 {

	public static final int COST = 150;

	public DepthsRodItem(class_1793 props) {
		super(props);
	}

	@NotNull
	@Override
	public class_1269 method_7884(class_1838 ctx) {
		return LandsRodItem.place(ctx, class_2246.field_10445, COST, 0.3F, 0.3F, 0.3F);
	}

	public static class BlockProviderImpl implements BlockProvider {
		@Override
		public boolean provideBlock(class_1657 player, class_1799 requestor, class_2248 block, boolean doit) {
			if (block == class_2246.field_10445) {
				return (doit && ManaItemHandler.instance().requestManaExactForTool(requestor, player, COST, true)) ||
						(!doit && ManaItemHandler.instance().requestManaExactForTool(requestor, player, COST, false));
			}
			return false;
		}

		@Override
		public int getBlockCount(class_1657 player, class_1799 requestor, class_2248 block) {
			if (block == class_2246.field_10445) {
				return ManaItemHandler.instance().getInvocationCountForTool(requestor, player, COST);
			}
			return 0;
		}
	}

}
