/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.flower.functional;

import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3956;
import vazkii.botania.api.recipe.OrechidRecipe;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;

public class OrechidIgnemBlockEntity extends OrechidBlockEntity {
	private static final int COST = 20000;

	public OrechidIgnemBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaFlowerBlocks.ORECHID_IGNEM, pos, state);
	}

	@Override
	public boolean canOperate() {
		return method_10997().method_8597().comp_643();
	}

	@Override
	public class_3956<? extends OrechidRecipe> getRecipeType() {
		return BotaniaRecipeTypes.ORECHID_IGNEM_TYPE;
	}

	@Override
	public int getCost() {
		return COST;
	}

	@Override
	public int getColor() {
		return 0xAE3030;
	}

}
