/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity.mana;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;

public class ManaPumpBlockEntity extends BotaniaBlockEntity {
	private static final String TAG_ACTIVE = "active";

	public float innerRingPos;
	private boolean active = false;
	public boolean hasCart = false;
	public boolean hasCartOnTop = false;
	public float moving = 0F;

	public int comparator;
	public boolean hasRedstone = false;
	private int lastComparator = 0;

	public ManaPumpBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaBlockEntities.PUMP, pos, state);
	}

	public static void commonTick(class_1937 level, class_2338 worldPosition, class_2680 state, ManaPumpBlockEntity self) {
		self.hasRedstone = level.method_49803(worldPosition);

		float max = 8F;
		float min = 0F;

		float incr = max / 10F;

		if (self.innerRingPos < max && self.active && self.moving >= 0F) {
			self.innerRingPos += incr;
			self.moving = incr;
			if (self.innerRingPos >= max) {
				self.innerRingPos = Math.min(max, self.innerRingPos);
				self.moving = 0F;
				for (int x = 0; x < 2; x++) {
					level.method_8406(class_2398.field_11251, worldPosition.method_10263() + Math.random(), worldPosition.method_10264() + Math.random(), worldPosition.method_10260() + Math.random(), 0, 0, 0);
				}
			}
		} else if (self.innerRingPos > min) {
			self.innerRingPos -= incr * 2;
			self.moving = -incr * 2;
			if (self.innerRingPos <= min) {
				self.innerRingPos = Math.max(min, self.innerRingPos);
				self.moving = 0F;
			}
		}

		if (!self.hasCartOnTop) {
			self.comparator = 0;
		}
		if (!self.hasCart && self.active) {
			self.setActive(false);
		}
		if (self.active && self.hasRedstone) {
			self.setActive(false);
		}

		self.hasCart = false;
		self.hasCartOnTop = false;

		if (self.comparator != self.lastComparator) {
			level.method_8455(worldPosition, state.method_26204());
		}
		self.lastComparator = self.comparator;
	}

	@Override
	public void writePacketNBT(class_2487 cmp) {
		cmp.method_10556(TAG_ACTIVE, active);
	}

	@Override
	public void readPacketNBT(class_2487 cmp) {
		active = cmp.method_10577(TAG_ACTIVE);
	}

	public void setActive(boolean active) {
		if (!field_11863.field_9236) {
			boolean diff = this.active != active;
			this.active = active;
			if (diff) {
				VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
			}
		}
	}
}
