package vazkii.botania.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.common.lib.LibBlockNames;
import vazkii.botania.common.lib.LibMisc;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2248;
import net.minecraft.class_2362;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_4925;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class PottedPlantModelProvider implements class_2405 {
	private final class_7784 packOutput;

	public PottedPlantModelProvider(class_7784 packOutput) {
		this.packOutput = packOutput;
	}

	@Override
	public CompletableFuture<?> method_10319(class_7403 cache) {
		List<class_3545<String, JsonElement>> jsons = new ArrayList<>();
		for (class_2248 b : class_7923.field_41175) {
			class_2960 blockId = class_7923.field_41175.method_10221(b);
			if (LibMisc.MOD_ID.equals(blockId.method_12836()) && b instanceof class_2362) {
				String name = blockId.method_12832();
				String nonPotted = name.replace(LibBlockNames.POTTED_PREFIX, "").replace("_motif", "");

				JsonObject obj = new JsonObject();
				obj.addProperty("parent", "minecraft:block/flower_pot_cross");
				JsonObject textures = new JsonObject();
				textures.addProperty("plant", ResourcesLib.PREFIX_MOD + "block/" + nonPotted);
				obj.add("textures", textures);
				jsons.add(new class_3545<>(name, obj));
			}
		}
		List<CompletableFuture<?>> output = new ArrayList<>();
		class_7784.class_7489 blocks = packOutput.method_45973(class_7784.class_7490.field_39368, "models/block");
		for (class_3545<String, JsonElement> pair : jsons) {
			output.add(class_2405.method_10320(cache, pair.method_15441(), blocks.method_44107(prefix(pair.method_15442()))));
		}

		return CompletableFuture.allOf(output.toArray(CompletableFuture[]::new));
	}

	static class_4925 createSimpleBlock(class_2248 block, class_2960 resourceLocation) {
		return class_4925.method_25770(block, class_4935.method_25824().method_25828(class_4936.field_22887, resourceLocation));
	}

	@NotNull
	@Override
	public String method_10321() {
		return "Botania potted plant models";
	}
}
