/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.integration.corporea;

import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_3954;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.corporea.CorporeaNode;
import vazkii.botania.api.corporea.CorporeaNodeDetector;
import vazkii.botania.api.corporea.CorporeaSpark;
import vazkii.botania.common.impl.corporea.SidedVanillaCorporeaNode;
import vazkii.botania.common.impl.corporea.VanillaCorporeaNode;

public class VanillaNodeDetector implements CorporeaNodeDetector {
	@Nullable
	@Override
	public CorporeaNode getNode(class_1937 level, CorporeaSpark spark) {
		// [VanillaCopy] HopperBlockEntity
		class_1263 container = null;
		class_2338 blockPos = spark.getAttachPos();
		class_2680 blockState = level.method_8320(blockPos);
		class_2248 block = blockState.method_26204();
		if (block instanceof class_3954 worldlyContainer) {
			container = worldlyContainer.method_17680(blockState, level, blockPos);
		} else if (blockState.method_31709()) {
			class_2586 blockEntity = level.method_8321(blockPos);
			if (blockEntity instanceof class_1263 beContainer) {
				container = beContainer;
				if (container instanceof class_2595 && block instanceof class_2281 chest) {
					container = class_2281.method_17458(chest, blockState, level, blockPos, true);
				}
			}
		}

		if (container instanceof class_1278 worldlyContainer) {
			return new SidedVanillaCorporeaNode(level, spark.getAttachPos(), spark, worldlyContainer, class_2350.field_11036);
		} else if (container != null) {
			return new VanillaCorporeaNode(level, spark.getAttachPos(), container, spark);
		}
		return null;
	}
}
