/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.gui.bag;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.common.item.FlowerPouchItem;

public class FlowerPouchGui extends class_465<FlowerPouchContainer> {

	private static final class_2960 texture = new class_2960(ResourcesLib.GUI_FLOWER_BAG);

	public FlowerPouchGui(FlowerPouchContainer container, class_1661 playerInv, class_2561 title) {
		super(container, playerInv, title);
		field_2779 += 36;

		// recompute, same as super
		field_25270 = field_2779 - 94;
	}

	@Override
	public void method_25394(class_332 gui, int mouseX, int mouseY, float partialTicks) {
		this.method_25420(gui);
		super.method_25394(gui, mouseX, mouseY, partialTicks);
		this.method_2380(gui, mouseX, mouseY);
	}

	@Override
	protected void method_2389(class_332 gui, float partialTicks, int mouseX, int mouseY) {
		class_4587 ms = gui.method_51448();
		class_310 mc = class_310.method_1551();
		RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
		int k = (field_22789 - field_2792) / 2;
		int l = (field_22790 - field_2779) / 2;
		gui.method_25302(texture, k, l, 0, 0, field_2792, field_2779);

		for (class_1735 slot : field_2797.field_7761) {
			if (slot.field_7871 == field_2797.flowerBagInv) {
				int x = this.field_2776 + slot.field_7873;
				int y = this.field_2800 + slot.field_7872;
				if (!slot.method_7681()) {
					class_1799 missingFlower = new class_1799(FlowerPouchItem.getFlowerForSlot(slot.field_7874));
					RenderHelper.renderGuiItemAlpha(missingFlower, x, y, 0x5F, mc.method_1480());
				} else if (slot.method_7677().method_7947() == 1) {
					// Always draw the count even at 1
					ms.method_22903();
					// Same as how much vanilla offsets when drawing items in guis
					ms.method_46416(0, 0, 200);
					gui.method_25303(mc.field_1772, "1", x + 11, y + 9, 0xFFFFFF);
					ms.method_22909();
				}
			}
		}
	}

}
