/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.fabric.mixin;

import net.minecraft.class_1263;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_5132;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

import vazkii.botania.common.PlayerAccess;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.handler.PixieHandler;
import vazkii.botania.common.item.equipment.armor.terrasteel.TerrasteelHelmItem;
import vazkii.botania.common.item.equipment.bauble.*;
import vazkii.botania.common.item.relic.RingOfOdinItem;

@Mixin(class_1657.class)
public abstract class PlayerFabricMixin extends class_1309 {

	protected PlayerFabricMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
		super(entityType, world);
	}

	@Shadow
	@Final
	private class_1661 inventory;

	/**
	 * Registers the pixie spawn chance attribute on players
	 */
	@Inject(at = @At("RETURN"), method = "createAttributes")
	private static void addPixieAttribute(CallbackInfoReturnable<class_5132.class_5133> cir) {
		cir.getReturnValue().method_26867(PixieHandler.PIXIE_SPAWN_CHANCE);
	}

	/**
	 * Makes the player invulnerable to certain damage when wearing an Odin Ring
	 */
	@Inject(at = @At("HEAD"), method = "isInvulnerableTo", cancellable = true)
	private void odinRing(class_1282 src, CallbackInfoReturnable<Boolean> cir) {
		if (RingOfOdinItem.onPlayerAttacked((class_1657) (Object) this, src)) {
			cir.setReturnValue(true);
		}
	}

	/**
	 * Performs many reactions when being hit
	 */
	@ModifyArgs(method = "hurt", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/LivingEntity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"))
	private void onHurt(Args args) {
		class_1657 self = (class_1657) (Object) this;
		class_1282 src = args.get(0);
		float amount = args.get(1);
		class_1263 worn = EquipmentHandler.getAllWorn(self);
		for (int i = 0; i < worn.method_5439(); i++) {
			class_1799 stack = worn.method_5438(i);
			if (stack.method_7909() instanceof CloakOfVirtueItem cloak) {
				amount = cloak.onPlayerDamage(self, src, amount);
			}
		}

		// Should really make a separate inject for this, but putting it here works too
		PixieHandler.onDamageTaken(self, src);

		args.set(1, amount);
	}

	/**
	 * Tells the magnet ring about item drops
	 */
	@Inject(at = @At("HEAD"), method = "drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;")
	public void onDrop(class_1799 stack, boolean throwRandomly, boolean retainOwnership, CallbackInfoReturnable<class_1542> cir) {
		class_1937 world = this.method_37908();
		if (!stack.method_7960() && !world.field_9236) {
			RingOfMagnetizationItem.onTossItem((class_1657) (Object) this);
		}
	}

	@Inject(at = @At("RETURN"), method = "tick")
	private void tickBeltTiara(CallbackInfo ci) {
		FlugelTiaraItem.updatePlayerFlyStatus((class_1657) (Object) this);
		SojournersSashItem.tickBelt((class_1657) (Object) this);
	}

	@ModifyArg(index = 0, method = "causeFallDamage", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/LivingEntity;causeFallDamage(FFLnet/minecraft/world/damagesource/DamageSource;)Z"))
	private float cushionFall(float originalDist) {
		return SojournersSashItem.onPlayerFall((class_1657) (Object) this, originalDist);
	}

	// Multiply the damage on crit. Targets the first float LOAD after the sprint check for the crit.
	// Stores the entity for further handling in the common Player mixin.
	@ModifyVariable(
		at = @At(value = "LOAD", ordinal = 0),
		slice = @Slice(from = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/player/Player;isSprinting()Z", ordinal = 1)),
		method = "attack", ordinal = 0
	)
	private float onCritMul(float f, class_1297 target) {
		if (target instanceof class_1309 living) {
			((PlayerAccess) this).botania$setCritTarget(living);
			return f * TerrasteelHelmItem.getCritDamageMult((class_1657) (Object) this);
		}
		return f;
	}
}
