/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.world;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.ManaFlameBlockEntity;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.network.clientbound.GogWorldPacket;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.XplatAbstractions;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3485;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3499.class_3501;
import net.minecraft.class_3793;
import net.minecraft.class_3965;
import net.minecraft.class_52;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_8567;

public final class SkyblockWorldEvents {

	private SkyblockWorldEvents() {}

	private static final class_6862<class_2248> PEBBLE_SOURCES = class_6862.method_40092(class_7924.field_41254, new class_2960("gardenofglass:pebble_sources"));
	private static final class_2960 PEBBLES_TABLE = new class_2960(BotaniaAPI.GOG_MODID, "pebbles");

	public static void syncGogStatus(class_3222 e) {
		boolean isGog = SkyblockChunkGenerator.isWorldSkyblock(e.method_37908());
		if (isGog) {
			XplatAbstractions.INSTANCE.sendToPlayer(e, GogWorldPacket.INSTANCE);
		}
	}

	public static void onPlayerJoin(class_3222 player) {
		class_3218 world = player.method_51469();
		if (SkyblockChunkGenerator.isWorldSkyblock(world)) {
			SkyblockSavedData data = SkyblockSavedData.get(world);
			if (!data.skyblocks.containsValue(class_156.field_25140)) {
				IslandPos islandPos = data.getSpawn();
				world.method_8554(islandPos.getCenter(), 0);
				spawnPlayer(player, islandPos);
				BotaniaAPI.LOGGER.info("Created the spawn GoG island");
			}
		}
	}

	public static class_1269 onPlayerInteract(class_1657 player, class_1937 world, class_1268 hand, class_3965 hit) {
		if (XplatAbstractions.INSTANCE.gogLoaded()) {
			class_1799 equipped = player.method_5998(hand);

			if (equipped.method_7960() && player.method_5715()) {
				class_2680 state = world.method_8320(hit.method_17777());

				if (state.method_26164(PEBBLE_SOURCES)) {
					class_2498 st = state.method_26231();
					class_3414 sound = st.method_10595();
					player.method_5783(sound, st.method_10597() * 0.4F, st.method_10599() + (float) (Math.random() * 0.2 - 0.1));

					if (world.field_9236) {
						player.method_6104(hand);
					} else if (world instanceof class_3218 level) {
						var table = level.method_8503().method_3857().getLootTable(PEBBLES_TABLE);
						var context = new class_8567.class_8568(level)
								.method_51874(class_181.field_1224, state)
								.method_51874(class_181.field_24424, class_243.method_24953(hit.method_17777()))
								.method_51874(class_181.field_1229, equipped)
								.method_51874(class_181.field_1226, player)
								.method_51877(class_181.field_1228, level.method_8321(hit.method_17777()))
								.method_51875(class_173.field_1172);
						table.method_51882(context, s -> player.method_7328(s, false));
					}

					return class_1269.field_5812;
				}
			} else if (!equipped.method_7960() && equipped.method_31574(class_1802.field_8428)) {
				class_3965 rtr = ToolCommons.raytraceFromEntity(player, 4.5F, true);
				if (rtr.method_17783() == class_239.class_240.field_1332) {
					class_2338 pos = rtr.method_17777();
					if (world.method_8320(pos).method_27852(class_2246.field_10382)) {
						if (!world.field_9236) {
							equipped.method_7934(1);

							if (equipped.method_7960()) {
								player.method_6122(hand, new class_1799(BotaniaItems.waterBowl));
							} else {
								player.method_31548().method_7398(new class_1799(BotaniaItems.waterBowl));
							}
						}

						return class_1269.field_5812;
					}
				}
			}
		}
		return class_1269.field_5811;
	}

	public static void spawnPlayer(class_1657 player, IslandPos islandPos) {
		class_2338 pos = islandPos.getCenter();

		if (player instanceof class_3222 pmp) {
			createSkyblock(pmp.method_51469(), pos);
			pmp.method_5859(pos.method_10263() + 0.5, pos.method_10264() + 1.6, pos.method_10260() + 0.5);
			pmp.method_26284(pmp.method_37908().method_27983(), pos, 0, true, false);
			if (BotaniaConfig.common().gogSpawnWithLexicon()) {
				player.method_31548().method_7394(new class_1799(BotaniaItems.lexicon));
			}
		}
	}

	public static void createSkyblock(class_3218 level, class_2338 pos) {
		var manager = level.method_14183();
		var template = manager.method_15094(prefix("gog_island")).orElseThrow();
		var structureBlockInfos = template.method_15165(pos, new class_3492(), class_2246.field_10465, false);
		structureBlockInfos.removeIf(info -> info.comp_1343() == null);

		class_2338 offset;
		var infoOptional = structureBlockInfos.stream()
				.filter(info -> "spawn_point".equals(info.comp_1343().method_10558("metadata")))
				.findFirst();
		if (infoOptional.isPresent()) {
			offset = infoOptional.get().comp_1341();
		} else {
			BotaniaAPI.LOGGER.error("Structure botania:gog_island has no spawn_point data marker block, trying to offset it somewhat in the center");
			class_2382 size = template.method_15160();
			offset = new class_2338(size.method_10263() / 2, size.method_10264(), size.method_10260() / 2);
		}
		class_2338 startPoint = pos.method_10059(offset);

		template.method_15172(level,
				startPoint,
				startPoint,
				new class_3492().method_16184(class_3793.field_16718),
				level.field_9229,
				class_2248.field_31036);
		for (var info : structureBlockInfos) {
			if ("light".equals(info.comp_1343().method_10558("metadata"))) {
				class_2338 lightPos = startPoint.method_10081(info.comp_1341());
				if (level.method_8501(lightPos, BotaniaBlocks.manaFlame.method_9564())) {
					int r = 70 + level.field_9229.method_43048(185);
					int g = 70 + level.field_9229.method_43048(185);
					int b = 70 + level.field_9229.method_43048(185);
					int color = r << 16 | g << 8 | b;
					((ManaFlameBlockEntity) level.method_8321(lightPos)).setColor(color);
				}
			}
		}
	}
}
