/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.network.clientbound;

import org.jetbrains.annotations.Nullable;

import vazkii.botania.client.gui.ItemsRemainingRenderHandler;
import vazkii.botania.network.BotaniaPacket;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public record UpdateItemsRemainingPacket(class_1799 stack, int count, @Nullable class_2561 tooltip) implements BotaniaPacket {

	public static final class_2960 ID = prefix("rem");

	@Override
	public void encode(class_2540 buf) {
		buf.method_10793(stack);
		buf.method_10804(count);
		buf.writeBoolean(tooltip != null);
		if (tooltip != null) {
			buf.method_10805(tooltip);
		}
	}

	@Override
	public class_2960 getFabricId() {
		return ID;
	}

	public static UpdateItemsRemainingPacket decode(class_2540 buf) {
		return new UpdateItemsRemainingPacket(
				buf.method_10819(),
				buf.method_10816(),
				buf.readBoolean() ? buf.method_10808() : null
		);
	}

	public static class Handler {
		public static void handle(UpdateItemsRemainingPacket packet) {
			class_1799 stack = packet.stack();
			int count = packet.count();
			class_2561 tooltip = packet.tooltip();
			class_310.method_1551().execute(() -> ItemsRemainingRenderHandler.set(stack, count, tooltip));
		}
	}
}
