/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.BrewContainer;
import vazkii.botania.api.brew.BrewItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.MiscellaneousModels;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.brew.BotaniaBrews;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.CustomCreativeTabContents;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.mixin.client.MinecraftAccessor;

import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_1087;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5250;
import net.minecraft.class_572;

public class TaintedBloodPendantItem extends BaubleItem implements BrewContainer, BrewItem, CustomCreativeTabContents {

	private static final String TAG_BREW_KEY = "brewKey";

	public TaintedBloodPendantItem(class_1793 props) {
		super(props);
		Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
	}

	@Override
	public void addToCreativeTab(class_1792 me, class_1761.class_7704 output) {
		output.method_45421(this);
		for (Brew brew : BotaniaAPI.instance().getBrewRegistry()) {
			class_1799 brewStack = getItemForBrew(brew, new class_1799(this));
			if (!brewStack.method_7960()) {
				output.method_45420(brewStack);
			}
		}
	}

	@Override
	public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 adv) {
		super.method_7851(stack, world, tooltip, adv);

		Brew brew = getBrew(stack);
		if (brew == BotaniaBrews.fallbackBrew) {
			tooltip.add(class_2561.method_43471("botaniamisc.notInfused").method_27692(class_124.field_1076));
			return;
		}

		tooltip.add(class_2561.method_43469("botaniamisc.brewOf", class_1074.method_4662(brew.getTranslationKey(stack))).method_27692(class_124.field_1076));
		for (class_1293 effect : brew.getPotionEffects(stack)) {
			class_124 format = effect.method_5579().method_18792().method_18793();
			class_5250 cmp = class_2561.method_43471(effect.method_5586());
			if (effect.method_5578() > 0) {
				cmp.method_27693(" ");
				cmp.method_10852(class_2561.method_43471("botania.roman" + (effect.method_5578() + 1)));
			}
			tooltip.add(cmp.method_27692(format));
		}
	}

	@Override
	public void onWornTick(class_1799 stack, class_1309 living) {
		Brew brew = ((BrewItem) stack.method_7909()).getBrew(stack);
		if (brew != BotaniaBrews.fallbackBrew && living instanceof class_1657 player && !living.method_37908().field_9236) {
			class_1293 effect = brew.getPotionEffects(stack).get(0);
			float cost = (float) brew.getManaCost(stack) / effect.method_5584() / (1 + effect.method_5578()) * 2.5F;
			boolean doRand = cost < 1;
			if (ManaItemHandler.instance().requestManaExact(stack, player, (int) Math.ceil(cost), false)) {
				class_1293 currentEffect = living.method_6112(effect.method_5579());
				boolean nightVision = effect.method_5579() == class_1294.field_5925;
				if (currentEffect == null || currentEffect.method_5584() < (nightVision ? 305 : 3)) {
					class_1293 applyEffect = new class_1293(effect.method_5579(), nightVision ? 385 : 80, effect.method_5578(), true, true);
					living.method_6092(applyEffect);
				}

				if (!doRand || Math.random() < cost) {
					ManaItemHandler.instance().requestManaExact(stack, player, (int) Math.ceil(cost), true);
				}
			}
		}
	}

	public static class Renderer implements AccessoryRenderer {
		@Override
		public void doRender(class_572<?> bipedModel, class_1799 stack, class_1309 living, class_4587 ms, class_4597 buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
			boolean armor = !living.method_6118(class_1304.field_6174).method_7960();
			bipedModel.field_3391.method_22703(ms);
			ms.method_22904(-0.25, 0.4, armor ? 0.05 : 0.12);
			ms.method_22905(0.5F, -0.5F, -0.5F);

			class_1087 model = MiscellaneousModels.INSTANCE.bloodPendantChain;
			class_4588 buffer = buffers.getBuffer(class_4722.method_24074());
			class_310.method_1551().method_1541().method_3350()
					.method_3367(ms.method_23760(), buffer, null, model, 1, 1, 1, light, class_4608.field_21444);

			model = MiscellaneousModels.INSTANCE.bloodPendantGem;
			int color = ((MinecraftAccessor) class_310.method_1551()).getItemColors().method_1704(stack, 1);
			float r = (color >> 16 & 0xFF) / 255F;
			float g = (color >> 8 & 0xFF) / 255F;
			float b = (color & 0xFF) / 255F;
			class_310.method_1551().method_1541().method_3350()
					.method_3367(ms.method_23760(), buffer, null, model, r, g, b, 0xF000F0, class_4608.field_21444);
		}
	}

	@Override
	public Brew getBrew(class_1799 stack) {
		String key = ItemNBTHelper.getString(stack, TAG_BREW_KEY, "");
		return BotaniaAPI.instance().getBrewRegistry().method_10223(class_2960.method_12829(key));
	}

	public static void setBrew(class_1799 stack, Brew brew) {
		setBrew(stack, BotaniaAPI.instance().getBrewRegistry().method_10221(brew));
	}

	public static void setBrew(class_1799 stack, class_2960 brew) {
		ItemNBTHelper.setString(stack, TAG_BREW_KEY, brew.toString());
	}

	@Override
	public class_1799 getItemForBrew(Brew brew, class_1799 stack) {
		if (!brew.canInfuseBloodPendant() || brew.getPotionEffects(stack).size() != 1 || brew.getPotionEffects(stack).get(0).method_5579().method_5561()) {
			return class_1799.field_8037;
		}

		class_1799 brewStack = new class_1799(this);
		setBrew(brewStack, brew);
		return brewStack;
	}

	@Override
	public int getManaCost(Brew brew, class_1799 stack) {
		return brew.getManaCost() * 10;
	}
}
