/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity;

import com.google.common.base.Suppliers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

/**
 * Version of {@link SimpleInventoryBlockEntity} where the backing inventory is exposed to automation
 */
public abstract class ExposedSimpleInventoryBlockEntity extends SimpleInventoryBlockEntity implements class_1278 {
	private final Supplier<int[]> slots = Suppliers.memoize(() -> IntStream.range(0, method_5439()).toArray());

	protected ExposedSimpleInventoryBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
		super(type, pos, state);
	}

	@Override
	public boolean method_5442() {
		return getItemHandler().method_5442();
	}

	@Override
	public int method_5439() {
		return inventorySize();
	}

	@Override
	public class_1799 method_5438(int index) {
		return getItemHandler().method_5438(index);
	}

	@Override
	public class_1799 method_5434(int index, int count) {
		return getItemHandler().method_5434(index, count);
	}

	@Override
	public class_1799 method_5441(int index) {
		return getItemHandler().method_5441(index);
	}

	@Override
	public void method_5447(int index, class_1799 stack) {
		getItemHandler().method_5447(index, stack);
	}

	@Override
	public boolean method_5443(class_1657 player) {
		return getItemHandler().method_5443(player);
	}

	@Override
	public int method_5444() {
		return getItemHandler().method_5444();
	}

	@Override
	public void method_5435(class_1657 player) {
		getItemHandler().method_5435(player);
	}

	@Override
	public void method_5432(class_1657 player) {
		getItemHandler().method_5432(player);
	}

	@Override
	public boolean method_5437(int index, class_1799 stack) {
		return getItemHandler().method_5437(index, stack);
	}

	@Override
	public int method_18861(class_1792 item) {
		return getItemHandler().method_18861(item);
	}

	@Override
	public boolean method_18862(Set<class_1792> set) {
		return getItemHandler().method_18862(set);
	}

	@NotNull
	@Override
	public int[] method_5494(@NotNull class_2350 side) {
		return slots.get();
	}

	@Override
	public boolean method_5492(int index, @NotNull class_1799 stack, @Nullable class_2350 direction) {
		if (method_5437(index, stack)) {
			// Vanilla hoppers do not check the inventory's stack limit, so do so here.
			// We don't have to check anything else like stackability because the hopper logic will do it
			class_1799 existing = method_5438(index);
			return existing.method_7947() < method_5444();
		}

		return false;
	}

	@Override
	public boolean method_5493(int index, @NotNull class_1799 stack, @Nullable class_2350 direction) {
		return true;
	}
}
