/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import java.util.ArrayList;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2356;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_5328;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.item.BlockProvider;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.lib.BotaniaTags;

public class TerraFirmaRodItem
extends class_1792 {
    private static final int COST_PER = 55;

    public TerraFirmaRodItem(class_1792.class_1793 props) {
        super(props);
    }

    @NotNull
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    public void method_7852(@NotNull class_1937 world, @NotNull class_1309 living, @NotNull class_1799 stack, int count) {
        if (count != this.method_7881(stack) && count % 10 == 0 && living instanceof class_1657) {
            class_1657 player = (class_1657)living;
            this.terraform(stack, world, player);
        }
    }

    @NotNull
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @NotNull class_1268 hand) {
        return class_5328.method_29282((class_1937)world, (class_1657)player, (class_1268)hand);
    }

    private void terraform(class_1799 stack, class_1937 world, class_1657 player) {
        int range = ManaItemHandler.instance().hasProficiency(player, stack) ? 22 : 16;
        class_2338 startCenter = player.method_24515().method_10074();
        if (startCenter.method_10264() < world.method_8615()) {
            return;
        }
        ArrayList<CoordsWithBlock> blocks = new ArrayList<CoordsWithBlock>();
        for (Object pos : class_2338.method_10097((class_2338)startCenter.method_10069(-range, -range, -range), (class_2338)startCenter.method_10069(range, range, range))) {
            class_2680 state = world.method_8320((class_2338)pos);
            if (state.method_26215() || !state.method_26164(BotaniaTags.Blocks.TERRAFORMABLE)) continue;
            ArrayList<class_2338> airBlocks = new ArrayList<class_2338>();
            for (class_2350 dir : class_2350.class_2353.field_11062) {
                class_2338 pos_ = pos.method_10093(dir);
                class_2680 state_ = world.method_8320(pos_);
                class_2248 block_ = state_.method_26204();
                if (!state_.method_26215() && !state_.method_45474() && (!(block_ instanceof class_2356) || state_.method_26164(BotaniaTags.Blocks.SPECIAL_FLOWERS)) && !(block_ instanceof class_2320)) continue;
                airBlocks.add(pos_);
            }
            if (airBlocks.isEmpty()) continue;
            if (pos.method_10264() > startCenter.method_10264()) {
                blocks.add(new CoordsWithBlock((class_2338)pos, class_2246.field_10124));
                continue;
            }
            for (class_2338 coords : airBlocks) {
                if (world.method_22347(coords.method_10074())) continue;
                blocks.add(new CoordsWithBlock(coords, class_2246.field_10566));
            }
        }
        int cost = 55 * blocks.size();
        if (world.field_9236 || ManaItemHandler.instance().requestManaExactForTool(stack, player, cost, true)) {
            if (!world.field_9236) {
                for (CoordsWithBlock block : blocks) {
                    world.method_8501((class_2338)block, block.block.method_9564());
                }
            }
            if (!blocks.isEmpty()) {
                world.method_43128(player, player.method_23317(), player.method_23318(), player.method_23321(), BotaniaSounds.terraformRod, class_3419.field_15245, 1.0f, 1.0f);
                SparkleParticleData data = SparkleParticleData.sparkle(2.0f, 0.35f, 0.2f, 0.05f, 5);
                for (int i = 0; i < 120; ++i) {
                    world.method_8406((class_2394)data, (double)(startCenter.method_10263() - range) + (double)(range * 2) * Math.random(), (double)(startCenter.method_10264() + 2) + (Math.random() - 0.5) * 2.0, (double)(startCenter.method_10260() - range) + (double)(range * 2) * Math.random(), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private static class CoordsWithBlock
    extends class_2338 {
        private final class_2248 block;

        private CoordsWithBlock(class_2338 pos, class_2248 block) {
            super((class_2382)pos);
            this.block = block;
        }
    }

    public static class BlockProviderImpl
    implements BlockProvider {
        @Override
        public boolean provideBlock(class_1657 player, class_1799 requestor, class_2248 block, boolean doit) {
            if (block == class_2246.field_10566) {
                return doit && ManaItemHandler.instance().requestManaExactForTool(requestor, player, 75, true) || !doit && ManaItemHandler.instance().requestManaExactForTool(requestor, player, 75, false);
            }
            return false;
        }

        @Override
        public int getBlockCount(class_1657 player, class_1799 requestor, class_2248 block) {
            if (block == class_2246.field_10566) {
                return ManaItemHandler.instance().getInvocationCountForTool(requestor, player, 75);
            }
            return 0;
        }
    }
}

