package vazkii.botania.data;

import com.google.gson.JsonElement;
import org.jetbrains.annotations.NotNull;

import java.nio.file.Path;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1299;
import net.minecraft.class_173;
import net.minecraft.class_1802;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_39;
import net.minecraft.class_52;
import net.minecraft.class_5270;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_7058;
import net.minecraft.class_7403;
import net.minecraft.class_77;
import net.minecraft.class_7784;
import net.minecraft.class_83;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class LooniumStructureLootProvider implements class_2405 {
	// loot collections based on which village type hoses can actually have chests
	public static final EnumSet<VillageLoot> PLAINS_VILLAGE_LOOT = EnumSet
			.of(VillageLoot.CARTOGRAPHER, VillageLoot.FISHER, VillageLoot.TANNERY, VillageLoot.WEAPONSMITH);
	public static final EnumSet<VillageLoot> DESERT_VILLAGE_LOOT = EnumSet
			.of(VillageLoot.TEMPLE, VillageLoot.TOOLSMITH, VillageLoot.WEAPONSMITH);
	public static final EnumSet<VillageLoot> SAVANNA_VILLAGE_LOOT = EnumSet
			.of(VillageLoot.BUTCHER, VillageLoot.CARTOGRAPHER, VillageLoot.MASON, VillageLoot.TANNERY, VillageLoot.WEAPONSMITH);
	public static final EnumSet<VillageLoot> SNOWY_VILLAGE_LOOT = EnumSet
			.of(VillageLoot.ARMORER, VillageLoot.CARTOGRAPHER, VillageLoot.SHEPHERD, VillageLoot.TANNERY, VillageLoot.WEAPONSMITH);
	public static final EnumSet<VillageLoot> TAIGA_VILLAGE_LOOT = EnumSet
			.of(VillageLoot.CARTOGRAPHER, VillageLoot.FLETCHER, VillageLoot.TANNERY, VillageLoot.TOOLSMITH, VillageLoot.WEAPONSMITH);

	private final class_7784.class_7489 pathProvider;

	public LooniumStructureLootProvider(class_7784 packOutput) {
		this.pathProvider = packOutput.method_45973(class_7784.class_7490.field_39367, "loot_tables/loonium");
	}

	public static class_2960 getStructureId(class_5321<class_3195> structureKey) {
		return getStructureId(structureKey.method_29177());
	}

	public static class_2960 getStructureId(class_2960 structureId) {
		return prefix("%s/%s".formatted(structureId.method_12836(), structureId.method_12832()));
	}

	@NotNull
	@Override
	public CompletableFuture<?> method_10319(@NotNull class_7403 cache) {
		Map<class_2960, class_52.class_53> tables = new HashMap<>();
		addLootTables(tables);

		var output = new ArrayList<CompletableFuture<?>>(tables.size());
		for (Map.Entry<class_2960, class_52.class_53> e : tables.entrySet()) {
			Path path = pathProvider.method_44107(e.getKey());
			class_52.class_53 builder = e.getValue();
			class_52 lootTable = builder.method_334(class_173.field_1177).method_338();
			JsonElement jsonTree = class_5270.method_27862().create().toJsonTree(lootTable);
			output.add(class_2405.method_10320(cache, jsonTree, path));
		}
		return CompletableFuture.allOf(output.toArray(CompletableFuture<?>[]::new));
	}

	private void addLootTables(Map<class_2960, class_52.class_53> tables) {
		// Note: As far as world generating is concerned, dungeons are "features" (i.e. like trees or geodes),
		// not "structures" (like everything else the Loonium might care about).
		tables.put(prefix("default"), buildDelegateLootTable(class_39.field_356));

		/*
		Note: Be careful about adding individual items instead of loot table references.
		The Loonium will randomly either generate a virtual chest full of loot from any referenced table, or put just
		one of the defined item entries into the "chest". Either way it only picks a single stack from that "chest".
		Individual item entries need to be weighted accordingly to not have them picked too often.
		Also, archaeology loot tables need to be handled carefully, due to their limited loot pool options.
		*/

		tables.put(getStructureId(class_7058.field_38428),
				class_52.method_324().method_336(class_55.method_347()
						.method_351(class_83.method_428(class_39.field_38438).method_437(9))
						.method_351(class_83.method_428(class_39.field_38439).method_437(1))
				)
		);
		tables.put(getStructureId(class_7058.field_37186),
				class_52.method_324().method_336(class_55.method_347()
						.method_351(class_83.method_428(class_39.field_24048).method_437(1))
						.method_351(class_83.method_428(class_39.field_24049).method_437(1))
						.method_351(class_83.method_428(class_39.field_24046).method_437(1))
						.method_351(class_83.method_428(class_39.field_24047).method_437(7))
				)
		);
		tables.put(getStructureId(class_7058.field_37185), buildDelegateLootTable(class_39.field_251));
		tables.put(getStructureId(class_7058.field_37173),
				class_52.method_324().method_336(class_55.method_347()
						.method_351(class_83.method_428(class_39.field_885).method_437(37))
						.method_351(class_83.method_428(class_39.field_43354).method_437(2))
						// desert wells are features, so not detectable by the Loonium
						.method_351(class_83.method_428(class_39.field_43353))
				)
		);
		tables.put(getStructureId(class_7058.field_37184),
				class_52.method_324().method_336(class_55.method_347()
						.method_351(class_83.method_428(class_39.field_274).method_437(49))
						.method_351(class_77.method_411(class_1802.field_8833))
				)
		);
		tables.put(getStructureId(class_7058.field_37182), buildDelegateLootTable(class_39.field_615));
		// skipping igloo, because the laboratory piece, which is the only part that has loot, can't be detected reliably
		tables.put(getStructureId(class_7058.field_37172),
				class_52.method_324().method_336(class_55.method_347()
						.method_351(class_83.method_428(class_39.field_803).method_437(9))
						.method_351(class_83.method_428(class_39.field_751))
				)
		);
		tables.put(getStructureId(class_7058.field_37169), buildDelegateLootTable(class_39.field_472));
		tables.put(getStructureId(class_7058.field_37170), buildDelegateLootTable(class_39.field_472));
		tables.put(getStructureId(class_7058.field_37179),
				class_52.method_324().method_336(class_55.method_347()
						.method_351(class_83.method_428(class_1299.field_6086.method_16351()).method_437(5))
						// sponge is a player-kill drop and won't be rolled for the elder guardian table by the Loonium
						.method_351(class_77.method_411(class_1802.field_8554))

				)
		);
		tables.put(getStructureId(class_7058.field_37180),
				buildOceanRuinLootTable(class_39.field_43357)
		);
		tables.put(getStructureId(class_7058.field_37181),
				buildOceanRuinLootTable(class_39.field_43356)
		);
		tables.put(getStructureId(class_7058.field_37168), buildDelegateLootTable(class_39.field_16593));
		tables.put(getStructureId(class_7058.field_37193), buildDelegateLootTable(class_39.field_24050));
		tables.put(getStructureId(class_7058.field_37163), buildDelegateLootTable(class_39.field_24050));
		tables.put(getStructureId(class_7058.field_37165), buildDelegateLootTable(class_39.field_24050));
		tables.put(getStructureId(class_7058.field_37167), buildDelegateLootTable(class_39.field_24050));
		tables.put(getStructureId(class_7058.field_37166), buildDelegateLootTable(class_39.field_24050));
		tables.put(getStructureId(class_7058.field_37192), buildDelegateLootTable(class_39.field_24050));
		tables.put(getStructureId(class_7058.field_37164), buildDelegateLootTable(class_39.field_24050));
		tables.put(getStructureId(class_7058.field_37175), buildShipwreckLootTable());
		tables.put(getStructureId(class_7058.field_37176), buildShipwreckLootTable());
		tables.put(getStructureId(class_7058.field_37178),
				// Strongholds generate up to 4 corridor chests, up to 6 crossings, and up to 2 libraries with 1 or 2 chests
				class_52.method_324().method_336(class_55.method_347()
						.method_351(class_83.method_428(class_39.field_842).method_437(4))
						.method_351(class_83.method_428(class_39.field_800).method_437(6))
						.method_351(class_83.method_428(class_39.field_683).method_437(3))
				)
		);
		// skipping swamp hut, because it doesn't contain unique loot (could merge witch/cat tables, I guess)
		tables.put(getStructureId(class_7058.field_43326),
				// Trail ruins have 2 common suspicious gravel for the tower top and each road section,
				// and 6 common plus 3 rare suspicious gravel per building and for the tower bottom.
				class_52.method_324().method_336(class_55.method_347()
						.method_351(class_83.method_428(class_39.field_44648).method_437(9))
						.method_351(class_83.method_428(class_39.field_44649))
				)
		);
		tables.put(getStructureId(class_7058.field_37187),
				buildVillageLootTable(class_39.field_16748, PLAINS_VILLAGE_LOOT)
		);
		tables.put(getStructureId(class_7058.field_37188),
				buildVillageLootTable(class_39.field_16752, DESERT_VILLAGE_LOOT)
		);
		tables.put(getStructureId(class_7058.field_37189),
				buildVillageLootTable(class_39.field_16753, SAVANNA_VILLAGE_LOOT)
		);
		tables.put(getStructureId(class_7058.field_37190),
				buildVillageLootTable(class_39.field_16754, SNOWY_VILLAGE_LOOT)
		);
		tables.put(getStructureId(class_7058.field_37191),
				buildVillageLootTable(class_39.field_16749, TAIGA_VILLAGE_LOOT)
		);
		tables.put(getStructureId(class_7058.field_37171),
				class_52.method_324().method_336(class_55.method_347()
						.method_351(class_83.method_428(class_39.field_484).method_437(99))
						.method_351(class_77.method_411(class_1802.field_8288).method_437(1))
				)
		);
	}

	public static class_52.class_53 buildVillageLootTable(class_2960 house, Set<VillageLoot> villageLootSet) {
		class_55.class_56 lootPool = class_55.method_347().method_351(class_83.method_428(house).method_437(3));
		for (VillageLoot loot : villageLootSet) {
			lootPool.method_351(class_83.method_428(loot.lootTable));
		}
		return class_52.method_324().method_336(lootPool);
	}

	@NotNull
	public static class_52.class_53 buildShipwreckLootTable() {
		return class_52.method_324().method_336(class_55.method_347()
				.method_351(class_83.method_428(class_39.field_841))
				.method_351(class_83.method_428(class_39.field_880))
				.method_351(class_83.method_428(class_39.field_665))
		);
	}

	@NotNull
	public static class_52.class_53 buildDelegateLootTable(class_2960 reference) {
		return class_52.method_324().method_336(class_55.method_347()
				.method_351(class_83.method_428(reference))
		);
	}

	@NotNull
	public static class_52.class_53 buildOceanRuinLootTable(class_2960 archaeology) {
		// Note: since the Loonium does not supply a location, treasure maps will roll as empty maps
		return class_52.method_324().method_336(class_55.method_347()
				// 30% of ocean ruin sites generate with a big ruin instead of a small one,
				// but 90% of those big ruin sites additionally generate 4-8 small ruins around the big one.
				.method_351(class_83.method_428(class_39.field_300))
				.method_351(class_83.method_428(class_39.field_397).method_437(8))
				.method_351(class_83.method_428(archaeology))
		);
	}

	@NotNull
	@Override
	public String method_10321() {
		return "Structure-specific loot tables for the Loonium";
	}

	public enum VillageLoot {
		WEAPONSMITH(class_39.field_434),
		TOOLSMITH(class_39.field_17107),
		ARMORER(class_39.field_17009),
		CARTOGRAPHER(class_39.field_16751),
		MASON(class_39.field_17010),
		SHEPHERD(class_39.field_17011),
		BUTCHER(class_39.field_17012),
		FLETCHER(class_39.field_17108),
		FISHER(class_39.field_18007),
		TANNERY(class_39.field_16750),
		TEMPLE(class_39.field_17109);

		public final class_2960 lootTable;

		VillageLoot(class_2960 lootTable) {
			this.lootTable = lootTable;
		}
	}
}
