/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.entity;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1682;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2392;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3856;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_52;
import net.minecraft.class_6088;
import net.minecraft.class_8567;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class EnderAirBottleEntity extends class_1682 implements class_3856 {
	public static final int PARTICLE_COLOR = 0x000008;
	private static final class_2960 GHAST_LOOT_TABLE = prefix("ghast_ender_air_crying");

	public EnderAirBottleEntity(class_1299<EnderAirBottleEntity> type, class_1937 world) {
		super(type, world);
	}

	public EnderAirBottleEntity(class_1309 entity, class_1937 world) {
		super(BotaniaEntities.ENDER_AIR_BOTTLE, entity, world);
	}

	public EnderAirBottleEntity(double x, double y, double z, class_1937 world) {
		super(BotaniaEntities.ENDER_AIR_BOTTLE, x, y, z, world);
	}

	private void convertBlock(@NotNull class_2338 pos) {
		List<class_2338> coordsList = getCoordsToPut(pos);
		this.method_37908().method_20290(class_6088.field_31145, method_24515(), PARTICLE_COLOR);

		for (class_2338 coords : coordsList) {
			this.method_37908().method_8501(coords, class_2246.field_10471.method_9564());
			if (Math.random() < 0.1) {
				this.method_37908().method_20290(class_6088.field_31144, coords, class_2248.method_9507(class_2246.field_10471.method_9564()));
			}
		}
	}

	@Override
	protected void method_24920(@NotNull class_3965 result) {
		super.method_24920(result);
		if (method_37908().field_9236) {
			return;
		}
		convertBlock(result.method_17777());
		method_31472();
	}

	@Override
	protected void method_7454(@NotNull class_3966 result) {
		super.method_7454(result);
		if (this.method_37908().field_9236) {
			return;
		}
		class_1297 entity = result.method_17782();
		if (entity.method_5864() == class_1299.field_6107 && this.method_37908().method_27983() == class_1937.field_25179) {
			this.method_37908().method_20290(class_6088.field_31145, method_24515(), PARTICLE_COLOR);
			class_1282 source = entity.method_48923().method_48811(this, method_24921());
			entity.method_5643(source, 0);

			// Ghasts render as if they are looking straight ahead, but the look y component
			// can actually be nonzero, correct for that
			class_243 lookVec = entity.method_5720();
			class_243 vec = new class_243(lookVec.method_10216(), 0, lookVec.method_10215()).method_1029();

			// Position chosen to appear roughly in the ghast's face
			((class_3218) this.method_37908()).method_14199(new class_2392(class_2398.field_11218, new class_1799(class_1802.field_8070)),
					entity.method_23317() + (2.3 * vec.field_1352), entity.method_23318() + vec.field_1351 + 2.6, entity.method_23321() + (2.3 * vec.field_1350),
					40,
					Math.abs(vec.field_1350) + 0.15, 0.2, Math.abs(vec.field_1352) + 0.15, 0.2);

			class_52 table = this.method_37908().method_8503().method_3857().getLootTable(GHAST_LOOT_TABLE);
			class_8567.class_8568 builder = new class_8567.class_8568(((class_3218) method_37908()));
			builder.method_51874(class_181.field_1226, entity);
			builder.method_51874(class_181.field_24424, entity.method_19538());
			builder.method_51874(class_181.field_1231, source);

			class_8567 context = builder.method_51875(class_173.field_1173);
			for (class_1799 stack : table.method_51878(context)) {
				class_1542 item = entity.method_5699(stack, 2);
				item.method_18799(item.method_18798().method_1019(vec.method_1021(0.4)));
			}
		} else {
			convertBlock(class_2338.method_49638(result.method_17784()));
		}
		method_31472();
	}

	private List<class_2338> getCoordsToPut(class_2338 pos) {
		List<class_2338> possibleCoords = new ArrayList<>();
		int range = 4;
		int rangeY = 4;

		for (class_2338 bPos : class_2338.method_10097(pos.method_10069(-range, -rangeY, -range),
				pos.method_10069(range, rangeY, range))) {
			class_2680 state = method_37908().method_8320(bPos);
			if (state.method_26164(BotaniaTags.Blocks.ENDER_AIR_CONVERTABLE)) {
				possibleCoords.add(bPos.method_10062());
			}
		}

		Collections.shuffle(possibleCoords);

		if (possibleCoords.size() > 64) {
			return possibleCoords.subList(0, 64);
		} else {
			return possibleCoords;
		}
	}

	@Override
	protected void method_5693() {}

	@NotNull
	@Override
	public class_1799 method_7495() {
		return new class_1799(BotaniaItems.enderAirBottle);
	}
}
