package vazkii.botania.fabric.xplat;

import com.jamieswhiteshirt.reachentityattributes.ReachEntityAttributes;

import dev.emi.stepheightentityattribute.StepHeightEntityAttributeMain;

import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.object.builder.v1.block.type.BlockSetTypeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.block.type.WoodTypeRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidConstants;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.base.SingleStackStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1541;
import net.minecraft.class_1542;
import net.minecraft.class_1548;
import net.minecraft.class_1621;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1688;
import net.minecraft.class_1703;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2356;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2498;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2609;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3414;
import net.minecraft.class_3611;
import net.minecraft.class_3695;
import net.minecraft.class_3902;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_4174;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_8177;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.BotaniaFabricCapabilities;
import vazkii.botania.api.block.*;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.api.corporea.CorporeaIndexRequestCallback;
import vazkii.botania.api.corporea.CorporeaRequestCallback;
import vazkii.botania.api.corporea.CorporeaRequestMatcher;
import vazkii.botania.api.corporea.CorporeaSpark;
import vazkii.botania.api.item.AvatarWieldable;
import vazkii.botania.api.item.BlockProvider;
import vazkii.botania.api.item.CoordBoundItem;
import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.*;
import vazkii.botania.api.mana.spark.SparkAttachable;
import vazkii.botania.api.recipe.ElvenPortalUpdateCallback;
import vazkii.botania.common.block.block_entity.red_string.RedStringContainerBlockEntity;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.internal_caps.*;
import vazkii.botania.common.item.equipment.CustomDamageItem;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.lib.LibMisc;
import vazkii.botania.fabric.block.FabricSpecialFlowerBlock;
import vazkii.botania.fabric.block_entity.FabricRedStringContainerBlockEntity;
import vazkii.botania.fabric.integration.tr_energy.FluxfieldTRStorage;
import vazkii.botania.fabric.integration.trinkets.TrinketsIntegration;
import vazkii.botania.fabric.internal_caps.CCAInternalEntityComponents;
import vazkii.botania.fabric.mixin.AbstractFurnaceBlockEntityFabricAccessor;
import vazkii.botania.fabric.mixin.BucketItemFabricAccessor;
import vazkii.botania.network.BotaniaPacket;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class FabricXplatImpl implements XplatAbstractions {
	@Override
	public boolean isFabric() {
		return true;
	}

	@Override
	public boolean isModLoaded(String modId) {
		return FabricLoader.getInstance().isModLoaded(modId);
	}

	@Override
	public boolean isDevEnvironment() {
		return FabricLoader.getInstance().isDevelopmentEnvironment();
	}

	@Override
	public boolean isPhysicalClient() {
		return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
	}

	@Override
	public String getBotaniaVersion() {
		return FabricLoader.getInstance().getModContainer(LibMisc.MOD_ID).get()
				.getMetadata().getVersion().getFriendlyString();
	}

	@Nullable
	@Override
	public AvatarWieldable findAvatarWieldable(class_1799 stack) {
		return BotaniaFabricCapabilities.AVATAR_WIELDABLE.find(stack, class_3902.field_17274);
	}

	@Nullable
	@Override
	public BlockProvider findBlockProvider(class_1799 stack) {
		return BotaniaFabricCapabilities.BLOCK_PROVIDER.find(stack, class_3902.field_17274);
	}

	@Nullable
	@Override
	public CoordBoundItem findCoordBoundItem(class_1799 stack) {
		return BotaniaFabricCapabilities.COORD_BOUND_ITEM.find(stack, class_3902.field_17274);
	}

	@Nullable
	@Override
	public ManaItem findManaItem(class_1799 stack) {
		return BotaniaFabricCapabilities.MANA_ITEM.find(stack, class_3902.field_17274);
	}

	@Nullable
	@Override
	public Relic findRelic(class_1799 stack) {
		return BotaniaFabricCapabilities.RELIC.find(stack, class_3902.field_17274);
	}

	@Nullable
	@Override
	public ExoflameHeatable findExoflameHeatable(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_2586 be) {
		return BotaniaFabricCapabilities.EXOFLAME_HEATABLE.find(level, pos, state, be, class_3902.field_17274);
	}

	@Nullable
	@Override
	public HornHarvestable findHornHarvestable(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_2586 be) {
		return BotaniaFabricCapabilities.HORN_HARVEST.find(level, pos, state, be, class_3902.field_17274);
	}

	@Nullable
	@Override
	public HourglassTrigger findHourglassTrigger(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_2586 be) {
		return BotaniaFabricCapabilities.HOURGLASS_TRIGGER.find(level, pos, state, be, class_3902.field_17274);
	}

	@Nullable
	@Override
	public ManaCollisionGhost findManaGhost(class_1937 level, class_2338 pos, class_2680 state, @org.jetbrains.annotations.Nullable class_2586 be) {
		return BotaniaFabricCapabilities.MANA_GHOST.find(level, pos, state, be, class_3902.field_17274);
	}

	@Nullable
	@Override
	public ManaReceiver findManaReceiver(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_2586 be, class_2350 direction) {
		return BotaniaFabricCapabilities.MANA_RECEIVER.find(level, pos, state, be, direction);
	}

	@Nullable
	@Override
	public SparkAttachable findSparkAttachable(class_1937 level, class_2338 pos, class_2680 blockState, @Nullable class_2586 be, class_2350 direction) {
		return BotaniaFabricCapabilities.SPARK_ATTACHABLE.find(level, pos, blockState, be, direction);
	}

	@Nullable
	@Override
	public ManaTrigger findManaTrigger(class_1937 level, class_2338 pos, class_2680 state, @org.jetbrains.annotations.Nullable class_2586 be) {
		return BotaniaFabricCapabilities.MANA_TRIGGER.find(level, pos, state, be, class_3902.field_17274);
	}

	@Nullable
	@Override
	public Wandable findWandable(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_2586 be) {
		return BotaniaFabricCapabilities.WANDABLE.find(level, pos, state, be, class_3902.field_17274);
	}

	@Nullable
	@Override
	public PhantomInkableBlock findPhantomInkable(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_2586 be) {
		return BotaniaFabricCapabilities.PHANTOM_INKABLE.find(level, pos, state, be, class_3902.field_17274);
	}

	private static class SingleStackEntityStorage extends SingleStackStorage {
		private final class_1542 entity;

		private SingleStackEntityStorage(class_1542 entity) {
			this.entity = entity;
		}

		@Override
		protected class_1799 getStack() {
			return entity.method_6983();
		}

		@Override
		protected void setStack(class_1799 stack) {
			entity.method_6979(stack);
		}
	}

	@Override
	public boolean isFluidContainer(class_1542 item) {
		return ContainerItemContext.ofSingleSlot(new SingleStackEntityStorage(item)).find(FluidStorage.ITEM) != null;
	}

	@Override
	public boolean extractFluidFromItemEntity(class_1542 item, class_3611 fluid) {
		var fluidStorage = ContainerItemContext.ofSingleSlot(new SingleStackEntityStorage(item)).find(FluidStorage.ITEM);
		if (fluidStorage == null) {
			return false;
		}
		try (Transaction txn = Transaction.openOuter()) {
			long extracted = fluidStorage.extract(FluidVariant.of(fluid), FluidConstants.BLOCK, txn);
			if (extracted == FluidConstants.BLOCK) {
				txn.commit();
				return true;
			}
		}
		return false;
	}

	@Override
	public boolean extractFluidFromPlayerItem(class_1657 player, class_1268 hand, class_3611 fluid) {
		var fluidStorage = ContainerItemContext.ofPlayerHand(player, hand).find(FluidStorage.ITEM);
		if (fluidStorage == null) {
			return false;
		}
		try (Transaction txn = Transaction.openOuter()) {
			long extracted = fluidStorage.extract(FluidVariant.of(fluid), FluidConstants.BUCKET, txn);
			if (extracted == FluidConstants.BUCKET) {
				if (!player.method_31549().field_7477) {
					// Only perform inventory side effects in survival
					txn.commit();
				}
				return true;
			}
		}
		return false;
	}

	@Override
	public boolean insertFluidIntoPlayerItem(class_1657 player, class_1268 hand, class_3611 fluid) {
		var fluidStorage = ContainerItemContext.ofPlayerHand(player, hand).find(FluidStorage.ITEM);

		if (fluidStorage == null) {
			return false;
		}

		try (Transaction txn = Transaction.openOuter()) {
			long inserted = fluidStorage.insert(FluidVariant.of(fluid), FluidConstants.BUCKET, txn);
			if (inserted == FluidConstants.BUCKET) {
				if (!player.method_31549().field_7477) {
					// Only perform inventory side effects in survival
					txn.commit();
				}
				return true;
			}
		}

		return false;
	}

	@Override
	public boolean hasInventory(class_1937 level, class_2338 pos, class_2350 sideOfPos) {
		var state = level.method_8320(pos);
		var be = level.method_8321(pos);
		return ItemStorage.SIDED.find(level, pos, state, be, sideOfPos) != null;
	}

	@Override
	public class_1799 insertToInventory(class_1937 level, class_2338 pos, class_2350 sideOfPos, class_1799 toInsert, boolean simulate) {
		if (toInsert.method_7960()) {
			//It is valid for Storage#insert implementations to crash when provided empty variants
			return toInsert;
		}

		var state = level.method_8320(pos);
		var be = level.method_8321(pos);
		var storage = ItemStorage.SIDED.find(level, pos, state, be, sideOfPos);
		if (storage == null) {
			return toInsert;
		}

		var itemVariant = ItemVariant.of(toInsert);
		try (Transaction txn = Transaction.openOuter()) {
			// Truncation to int ok since the value passed in was an int
			// and that value should only decrease or stay same
			int inserted;
			if (state.method_26164(BotaniaTags.Blocks.SINGLE_ITEM_INSERT)) {
				int alreadyInserted = 0;
				for (int i = 0; i < toInsert.method_7947(); i++) {
					alreadyInserted += (int) storage.insert(itemVariant, 1L, txn);
				}
				inserted = alreadyInserted;
			} else {
				inserted = (int) storage.insert(itemVariant, toInsert.method_7947(), txn);
			}
			if (!simulate) {
				txn.commit();
			}

			if (inserted == toInsert.method_7947()) {
				return class_1799.field_8037;
			} else {
				var ret = toInsert.method_7972();
				ret.method_7939(toInsert.method_7947() - inserted);
				return ret;
			}
		}
	}

	@Override
	public EthicalComponent ethicalComponent(class_1541 tnt) {
		return CCAInternalEntityComponents.TNT_ETHICAL.get(tnt);
	}

	@Override
	public SpectralRailComponent ghostRailComponent(class_1688 cart) {
		return CCAInternalEntityComponents.GHOST_RAIL.get(cart);
	}

	@Override
	public ItemFlagsComponent itemFlagsComponent(class_1542 item) {
		return CCAInternalEntityComponents.INTERNAL_ITEM.get(item);
	}

	@Override
	public KeptItemsComponent keptItemsComponent(class_1657 player, boolean reviveCaps) {
		return CCAInternalEntityComponents.KEPT_ITEMS.get(player);
	}

	@Nullable
	@Override
	public LooniumComponent looniumComponent(class_1309 entity) {
		return CCAInternalEntityComponents.LOONIUM_DROP.getNullable(entity);
	}

	@Override
	public NarslimmusComponent narslimmusComponent(class_1621 slime) {
		return CCAInternalEntityComponents.NARSLIMMUS.get(slime);
	}

	@Override
	public TigerseyeComponent tigersEyeComponent(class_1548 creeper) {
		return CCAInternalEntityComponents.TIGERSEYE.get(creeper);
	}

	@Override
	public boolean fireCorporeaRequestEvent(CorporeaRequestMatcher matcher, int itemCount, CorporeaSpark spark, boolean dryRun) {
		return CorporeaRequestCallback.EVENT.invoker().onRequest(matcher, itemCount, spark, dryRun);
	}

	@Override
	public boolean fireCorporeaIndexRequestEvent(class_3222 player, CorporeaRequestMatcher request, int count, CorporeaSpark spark) {
		return CorporeaIndexRequestCallback.EVENT.invoker().onIndexRequest(player, request, count, spark);
	}

	@Override
	public void fireManaItemEvent(class_1657 player, List<class_1799> toReturn) {
		ManaItemsCallback.EVENT.invoker().getManaItems(player, toReturn);
	}

	@Override
	public float fireManaDiscountEvent(class_1657 player, float discount, class_1799 tool) {
		return ManaDiscountCallback.EVENT.invoker().getManaDiscount(player, discount, tool);
	}

	@Override
	public boolean fireManaProficiencyEvent(class_1657 player, class_1799 tool, boolean proficient) {
		return ManaProficiencyCallback.EVENT.invoker().getProficient(player, tool, proficient);
	}

	@Override
	public void fireElvenPortalUpdateEvent(class_2586 portal, class_238 bounds, boolean open, List<class_1799> stacksInside) {
		ElvenPortalUpdateCallback.EVENT.invoker().onElvenPortalTick(portal, bounds, open, stacksInside);
	}

	@Override
	public void fireManaNetworkEvent(ManaReceiver thing, ManaBlockType type, ManaNetworkAction action) {
		ManaNetworkCallback.EVENT.invoker().onNetworkChange(thing, type, action);
	}

	@Override
	public class_2596<class_2602> toVanillaClientboundPacket(BotaniaPacket packet) {
		return ServerPlayNetworking.createS2CPacket(packet.getFabricId(), packet.toBuf());
	}

	@Override
	public void sendToPlayer(class_1657 player, BotaniaPacket packet) {
		if (player instanceof class_3222 serverPlayer) {
			ServerPlayNetworking.send(serverPlayer, packet.getFabricId(), packet.toBuf());
		}
	}

	@Override
	public void sendToNear(class_1937 level, class_2338 pos, BotaniaPacket packet) {
		var pkt = ServerPlayNetworking.createS2CPacket(packet.getFabricId(), packet.toBuf());
		for (var player : PlayerLookup.tracking((class_3218) level, pos)) {
			if (player.method_5649(pos.method_10263(), pos.method_10264(), pos.method_10260()) < 64 * 64) {
				player.field_13987.method_14364(pkt);
			}
		}
	}

	@Override
	public void sendToTracking(class_1297 e, BotaniaPacket packet) {
		var pkt = ServerPlayNetworking.createS2CPacket(packet.getFabricId(), packet.toBuf());
		PlayerLookup.tracking(e).forEach(p -> p.field_13987.method_14364(pkt));
		if (e instanceof class_3222) {
			((class_3222) e).field_13987.method_14364(pkt);
		}
	}

	@Override
	public boolean isSpecialFlowerBlock(class_2248 b) {
		return b instanceof FabricSpecialFlowerBlock;
	}

	@Override
	public class_2356 createSpecialFlowerBlock(class_1291 effect, int effectDuration, class_4970.class_2251 props, Supplier<class_2591<? extends SpecialFlowerBlockEntity>> beType, boolean hasComparatorOutput) {
		return new FabricSpecialFlowerBlock(effect, effectDuration, props, beType, hasComparatorOutput);
	}

	@Override
	public <T extends class_2586> class_2591<T> createBlockEntityType(BiFunction<class_2338, class_2680, T> func, class_2248... blocks) {
		return FabricBlockEntityTypeBuilder.create(func::apply, blocks).build();
	}

	@Override
	public void registerReloadListener(class_3264 type, class_2960 id, class_3302 listener) {
		ResourceManagerHelper.get(type).registerReloadListener(new IdentifiableResourceReloadListener() {
			@Override
			public CompletableFuture<Void> method_25931(class_4045 barrier, class_3300 manager, class_3695 prepProfiler,
					class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
				return listener.method_25931(barrier, manager, prepProfiler, reloadProfiler, backgroundExecutor, gameExecutor);
			}

			@Override
			public class_2960 getFabricId() {
				return id;
			}
		});
	}

	@Override
	public FabricItemSettings defaultItemBuilder() {
		return new FabricItemSettings();
	}

	@Override
	public class_1792.class_1793 defaultItemBuilderWithCustomDamageOnFabric() {
		return defaultItemBuilder().customDamage((stack, amount, entity, breakCallback) -> {
			var item = stack.method_7909();
			if (item instanceof CustomDamageItem cd) {
				return cd.damageItem(stack, amount, entity, breakCallback);
			}
			return amount;
		});
	}

	@Override
	public <T extends class_1703> class_3917<T> createMenuType(TriFunction<Integer, class_1661, class_2540, T> constructor) {
		return new ExtendedScreenHandlerType<>(constructor::apply);
	}

	@Nullable
	@Override
	public EquipmentHandler tryCreateEquipmentHandler() {
		if (isModLoaded("trinkets")) {
			TrinketsIntegration.init();
			return new TrinketsIntegration();
		}
		return null;
	}

	@Override
	public void openMenu(class_3222 player, class_3908 menu, Consumer<class_2540> writeInitialData) {
		var menuProvider = new ExtendedScreenHandlerFactory() {
			@Nullable
			@Override
			public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
				return menu.createMenu(id, inventory, player);
			}

			@Override
			public class_2561 method_5476() {
				return menu.method_5476();
			}

			@Override
			public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
				writeInitialData.accept(buf);
			}
		};
		player.method_17355(menuProvider);
	}

	@Override
	public class_1320 getReachDistanceAttribute() {
		return ReachEntityAttributes.REACH;
	}

	@Override
	public class_1320 getStepHeightAttribute() {
		return StepHeightEntityAttributeMain.STEP_HEIGHT;
	}

	private final class_6862<class_2248> oreTag = class_6862.method_40092(class_7924.field_41254, new class_2960("c", "ores"));

	@Override
	public class_6862<class_2248> getOreTag() {
		return oreTag;
	}

	// No standard so we have to check both :wacko:
	private final class_6862<class_2248> cGlass = class_6862.method_40092(class_7924.field_41254, new class_2960("c", "glass"));
	private final class_6862<class_2248> cGlassBlocks = class_6862.method_40092(class_7924.field_41254, new class_2960("c", "glass_blocks"));
	private final class_6862<class_2248> cGlassPanes = class_6862.method_40092(class_7924.field_41254, new class_2960("c", "glass_panes"));

	@Override
	public boolean isInGlassTag(class_2680 state) {
		return state.method_26164(cGlass) || state.method_26164(cGlassBlocks) || state.method_26164(cGlassPanes);
	}

	@Override
	public boolean canFurnaceBurn(class_2609 furnace, @Nullable class_1860<?> recipe, class_2371<class_1799> items, int maxStackSize) {
		return AbstractFurnaceBlockEntityFabricAccessor.callCanBurn(furnace.method_10997().method_30349(), recipe, items, maxStackSize);
	}

	@Override
	public class_3611 getBucketFluid(class_1755 item) {
		return ((BucketItemFabricAccessor) item).getContent();
	}

	@Override
	public int getSmeltingBurnTime(class_1799 stack) {
		Integer v = FuelRegistry.INSTANCE.get(stack.method_7909());
		return v == null ? 0 : v;
	}

	@Override
	public boolean preventsRemoteMovement(class_1542 entity) {
		return false;
	}

	public static final Map<class_2248, class_2248> CUSTOM_STRIPPING = new LinkedHashMap<>();

	@Override
	public void addAxeStripping(class_2248 input, class_2248 output) {
		if (input.method_9595().method_11659().contains(class_2741.field_12496)
				&& output.method_9595().method_11659().contains(class_2741.field_12496)) {
			StrippableBlockRegistry.register(input, output);
		} else {
			CUSTOM_STRIPPING.put(input, output);
		}
	}

	@Override
	public int transferEnergyToNeighbors(class_1937 level, class_2338 pos, int energy) {
		if (isModLoaded("team_reborn_energy")) {
			return FluxfieldTRStorage.transferEnergyToNeighbors(level, pos, energy);
		}
		return energy;
	}

	@Nullable
	@Override
	public class_4174 getFoodProperties(class_1799 stack) {
		return stack.method_7909().method_19264();
	}

	@Override
	public boolean canToolLightFire(class_1799 stack) {
		return stack.method_31574(class_1802.field_8884);
	}

	@Override
	public boolean isRedStringContainerTarget(class_2586 be) {
		if (be.method_10997().field_9236) {
			return false;
		}
		for (class_2350 value : class_2350.values()) {
			if (ItemStorage.SIDED.find(be.method_10997(), be.method_11016(), be.method_11010(), be, value) != null) {
				return true;
			}
		}
		return false;
	}

	@Override
	public RedStringContainerBlockEntity newRedStringContainer(class_2338 pos, class_2680 state) {
		return new FabricRedStringContainerBlockEntity(pos, state);
	}

	@Override
	public class_8177 registerBlockSetType(String name, boolean canOpenByHand, class_2498 soundType, class_3414 doorClose, class_3414 doorOpen, class_3414 trapdoorClose, class_3414 trapdoorOpen, class_3414 pressurePlateClickOff, class_3414 pressurePlateClickOn, class_3414 buttonClickOff, class_3414 buttonClickOn) {
		return BlockSetTypeRegistry.register(prefix(name), canOpenByHand, soundType, doorClose, doorOpen, trapdoorClose, trapdoorOpen, pressurePlateClickOff, pressurePlateClickOn, buttonClickOff, buttonClickOn);
	}

	@Override
	public class_4719 registerWoodType(String name, class_8177 setType, class_2498 soundType, class_2498 hangingSignSoundType, class_3414 fenceGateClose, class_3414 fenceGateOpen) {
		return WoodTypeRegistry.register(prefix(name), setType, soundType, hangingSignSoundType, fenceGateClose, fenceGateOpen);
	}
}
