/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity;

import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import vazkii.botania.api.block.FloatingFlower;
import vazkii.botania.api.block.FloatingFlowerImpl;
import vazkii.botania.api.block.FloatingFlowerProvider;
import vazkii.botania.common.annotations.SoftImplement;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.decor.FloatingFlowerBlock;

public class FloatingFlowerBlockEntity extends BotaniaBlockEntity implements FloatingFlowerProvider {
	private static final String TAG_FLOATING_DATA = "floating";
	private final FloatingFlower floatingData = new FloatingFlowerImpl() {
		@Override
		public class_1799 getDisplayStack() {
			class_2248 b = method_11010().method_26204();
			if (b instanceof FloatingFlowerBlock floatingFlower) {
				return new class_1799(BotaniaBlocks.getShinyFlower(floatingFlower.color));
			} else {
				return class_1799.field_8037;
			}
		}
	};

	public FloatingFlowerBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaBlockEntities.MINI_ISLAND, pos, state);
	}

	@Override
	public FloatingFlower getFloatingData() {
		return floatingData;
	}

	@Override
	public void writePacketNBT(class_2487 cmp) {
		cmp.method_10566(TAG_FLOATING_DATA, floatingData.writeNBT());
	}

	@Override
	public void readPacketNBT(class_2487 cmp) {
		FloatingFlower.IslandType oldType = floatingData.getIslandType();
		floatingData.readNBT(cmp.method_10562(TAG_FLOATING_DATA));
		if (oldType != floatingData.getIslandType() && field_11863 != null && field_11863.field_9236) {
			field_11863.method_8413(method_11016(), method_11010(), method_11010(), 0);
		}
	}

	@SoftImplement("RenderDataBlockEntity")
	public Object getRenderData() {
		return floatingData.getIslandType();
	}
}
