/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.mana.spark;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_238;

public final class SparkHelper {

	public static final int SPARK_SCAN_RANGE = 12;

	public static List<ManaSpark> getSparksAround(class_1937 world, double x, double y, double z, class_1767 color) {
		int r = SPARK_SCAN_RANGE;
		Predicate<class_1297> predicate = e -> e instanceof ManaSpark spark && spark.getNetwork() == color;
		@SuppressWarnings("unchecked")
		List<ManaSpark> entities = (List<ManaSpark>) (List<?>) world.method_8390(class_1297.class, new class_238(x - r, y - r, z - r, x + r, y + r, z + r), predicate);
		return entities;
	}

}
