/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.fabric.mixin;

import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.tool.VitreousPickaxeItem;
import vazkii.botania.common.item.equipment.tool.elementium.ElementiumShovelItem;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraShattererItem;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraTruncatorItem;

@Mixin(class_3225.class)
public class ServerPlayerGameModeFabricMixin {
	@Shadow
	@Final
	protected class_3222 player;

	@Inject(method = "destroyBlock", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/block/Block;playerWillDestroy(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/entity/player/Player;)V"))
	private void onStartBreak(class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
		class_3222 player = this.player;
		class_1799 stack = player.method_6047();
		if (stack.method_31574(BotaniaItems.terraAxe)) {
			((TerraTruncatorItem) BotaniaItems.terraAxe).onBlockStartBreak(stack, pos, player);
		} else if (stack.method_31574(BotaniaItems.terraPick)) {
			((TerraShattererItem) BotaniaItems.terraPick).onBlockStartBreak(stack, pos, player);
		} else if (stack.method_31574(BotaniaItems.elementiumShovel)) {
			((ElementiumShovelItem) BotaniaItems.elementiumShovel).onBlockStartBreak(stack, pos, player);
		} else if (stack.method_31574(BotaniaItems.glassPick)) {
			((VitreousPickaxeItem) BotaniaItems.glassPick).onBlockStartBreak(stack, pos, player);
		}
	}
}
