/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.flower.generating;

import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1621;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2919;
import net.minecraft.class_3218;
import net.minecraft.class_3532;

public class NarslimmusBlockEntity extends GeneratingFlowerBlockEntity {

	private static final int RANGE = 2;
	private static final int MAX_MANA = manaForSize(4);
	public static final int MANA_BASE = 1200;
	public static final int MANA_BASE_GOG = MANA_BASE / 4;

	public NarslimmusBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaFlowerBlocks.NARSLIMMUS, pos, state);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (ticksExisted % 5 == 0) {
			List<class_1621> slimes = method_10997().method_18467(class_1621.class, new class_238(getEffectivePos().method_10069(-RANGE, -RANGE, -RANGE), getEffectivePos().method_10069(RANGE + 1, RANGE + 1, RANGE + 1)));
			for (class_1621 slime : slimes) {
				if (slime.method_5805() && XplatAbstractions.INSTANCE.narslimmusComponent(slime).isNaturalSpawned()) {
					int size = slime.method_7152();
					if (!slime.method_37908().field_9236) {
						slime.method_31472();
						slime.method_5783(size > 1 ? BotaniaSounds.narslimmusEatBig : BotaniaSounds.narslimmusEatSmall, 1F, 1F);
						addMana(manaForSize(size));
						sync();
					}

					int times = 8 * (int) Math.pow(2, size);
					for (int j = 0; j < times; ++j) {
						float f = slime.method_37908().field_9229.method_43057() * (float) Math.PI * 2.0F;
						float f1 = slime.method_37908().field_9229.method_43057() * 0.5F + 0.5F;
						float f2 = class_3532.method_15374(f) * size * 0.5F * f1;
						float f3 = class_3532.method_15362(f) * size * 0.5F * f1;
						float f4 = slime.method_37908().field_9229.method_43057() * size * 0.5F * f1;
						slime.method_37908().method_8406(class_2398.field_11246, slime.method_23317() + f2, slime.method_5829().field_1322 + f4, slime.method_23321() + f3, 0.0D, 0.0D, 0.0D);
					}
					break;
				}
			}
		}
	}

	private static int manaForSize(int size) {
		size = Math.min(size, 4);
		return (XplatAbstractions.INSTANCE.gogLoaded() ? MANA_BASE_GOG : MANA_BASE) * (int) Math.pow(2, size);
	}

	@Override
	public RadiusDescriptor getRadius() {
		return RadiusDescriptor.Rectangle.square(getEffectivePos(), RANGE);
	}

	@Override
	public int getMaxMana() {
		return MAX_MANA;
	}

	@Override
	public int getColor() {
		return 0x71C373;
	}

	public static void onSpawn(class_1297 entity) {
		boolean slimeChunk = isSlimeChunk(entity.method_37908(), entity.method_23317(), entity.method_23321());
		if (slimeChunk) {
			entity.method_24204().forEach(e -> {
				if (e instanceof class_1621 slime) {
					XplatAbstractions.INSTANCE.narslimmusComponent(slime).setNaturalSpawn(true);
				}
			});
		}
	}

	private static boolean isSlimeChunk(class_1937 world, double x, double z) {
		return isSlimeChunk(world, class_2338.method_49637(x, 0, z));
	}

	public static boolean isSlimeChunk(class_1937 world, class_2338 pos) {
		class_1923 chunkpos = new class_1923(pos);
		return class_2919.method_12662(chunkpos.field_9181, chunkpos.field_9180, ((class_3218) world).method_8412(), 987234911L).method_43048(10) == 0;
	}

}
