/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.lens;

import java.util.List;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.common.item.lens.Lens;

public class DamagingLens
extends Lens {
    @Override
    public void updateBurst(ManaBurst burst, ItemStack stack) {
        ThrowableProjectile entity = burst.entity();
        if (entity.level().isClientSide) {
            return;
        }
        AABB axis = new AABB(entity.getX(), entity.getY(), entity.getZ(), entity.xOld, entity.yOld, entity.zOld).inflate(1.0);
        List entities = entity.level().getEntitiesOfClass(LivingEntity.class, axis);
        for (LivingEntity living : entities) {
            int mana;
            if (living instanceof Player || living.hurtTime != 0 || (mana = burst.getMana()) < 16) continue;
            burst.setMana(mana - 16);
            if (burst.isFake()) break;
            DamageSource src = entity.getOwner() != null ? entity.damageSources().indirectMagic((Entity)entity, entity.getOwner()) : entity.damageSources().magic();
            living.hurt(src, 8.0f);
            break;
        }
    }
}

