/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;

public class ElvenTradeRecipe
implements vazkii.botania.api.recipe.ElvenTradeRecipe {
    private final ResourceLocation id;
    private final ImmutableList<ItemStack> outputs;
    private final NonNullList<Ingredient> inputs;

    public ElvenTradeRecipe(ResourceLocation id, ItemStack[] outputs, Ingredient ... inputs) {
        this.id = id;
        this.outputs = ImmutableList.copyOf((Object[])outputs);
        this.inputs = NonNullList.create();
        this.inputs.addAll(Arrays.asList(inputs));
    }

    @Override
    public Optional<List<ItemStack>> match(List<ItemStack> stacks) {
        ArrayList<Ingredient> inputsMissing = new ArrayList<Ingredient>((Collection<Ingredient>)this.inputs);
        ArrayList<ItemStack> stacksToRemove = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            if (stack.isEmpty()) continue;
            if (inputsMissing.isEmpty()) break;
            int stackIndex = -1;
            for (int i = 0; i < inputsMissing.size(); ++i) {
                Ingredient ingr = (Ingredient)inputsMissing.get(i);
                if (!ingr.test(stack)) continue;
                if (!stacksToRemove.contains(stack)) {
                    stacksToRemove.add(stack);
                }
                stackIndex = i;
                break;
            }
            if (stackIndex == -1) continue;
            inputsMissing.remove(stackIndex);
        }
        return inputsMissing.isEmpty() ? Optional.of(stacksToRemove) : Optional.empty();
    }

    @Override
    public boolean containsItem(ItemStack stack) {
        for (Ingredient input : this.inputs) {
            if (!input.test(stack)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return BotaniaRecipeTypes.ELVEN_TRADE_SERIALIZER;
    }

    @Override
    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.inputs;
    }

    @NotNull
    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)BotaniaBlocks.alfPortal);
    }

    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    @Override
    public List<ItemStack> getOutputs(List<ItemStack> inputs) {
        return this.getOutputs();
    }

    public static class Serializer
    implements RecipeSerializer<ElvenTradeRecipe> {
        @NotNull
        public ElvenTradeRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            JsonElement output = json.get("output");
            ArrayList<ItemStack> outputStacks = new ArrayList<ItemStack>();
            if (output.isJsonArray()) {
                for (JsonElement e : output.getAsJsonArray()) {
                    JsonObject o = GsonHelper.convertToJsonObject((JsonElement)e, (String)"output stack");
                    outputStacks.add(ShapedRecipe.itemStackFromJson((JsonObject)o));
                }
            } else {
                JsonObject o = GsonHelper.convertToJsonObject((JsonElement)output, (String)"output stack");
                outputStacks.add(ShapedRecipe.itemStackFromJson((JsonObject)o));
            }
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            for (JsonElement e : GsonHelper.getAsJsonArray((JsonObject)json, (String)"ingredients")) {
                Ingredient ing = Ingredient.fromJson((JsonElement)e);
                if (ing.isEmpty()) continue;
                inputs.add(ing);
            }
            return new ElvenTradeRecipe(id, outputStacks.toArray(new ItemStack[0]), inputs.toArray(new Ingredient[0]));
        }

        public ElvenTradeRecipe fromNetwork(@NotNull ResourceLocation id, FriendlyByteBuf buf) {
            Ingredient[] inputs = new Ingredient[buf.readVarInt()];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = Ingredient.fromNetwork((FriendlyByteBuf)buf);
            }
            ItemStack[] outputs = new ItemStack[buf.readVarInt()];
            for (int i = 0; i < outputs.length; ++i) {
                outputs[i] = buf.readItem();
            }
            return new ElvenTradeRecipe(id, outputs, inputs);
        }

        public void toNetwork(FriendlyByteBuf buf, ElvenTradeRecipe recipe) {
            buf.writeVarInt(recipe.getIngredients().size());
            for (Ingredient input : recipe.getIngredients()) {
                input.toNetwork(buf);
            }
            buf.writeVarInt(recipe.getOutputs().size());
            for (ItemStack output : recipe.getOutputs()) {
                buf.writeItem(output);
            }
        }
    }
}

