/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.network.clientbound;

import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.client.gui.ItemsRemainingRenderHandler;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.network.BotaniaPacket;

public record UpdateItemsRemainingPacket(ItemStack stack, int count, @Nullable Component tooltip) implements BotaniaPacket
{
    public static final ResourceLocation ID = ResourceLocationHelper.prefix("rem");

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeItem(this.stack);
        buf.writeVarInt(this.count);
        buf.writeBoolean(this.tooltip != null);
        if (this.tooltip != null) {
            buf.writeComponent(this.tooltip);
        }
    }

    @Override
    public ResourceLocation getFabricId() {
        return ID;
    }

    public static UpdateItemsRemainingPacket decode(FriendlyByteBuf buf) {
        return new UpdateItemsRemainingPacket(buf.readItem(), buf.readVarInt(), buf.readBoolean() ? buf.readComponent() : null);
    }

    public static class Handler {
        public static void handle(UpdateItemsRemainingPacket packet) {
            ItemStack stack = packet.stack();
            int count = packet.count();
            Component tooltip = packet.tooltip();
            Minecraft.getInstance().execute(() -> ItemsRemainingRenderHandler.set(stack, count, tooltip));
        }
    }
}

