/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.emi;

import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.StringUtils;
import vazkii.botania.api.recipe.BotanicalBreweryRecipe;
import vazkii.botania.api.recipe.ElvenTradeRecipe;
import vazkii.botania.api.recipe.ManaInfusionRecipe;
import vazkii.botania.api.recipe.OrechidRecipe;
import vazkii.botania.api.recipe.PetalApothecaryRecipe;
import vazkii.botania.api.recipe.PureDaisyRecipe;
import vazkii.botania.api.recipe.RunicAltarRecipe;
import vazkii.botania.api.recipe.TerrestrialAgglomerationRecipe;
import vazkii.botania.client.core.handler.CorporeaInputHandler;
import vazkii.botania.client.integration.emi.AncientWillEmiRecipe;
import vazkii.botania.client.integration.emi.BotaniaEmiRecipe;
import vazkii.botania.client.integration.emi.BotanicalBreweryEmiRecipe;
import vazkii.botania.client.integration.emi.CompositeLensEmiRecipe;
import vazkii.botania.client.integration.emi.ElvenTradeEmiRecipe;
import vazkii.botania.client.integration.emi.ManaInfusionEmiRecipe;
import vazkii.botania.client.integration.emi.MarimorphosisEmiRecipe;
import vazkii.botania.client.integration.emi.OrechidEmiRecipe;
import vazkii.botania.client.integration.emi.PetalApothecaryEmiRecipe;
import vazkii.botania.client.integration.emi.PureDaisyEmiRecipe;
import vazkii.botania.client.integration.emi.RunicAltarEmiRecipe;
import vazkii.botania.client.integration.emi.TerrestrialAgglomerationEmiRecipe;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.MarimorphosisRecipe;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraShattererItem;
import vazkii.botania.common.item.lens.LensItem;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.lib.ResourceLocationHelper;

@EmiEntrypoint
public class BotaniaEmiPlugin
implements EmiPlugin {
    private static final Comparator<EmiRecipe> BY_ID = Comparator.comparing(EmiRecipe::getId);
    private static final Comparator<EmiRecipe> BY_GROUP = Comparator.comparing(emiRecipe -> {
        String string;
        if (emiRecipe instanceof BotaniaEmiRecipe) {
            BotaniaEmiRecipe ber = (BotaniaEmiRecipe)emiRecipe;
            string = ber.getGroup();
        } else {
            string = "";
        }
        return string;
    });
    private static final Comparator<EmiRecipe> BY_CATALYST = Comparator.comparing(emiRecipe -> emiRecipe.getCatalysts().stream().flatMap(emiIngredient -> emiIngredient.getEmiStacks().stream()).map(emiStack -> emiStack.getId().toString()).filter(StringUtils::isNotEmpty).findFirst().orElse(""));
    private static final Comparator<EmiRecipe> BY_WEIGHT = Comparator.comparing(emiRecipe -> {
        Integer n;
        if (emiRecipe instanceof OrechidEmiRecipe) {
            OrechidEmiRecipe orechidEmiRecipe = (OrechidEmiRecipe)emiRecipe;
            n = orechidEmiRecipe.getWeight();
        } else {
            n = 0;
        }
        return n;
    }).reversed();
    private static final Comparator<EmiRecipe> ORECHID_COMPARATOR = BY_WEIGHT.thenComparing(BY_ID);
    public static final EmiRecipeCategory PETAL_APOTHECARY = BotaniaEmiPlugin.createCategory("petal_apothecary", (EmiRenderable)EmiStack.of((ItemLike)BotaniaBlocks.defaultAltar), BY_ID);
    public static final EmiRecipeCategory MANA_INFUSION = BotaniaEmiPlugin.createCategory("mana_infusion", (EmiRenderable)EmiStack.of((ItemLike)BotaniaBlocks.manaPool), BY_CATALYST.thenComparing(BY_GROUP).thenComparing(BY_ID));
    public static final EmiRecipeCategory RUNIC_ALTAR = BotaniaEmiPlugin.createCategory("runic_altar", (EmiRenderable)EmiStack.of((ItemLike)BotaniaBlocks.runeAltar), BY_ID);
    public static final EmiRecipeCategory TERRESTRIAL_AGGLOMERATION = BotaniaEmiPlugin.createCategory("terrestrial_agglomeration", (EmiRenderable)EmiStack.of((ItemLike)BotaniaBlocks.terraPlate), BY_ID);
    public static final EmiRecipeCategory ELVEN_TRADE = BotaniaEmiPlugin.createCategory("elven_trade", (EmiRenderable)EmiStack.of((ItemLike)BotaniaBlocks.alfPortal), BY_ID);
    public static final EmiRecipeCategory BOTANICAL_BREWERY = BotaniaEmiPlugin.createCategory("botanical_brewery", (EmiRenderable)EmiStack.of((ItemLike)BotaniaBlocks.brewery), BY_ID);
    public static final EmiRecipeCategory PURE_DAISY = BotaniaEmiPlugin.createCategory("pure_daisy", (EmiRenderable)EmiStack.of((ItemLike)BotaniaFlowerBlocks.pureDaisy), BY_ID);
    public static final EmiRecipeCategory ORECHID = BotaniaEmiPlugin.createCategory("orechid", (EmiRenderable)EmiStack.of((ItemLike)BotaniaFlowerBlocks.orechid), ORECHID_COMPARATOR);
    public static final EmiRecipeCategory ORECHID_IGNEM = BotaniaEmiPlugin.createCategory("orechid_ignem", (EmiRenderable)EmiStack.of((ItemLike)BotaniaFlowerBlocks.orechidIgnem), ORECHID_COMPARATOR);
    public static final EmiRecipeCategory MARIMORPHOSIS = BotaniaEmiPlugin.createCategory("marimorphosis", (EmiRenderable)EmiStack.of((ItemLike)BotaniaFlowerBlocks.marimorphosis), ORECHID_COMPARATOR);
    private static final Supplier<ItemStack> HOVERED_STACK_GETTER = () -> {
        ItemStack stack;
        EmiIngredient ingr = EmiApi.getHoveredStack((boolean)true).getStack();
        if (!ingr.getEmiStacks().isEmpty() && !(stack = ((EmiStack)ingr.getEmiStacks().get(0)).getItemStack()).isEmpty()) {
            return stack;
        }
        return ItemStack.EMPTY;
    };

    private static EmiRecipeCategory createCategory(String idPath, EmiRenderable icon, Comparator<EmiRecipe> comp) {
        return new EmiRecipeCategory(ResourceLocationHelper.prefix(idPath), icon, icon, comp);
    }

    public BotaniaEmiPlugin() {
        CorporeaInputHandler.supportedGuiFilter = CorporeaInputHandler.supportedGuiFilter.or(screen -> {
            AbstractContainerScreen handledScreen = EmiApi.getHandledScreen();
            return handledScreen != null && Minecraft.getInstance().screen != handledScreen;
        });
    }

    public void register(EmiRegistry registry) {
        if (!CorporeaInputHandler.hoveredStackGetters.contains(HOVERED_STACK_GETTER)) {
            CorporeaInputHandler.hoveredStackGetters.add(HOVERED_STACK_GETTER);
        }
        registry.addCategory(PETAL_APOTHECARY);
        registry.addCategory(MANA_INFUSION);
        registry.addCategory(RUNIC_ALTAR);
        registry.addCategory(TERRESTRIAL_AGGLOMERATION);
        registry.addCategory(ELVEN_TRADE);
        registry.addCategory(BOTANICAL_BREWERY);
        registry.addCategory(PURE_DAISY);
        registry.addCategory(ORECHID);
        registry.addCategory(ORECHID_IGNEM);
        registry.addCategory(MARIMORPHOSIS);
        registry.addWorkstation(VanillaEmiRecipeCategories.CRAFTING, (EmiIngredient)EmiStack.of((ItemLike)BotaniaItems.craftingHalo));
        registry.addWorkstation(VanillaEmiRecipeCategories.CRAFTING, (EmiIngredient)EmiStack.of((ItemLike)BotaniaItems.autocraftingHalo));
        for (Block apothecary : BotaniaBlocks.ALL_APOTHECARIES) {
            registry.addWorkstation(PETAL_APOTHECARY, (EmiIngredient)EmiStack.of((ItemLike)apothecary));
        }
        registry.addWorkstation(MANA_INFUSION, (EmiIngredient)EmiStack.of((ItemLike)BotaniaBlocks.manaPool));
        registry.addWorkstation(MANA_INFUSION, (EmiIngredient)EmiStack.of((ItemLike)BotaniaBlocks.dilutedPool));
        registry.addWorkstation(MANA_INFUSION, (EmiIngredient)EmiStack.of((ItemLike)BotaniaBlocks.fabulousPool));
        registry.addWorkstation(RUNIC_ALTAR, (EmiIngredient)EmiStack.of((ItemLike)BotaniaBlocks.runeAltar));
        registry.addWorkstation(TERRESTRIAL_AGGLOMERATION, (EmiIngredient)EmiStack.of((ItemLike)BotaniaBlocks.terraPlate));
        registry.addWorkstation(ELVEN_TRADE, (EmiIngredient)EmiStack.of((ItemLike)BotaniaBlocks.alfPortal));
        registry.addWorkstation(BOTANICAL_BREWERY, (EmiIngredient)EmiStack.of((ItemLike)BotaniaBlocks.brewery));
        registry.addWorkstation(PURE_DAISY, (EmiIngredient)EmiStack.of((ItemLike)BotaniaFlowerBlocks.pureDaisy));
        registry.addWorkstation(PURE_DAISY, (EmiIngredient)EmiStack.of((ItemLike)BotaniaFlowerBlocks.pureDaisyFloating));
        registry.addWorkstation(ORECHID, (EmiIngredient)EmiStack.of((ItemLike)BotaniaFlowerBlocks.orechid));
        registry.addWorkstation(ORECHID, (EmiIngredient)EmiStack.of((ItemLike)BotaniaFlowerBlocks.orechidFloating));
        registry.addWorkstation(ORECHID_IGNEM, (EmiIngredient)EmiStack.of((ItemLike)BotaniaFlowerBlocks.orechidIgnem));
        registry.addWorkstation(ORECHID_IGNEM, (EmiIngredient)EmiStack.of((ItemLike)BotaniaFlowerBlocks.orechidIgnemFloating));
        registry.addWorkstation(MARIMORPHOSIS, (EmiIngredient)EmiStack.of((ItemLike)BotaniaFlowerBlocks.marimorphosis));
        registry.addWorkstation(MARIMORPHOSIS, (EmiIngredient)EmiStack.of((ItemLike)BotaniaFlowerBlocks.marimorphosisFloating));
        registry.addWorkstation(MARIMORPHOSIS, (EmiIngredient)EmiStack.of((ItemLike)BotaniaFlowerBlocks.marimorphosisChibi));
        registry.addWorkstation(MARIMORPHOSIS, (EmiIngredient)EmiStack.of((ItemLike)BotaniaFlowerBlocks.marimorphosisChibiFloating));
        registry.setDefaultComparison((Object)BotaniaItems.lexicon, Comparison.compareNbt());
        registry.setDefaultComparison((Object)BotaniaItems.brewFlask, Comparison.compareNbt());
        registry.setDefaultComparison((Object)BotaniaItems.brewVial, Comparison.compareNbt());
        registry.setDefaultComparison((Object)BotaniaItems.bloodPendant, Comparison.compareNbt());
        registry.setDefaultComparison((Object)BotaniaItems.incenseStick, Comparison.compareNbt());
        registry.addRecipe((EmiRecipe)new AncientWillEmiRecipe(EmiStack.of((ItemLike)BotaniaItems.terrasteelHelm), EmiIngredient.of(List.of(EmiStack.of((ItemLike)BotaniaItems.ancientWillAhrim), EmiStack.of((ItemLike)BotaniaItems.ancientWillDharok), EmiStack.of((ItemLike)BotaniaItems.ancientWillGuthan), EmiStack.of((ItemLike)BotaniaItems.ancientWillKaril), EmiStack.of((ItemLike)BotaniaItems.ancientWillTorag), EmiStack.of((ItemLike)BotaniaItems.ancientWillVerac)))));
        registry.addRecipe((EmiRecipe)new CompositeLensEmiRecipe(StreamSupport.stream(BuiltInRegistries.ITEM.getOrCreateTag(BotaniaTags.Items.LENS).spliterator(), false).map(ItemStack::new).filter(s -> !((LensItem)s.getItem()).isControlLens((ItemStack)s)).filter(s -> ((LensItem)s.getItem()).isCombinable((ItemStack)s)).map(EmiStack::of).toList()));
        ItemStack tipped = new ItemStack((ItemLike)BotaniaItems.terraPick);
        TerraShattererItem.setTipped(tipped);
        registry.addRecipe((EmiRecipe)new EmiCraftingRecipe(List.of(EmiStack.of((ItemLike)BotaniaItems.terraPick), EmiStack.of((ItemLike)BotaniaItems.elementiumPick)), EmiStack.of((ItemStack)tipped), null));
        for (PetalApothecaryRecipe recipe : registry.getRecipeManager().getAllRecipesFor(BotaniaRecipeTypes.PETAL_TYPE)) {
            registry.addRecipe((EmiRecipe)new PetalApothecaryEmiRecipe(recipe));
        }
        for (ManaInfusionRecipe recipe : registry.getRecipeManager().getAllRecipesFor(BotaniaRecipeTypes.MANA_INFUSION_TYPE)) {
            registry.addRecipe((EmiRecipe)new ManaInfusionEmiRecipe(recipe));
        }
        for (RunicAltarRecipe recipe : registry.getRecipeManager().getAllRecipesFor(BotaniaRecipeTypes.RUNE_TYPE)) {
            registry.addRecipe((EmiRecipe)new RunicAltarEmiRecipe(recipe));
        }
        for (TerrestrialAgglomerationRecipe recipe : registry.getRecipeManager().getAllRecipesFor(BotaniaRecipeTypes.TERRA_PLATE_TYPE)) {
            registry.addRecipe((EmiRecipe)new TerrestrialAgglomerationEmiRecipe(recipe));
        }
        for (ElvenTradeRecipe recipe : registry.getRecipeManager().getAllRecipesFor(BotaniaRecipeTypes.ELVEN_TRADE_TYPE)) {
            registry.addRecipe((EmiRecipe)new ElvenTradeEmiRecipe(recipe));
        }
        List<ItemStack> containers = List.of(BotaniaItems.vial, BotaniaItems.flask, BotaniaItems.incenseStick, BotaniaItems.bloodPendant).stream().map(ItemStack::new).toList();
        for (Object recipe : registry.getRecipeManager().getAllRecipesFor(BotaniaRecipeTypes.BREW_TYPE)) {
            for (ItemStack container : containers) {
                if (recipe.getOutput(container.copy()).isEmpty()) continue;
                registry.addRecipe((EmiRecipe)new BotanicalBreweryEmiRecipe((BotanicalBreweryRecipe)recipe, container));
            }
        }
        for (Object recipe : registry.getRecipeManager().getAllRecipesFor(BotaniaRecipeTypes.PURE_DAISY_TYPE)) {
            registry.addRecipe((EmiRecipe)new PureDaisyEmiRecipe((PureDaisyRecipe)recipe));
        }
        EmiStack flower = EmiStack.of((ItemLike)BotaniaFlowerBlocks.orechid);
        for (OrechidRecipe recipe : registry.getRecipeManager().getAllRecipesFor(BotaniaRecipeTypes.ORECHID_TYPE)) {
            registry.addRecipe((EmiRecipe)new OrechidEmiRecipe(ORECHID, recipe, (EmiIngredient)flower));
        }
        flower = EmiStack.of((ItemLike)BotaniaFlowerBlocks.orechidIgnem);
        for (OrechidRecipe recipe : registry.getRecipeManager().getAllRecipesFor(BotaniaRecipeTypes.ORECHID_IGNEM_TYPE)) {
            registry.addRecipe((EmiRecipe)new OrechidEmiRecipe(ORECHID_IGNEM, recipe, (EmiIngredient)flower));
        }
        flower = EmiStack.of((ItemLike)BotaniaFlowerBlocks.marimorphosis);
        for (OrechidRecipe recipe : registry.getRecipeManager().getAllRecipesFor(BotaniaRecipeTypes.MARIMORPHOSIS_TYPE)) {
            registry.addRecipe((EmiRecipe)new MarimorphosisEmiRecipe((MarimorphosisRecipe)recipe, (EmiIngredient)flower));
        }
    }

    public static int rotateXAround(int x, int y, int cx, int cy, double degrees) {
        double rad = Math.toRadians(degrees);
        return (int)(Math.cos(rad) * (double)(x - cx) - Math.sin(rad) * (double)(y - cy) + (double)cx);
    }

    public static int rotateYAround(int x, int y, int cx, int cy, double degrees) {
        double rad = Math.toRadians(degrees);
        return (int)(Math.sin(rad) * (double)(x - cx) - Math.cos(rad) * (double)(y - cy) + (double)cy);
    }
}

