/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.fx;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector4f;

public class BoltParticleOptions {
    private final BoltRenderInfo renderInfo;
    private final Vec3 start;
    private final Vec3 end;
    private final int segments;
    private final int count;
    private final float size;
    private final int lifespan;
    private final SpawnFunction spawnFunction;
    private final FadeFunction fadeFunction;

    public BoltParticleOptions(Vec3 start, Vec3 end) {
        this(BoltRenderInfo.DEFAULT, start, end);
    }

    public BoltParticleOptions(BoltRenderInfo info, Vec3 start, Vec3 end) {
        this(info, start, end, (int)Math.sqrt(start.distanceTo(end) * 100.0));
    }

    public BoltParticleOptions(BoltRenderInfo info, Vec3 start, Vec3 end, int segments) {
        this(info, start, end, segments, 1, 0.1f, 30, SpawnFunction.delay(60.0f), FadeFunction.fade(0.5f));
    }

    public BoltParticleOptions(BoltRenderInfo info, Vec3 start, Vec3 end, int segments, int count, float size, int lifespan, SpawnFunction spawnFunction, FadeFunction fadeFunction) {
        this.renderInfo = info;
        this.start = start;
        this.end = end;
        this.segments = segments;
        this.count = count;
        this.size = size;
        this.lifespan = lifespan;
        this.spawnFunction = spawnFunction;
        this.fadeFunction = fadeFunction;
    }

    public BoltParticleOptions count(int count) {
        return new BoltParticleOptions(this.renderInfo, this.start, this.end, this.segments, count, this.size, this.lifespan, this.spawnFunction, this.fadeFunction);
    }

    public BoltParticleOptions size(float size) {
        return new BoltParticleOptions(this.renderInfo, this.start, this.end, this.segments, this.count, size, this.lifespan, this.spawnFunction, this.fadeFunction);
    }

    public BoltParticleOptions spawn(SpawnFunction spawnFunction) {
        return new BoltParticleOptions(this.renderInfo, this.start, this.end, this.segments, this.count, this.size, this.lifespan, spawnFunction, this.fadeFunction);
    }

    public BoltParticleOptions fade(FadeFunction fadeFunction) {
        return new BoltParticleOptions(this.renderInfo, this.start, this.end, this.segments, this.count, this.size, this.lifespan, this.spawnFunction, fadeFunction);
    }

    public BoltParticleOptions lifespan(int lifespan) {
        return new BoltParticleOptions(this.renderInfo, this.start, this.end, this.segments, this.count, this.size, lifespan, this.spawnFunction, this.fadeFunction);
    }

    public int getLifespan() {
        return this.lifespan;
    }

    public SpawnFunction getSpawnFunction() {
        return this.spawnFunction;
    }

    public FadeFunction getFadeFunction() {
        return this.fadeFunction;
    }

    public Vector4f getColor() {
        return this.renderInfo.color;
    }

    public List<BoltQuads> generate() {
        Random random = new Random();
        ArrayList<BoltQuads> quads = new ArrayList<BoltQuads>();
        Vec3 diff = this.end.subtract(this.start);
        float totalDistance = (float)diff.length();
        block0: for (int i = 0; i < this.count; ++i) {
            ArrayDeque<BoltInstructions> drawQueue = new ArrayDeque<BoltInstructions>();
            drawQueue.add(new BoltInstructions(this.start, 0.0f, Vec3.ZERO, null, false));
            while (!drawQueue.isEmpty()) {
                Vec3 segmentEnd;
                BoltInstructions data = (BoltInstructions)drawQueue.poll();
                Vec3 perpendicularDist = data.perpendicularDist();
                float progress = data.progress() + 1.0f / (float)this.segments * (1.0f - this.renderInfo.parallelNoise + random.nextFloat() * this.renderInfo.parallelNoise * 2.0f);
                float segmentDiffScale = this.renderInfo.spreadFunction.getMaxSpread(progress);
                if (progress >= 1.0f && segmentDiffScale <= 0.0f) {
                    segmentEnd = this.end;
                } else {
                    float maxDiff = this.renderInfo.spreadFactor * segmentDiffScale * totalDistance;
                    Vec3 randVec = BoltParticleOptions.findRandomOrthogonalVector(diff, random);
                    double rand = this.renderInfo.randomFunction.getRandom(random);
                    perpendicularDist = this.renderInfo.segmentSpreader.getSegmentAdd(perpendicularDist, randVec, maxDiff, segmentDiffScale, progress, rand);
                    segmentEnd = this.start.add(diff.scale((double)progress)).add(perpendicularDist);
                }
                float boltSize = this.size * (0.5f + (1.0f - progress) * 0.5f);
                Pair<BoltQuads, QuadCache> quadData = this.createQuads(data.cache(), data.start(), segmentEnd, boltSize);
                quads.add((BoltQuads)quadData.getLeft());
                if (progress >= 1.0f) continue block0;
                if (!data.isBranch()) {
                    drawQueue.add(new BoltInstructions(segmentEnd, progress, perpendicularDist, (QuadCache)quadData.getRight(), false));
                } else if (random.nextFloat() < this.renderInfo.branchContinuationFactor) {
                    drawQueue.add(new BoltInstructions(segmentEnd, progress, perpendicularDist, (QuadCache)quadData.getRight(), true));
                }
                while (random.nextFloat() < this.renderInfo.branchInitiationFactor * (1.0f - progress)) {
                    drawQueue.add(new BoltInstructions(segmentEnd, progress, perpendicularDist, (QuadCache)quadData.getRight(), true));
                }
            }
        }
        return quads;
    }

    private static Vec3 findRandomOrthogonalVector(Vec3 vec, Random rand) {
        Vec3 newVec = new Vec3(-0.5 + rand.nextDouble(), -0.5 + rand.nextDouble(), -0.5 + rand.nextDouble());
        return vec.cross(newVec).normalize();
    }

    private Pair<BoltQuads, QuadCache> createQuads(@Nullable QuadCache cache, Vec3 startPos, Vec3 end, float size) {
        Vec3 diff = end.subtract(startPos);
        Vec3 rightAdd = diff.cross(new Vec3(0.5, 0.5, 0.5)).normalize().scale((double)size);
        Vec3 backAdd = diff.cross(rightAdd).normalize().scale((double)size);
        Vec3 rightAddSplit = rightAdd.scale(0.5);
        Vec3 start = cache != null ? cache.prevEnd() : startPos;
        Vec3 startRight = cache != null ? cache.prevEndRight() : start.add(rightAdd);
        Vec3 startBack = cache != null ? cache.prevEndBack() : start.add(rightAddSplit).add(backAdd);
        Vec3 endRight = end.add(rightAdd);
        Vec3 endBack = end.add(rightAddSplit).add(backAdd);
        BoltQuads quads = new BoltQuads();
        quads.addQuad(start, end, endRight, startRight);
        quads.addQuad(startRight, endRight, end, start);
        quads.addQuad(startRight, endRight, endBack, startBack);
        quads.addQuad(startBack, endBack, endRight, startRight);
        return Pair.of((Object)quads, (Object)new QuadCache(end, endRight, endBack));
    }

    public static class BoltRenderInfo {
        public static final BoltRenderInfo DEFAULT = BoltRenderInfo.defaultConfig();
        private final float parallelNoise;
        private final float spreadFactor;
        private final float branchInitiationFactor;
        private final float branchContinuationFactor;
        private final Vector4f color;
        private final RandomFunction randomFunction;
        private final SpreadFunction spreadFunction;
        private final SegmentSpreader segmentSpreader;

        private BoltRenderInfo(float parallelNoise, float spreadFactor, float branchInitiationFactor, float branchContinuationFactor, Vector4f color, RandomFunction randomFunction, SpreadFunction spreadFunction, SegmentSpreader segmentSpreader) {
            this.parallelNoise = parallelNoise;
            this.spreadFactor = spreadFactor;
            this.branchInitiationFactor = branchInitiationFactor;
            this.branchContinuationFactor = branchContinuationFactor;
            this.color = color;
            this.randomFunction = randomFunction;
            this.spreadFunction = spreadFunction;
            this.segmentSpreader = segmentSpreader;
        }

        private static BoltRenderInfo defaultConfig() {
            return new BoltRenderInfo(0.1f, 0.1f, 0.0f, 0.0f, new Vector4f(0.0f, 0.7764f, 1.0f, 0.8f), RandomFunction.GAUSSIAN, SpreadFunction.SINE, SegmentSpreader.NO_MEMORY);
        }

        public BoltRenderInfo noise(float parallelNoise, float spreadFactor) {
            return new BoltRenderInfo(parallelNoise, spreadFactor, this.branchInitiationFactor, this.branchContinuationFactor, this.color, this.randomFunction, this.spreadFunction, this.segmentSpreader);
        }

        public BoltRenderInfo branching(float branchInitiationFactor, float branchContinuationFactor) {
            return new BoltRenderInfo(this.parallelNoise, this.spreadFactor, branchInitiationFactor, branchContinuationFactor, this.color, this.randomFunction, this.spreadFunction, this.segmentSpreader);
        }

        public BoltRenderInfo spreader(SegmentSpreader segmentSpreader) {
            return new BoltRenderInfo(this.parallelNoise, this.spreadFactor, this.branchInitiationFactor, this.branchContinuationFactor, this.color, this.randomFunction, this.spreadFunction, segmentSpreader);
        }

        public BoltRenderInfo randomFunction(RandomFunction randomFunction) {
            return new BoltRenderInfo(this.parallelNoise, this.spreadFactor, this.branchInitiationFactor, this.branchContinuationFactor, this.color, randomFunction, this.spreadFunction, this.segmentSpreader);
        }

        public BoltRenderInfo spreadFunction(SpreadFunction spreadFunction) {
            return new BoltRenderInfo(this.parallelNoise, this.spreadFactor, this.branchInitiationFactor, this.branchContinuationFactor, this.color, this.randomFunction, spreadFunction, this.segmentSpreader);
        }

        public BoltRenderInfo color(Vector4f color) {
            return new BoltRenderInfo(this.parallelNoise, this.spreadFactor, this.branchInitiationFactor, this.branchContinuationFactor, color, this.randomFunction, this.spreadFunction, this.segmentSpreader);
        }
    }

    public static interface SpawnFunction {
        public static final SpawnFunction NO_DELAY = rand -> Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        public static final SpawnFunction CONSECUTIVE = new SpawnFunction(){

            @Override
            public Pair<Float, Float> getSpawnDelayBounds(Random rand) {
                return Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
            }

            @Override
            public boolean isConsecutive() {
                return true;
            }
        };

        public static SpawnFunction delay(float delay) {
            return rand -> Pair.of((Object)Float.valueOf(delay), (Object)Float.valueOf(delay));
        }

        public static SpawnFunction noise(float delay, float noise) {
            return rand -> Pair.of((Object)Float.valueOf(delay - noise), (Object)Float.valueOf(delay + noise));
        }

        public Pair<Float, Float> getSpawnDelayBounds(Random var1);

        default public float getSpawnDelay(Random rand) {
            Pair<Float, Float> bounds = this.getSpawnDelayBounds(rand);
            return ((Float)bounds.getLeft()).floatValue() + (((Float)bounds.getRight()).floatValue() - ((Float)bounds.getLeft()).floatValue()) * rand.nextFloat();
        }

        default public boolean isConsecutive() {
            return false;
        }
    }

    public static interface FadeFunction {
        public static final FadeFunction NONE = (totalBolts, lifeScale) -> Pair.of((Object)0, (Object)totalBolts);

        public static FadeFunction fade(float fade) {
            return (totalBolts, lifeScale) -> {
                int start = lifeScale > 1.0f - fade ? (int)((float)totalBolts * (lifeScale - (1.0f - fade)) / fade) : 0;
                int end = lifeScale < fade ? (int)((float)totalBolts * (lifeScale / fade)) : totalBolts;
                return Pair.of((Object)start, (Object)end);
            };
        }

        public Pair<Integer, Integer> getRenderBounds(int var1, float var2);
    }

    private record BoltInstructions(Vec3 start, float progress, Vec3 perpendicularDist, @Nullable QuadCache cache, boolean isBranch) {
    }

    private record QuadCache(Vec3 prevEnd, Vec3 prevEndRight, Vec3 prevEndBack) {
    }

    public static interface SpreadFunction {
        public static final SpreadFunction LINEAR_ASCENT = progress -> progress;
        public static final SpreadFunction LINEAR_ASCENT_DESCENT = progress -> (progress - Math.max(0.0f, 2.0f * progress - 1.0f)) / 0.5f;
        public static final SpreadFunction SINE = progress -> (float)Math.sin(Math.PI * (double)progress);

        public float getMaxSpread(float var1);
    }

    public static interface RandomFunction {
        public static final RandomFunction UNIFORM = Random::nextFloat;
        public static final RandomFunction GAUSSIAN = rand -> (float)rand.nextGaussian();

        public float getRandom(Random var1);
    }

    public static interface SegmentSpreader {
        public static final SegmentSpreader NO_MEMORY = (perpendicularDist, randVec, maxDiff, scale, progress, rand) -> randVec.scale((double)maxDiff * rand);

        public static SegmentSpreader memory(float memoryFactor) {
            return (perpendicularDist, randVec, maxDiff, spreadScale, progress, rand) -> {
                double nextDiff = (double)(maxDiff * (1.0f - memoryFactor)) * rand;
                Vec3 cur = randVec.scale(nextDiff);
                double length = (perpendicularDist = perpendicularDist.add(cur)).length();
                if (length > (double)maxDiff) {
                    perpendicularDist = perpendicularDist.scale((double)maxDiff / length);
                }
                return perpendicularDist.add(cur);
            };
        }

        public Vec3 getSegmentAdd(Vec3 var1, Vec3 var2, float var3, float var4, float var5, double var6);
    }

    public static class BoltQuads {
        private final List<Vec3> vecs = new ArrayList<Vec3>();

        protected void addQuad(Vec3 ... quadVecs) {
            this.vecs.addAll(Arrays.asList(quadVecs));
        }

        public List<Vec3> getVecs() {
            return this.vecs;
        }
    }
}

