/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.brew;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.BrewItem;
import vazkii.botania.common.brew.BotaniaBrews;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.CustomCreativeTabContents;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class BaseBrewItem
extends Item
implements BrewItem,
CustomCreativeTabContents {
    private static final String TAG_BREW_KEY = "brewKey";
    private static final String TAG_SWIGS_LEFT = "swigsLeft";
    private final int swigs;
    private final int drinkSpeed;
    private final Supplier<Item> baseItem;

    public BaseBrewItem(Item.Properties builder, int swigs, int drinkSpeed, Supplier<Item> baseItem) {
        super(builder);
        this.swigs = swigs;
        this.drinkSpeed = drinkSpeed;
        this.baseItem = baseItem;
    }

    public int getUseDuration(ItemStack stack) {
        return this.drinkSpeed;
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        return ItemUtils.startUsingInstantly((Level)world, (Player)player, (InteractionHand)hand);
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, Level world, LivingEntity living) {
        if (!world.isClientSide) {
            for (MobEffectInstance effect : this.getBrew(stack).getPotionEffects(stack)) {
                MobEffectInstance newEffect = new MobEffectInstance(effect.getEffect(), effect.getDuration(), effect.getAmplifier(), true, true);
                if (effect.getEffect().isInstantenous()) {
                    effect.getEffect().applyInstantenousEffect((Entity)living, (Entity)living, living, newEffect.getAmplifier(), 1.0);
                    continue;
                }
                living.addEffect(newEffect);
            }
            if (world.random.nextBoolean()) {
                world.playSound(null, living.getX(), living.getY(), living.getZ(), SoundEvents.PLAYER_BURP, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            int swigs = this.getSwigsLeft(stack);
            if (living instanceof Player) {
                Player player = (Player)living;
                if (!player.getAbilities().instabuild) {
                    if (swigs == 1) {
                        ItemStack result = this.getBaseStack();
                        if (!player.getInventory().add(result)) {
                            return result;
                        }
                        return ItemStack.EMPTY;
                    }
                    this.setSwigsLeft(stack, swigs - 1);
                }
            }
        }
        return stack;
    }

    @Override
    public void addToCreativeTab(Item me, CreativeModeTab.Output output) {
        for (Brew brew : BotaniaAPI.instance().getBrewRegistry()) {
            if (brew == BotaniaBrews.fallbackBrew) continue;
            ItemStack stack = new ItemStack((ItemLike)this);
            BaseBrewItem.setBrew(stack, brew);
            output.accept(stack);
        }
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        return Component.translatable((String)this.getDescriptionId(), (Object[])new Object[]{Component.translatable((String)this.getBrew(stack).getTranslationKey(stack)), Component.literal((String)Integer.toString(this.getSwigsLeft(stack))).withStyle(ChatFormatting.BOLD)});
    }

    public static void addPotionTooltip(List<MobEffectInstance> list, List<Component> lores, float durationFactor) {
        ArrayList list1 = Lists.newArrayList();
        if (list.isEmpty()) {
            lores.add((Component)Component.translatable((String)"effect.none").withStyle(ChatFormatting.GRAY));
        } else {
            for (MobEffectInstance effectinstance : list) {
                MutableComponent iformattabletextcomponent = Component.translatable((String)effectinstance.getDescriptionId());
                MobEffect effect = effectinstance.getEffect();
                Map map = effect.getAttributeModifiers();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.getName(), effect.getAttributeModifierValue(effectinstance.getAmplifier(), attributemodifier), attributemodifier.getOperation());
                        list1.add(new Pair((Object)((Attribute)entry.getKey()), (Object)attributemodifier1));
                    }
                }
                if (effectinstance.getAmplifier() > 0) {
                    iformattabletextcomponent = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{iformattabletextcomponent, Component.translatable((String)("potion.potency." + effectinstance.getAmplifier()))});
                }
                if (effectinstance.getDuration() > 20) {
                    iformattabletextcomponent = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{iformattabletextcomponent, MobEffectUtil.formatDuration((MobEffectInstance)effectinstance, (float)durationFactor)});
                }
                lores.add((Component)iformattabletextcomponent.withStyle(effect.getCategory().getTooltipFormatting()));
            }
        }
        if (!list1.isEmpty()) {
            lores.add((Component)Component.empty());
            lores.add((Component)Component.translatable((String)"potion.whenDrank").withStyle(ChatFormatting.DARK_PURPLE));
            for (Pair pair : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                double d0 = attributemodifier2.getAmount();
                double d1 = attributemodifier2.getOperation() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.getOperation() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.getAmount() : attributemodifier2.getAmount() * 100.0;
                if (d0 > 0.0) {
                    lores.add((Component)Component.translatable((String)("attribute.modifier.plus." + attributemodifier2.getOperation().toValue()), (Object[])new Object[]{ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(d1), Component.translatable((String)((Attribute)pair.getFirst()).getDescriptionId())}).withStyle(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                lores.add((Component)Component.translatable((String)("attribute.modifier.take." + attributemodifier2.getOperation().toValue()), (Object[])new Object[]{ItemStack.ATTRIBUTE_MODIFIER_FORMAT.format(d1 *= -1.0), Component.translatable((String)((Attribute)pair.getFirst()).getDescriptionId())}).withStyle(ChatFormatting.RED));
            }
        }
    }

    public void appendHoverText(ItemStack stack, Level world, List<Component> list, TooltipFlag flags) {
        BaseBrewItem.addPotionTooltip(this.getBrew(stack).getPotionEffects(stack), list, 1.0f);
    }

    @Override
    public Brew getBrew(ItemStack stack) {
        String key = ItemNBTHelper.getString(stack, TAG_BREW_KEY, "");
        return (Brew)BotaniaAPI.instance().getBrewRegistry().get(ResourceLocation.tryParse((String)key));
    }

    public static void setBrew(ItemStack stack, @Nullable Brew brew) {
        ResourceLocation id = brew != null ? BotaniaAPI.instance().getBrewRegistry().getKey((Object)brew) : ResourceLocationHelper.prefix("fallback");
        BaseBrewItem.setBrew(stack, id);
    }

    public static void setBrew(ItemStack stack, ResourceLocation brew) {
        ItemNBTHelper.setString(stack, TAG_BREW_KEY, brew.toString());
    }

    @NotNull
    public static String getSubtype(ItemStack stack) {
        return stack.hasTag() ? ItemNBTHelper.getString(stack, TAG_BREW_KEY, "none") : "none";
    }

    public int getSwigs() {
        return this.swigs;
    }

    public int getSwigsLeft(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_SWIGS_LEFT, this.swigs);
    }

    public void setSwigsLeft(ItemStack stack, int swigs) {
        ItemNBTHelper.setInt(stack, TAG_SWIGS_LEFT, swigs);
    }

    public ItemStack getBaseStack() {
        return new ItemStack((ItemLike)this.baseItem.get());
    }
}

