/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.xplat.XplatAbstractions;

public class GogAlternationRecipe {
    public static final RecipeSerializer<Recipe<?>> SERIALIZER = new Serializer();

    private static class Serializer
    implements RecipeSerializer<Recipe<?>> {
        private Serializer() {
        }

        @NotNull
        public Recipe<?> fromJson(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            Recipe gog = RecipeManager.fromJson((ResourceLocation)recipeId, (JsonObject)GsonHelper.getAsJsonObject((JsonObject)json, (String)"gog"));
            Recipe base = RecipeManager.fromJson((ResourceLocation)recipeId, (JsonObject)GsonHelper.getAsJsonObject((JsonObject)json, (String)"base"));
            if (gog.getType() != base.getType()) {
                throw new IllegalArgumentException("Subrecipes must have matching types");
            }
            if (XplatAbstractions.INSTANCE.gogLoaded()) {
                return gog;
            }
            return base;
        }

        @NotNull
        public Recipe<?> fromNetwork(@NotNull ResourceLocation recipeId, @NotNull FriendlyByteBuf buffer) {
            throw new IllegalStateException("GogAlternationRecipe should not be sent over network");
        }

        public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull Recipe<?> recipe) {
            throw new IllegalStateException("GogAlternationRecipe should not be sent over network");
        }
    }
}

