/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.block.BotaniaBlock;
import vazkii.botania.common.block.block_entity.CacophoniumBlockEntity;

public class CacophoniumBlock
extends BotaniaBlock
implements EntityBlock {
    protected CacophoniumBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.POWERED});
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean power = world.getBestNeighborSignal(pos) > 0;
        boolean powered = (Boolean)state.getValue((Property)BlockStateProperties.POWERED);
        if (power && !powered) {
            BlockEntity tile = world.getBlockEntity(pos);
            if (tile instanceof CacophoniumBlockEntity) {
                CacophoniumBlockEntity cacophonium = (CacophoniumBlockEntity)tile;
                cacophonium.annoyDirewolf();
            }
            world.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!power && powered) {
            world.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity te = world.getBlockEntity(pos);
            if (te instanceof CacophoniumBlockEntity) {
                CacophoniumBlockEntity cacophonium = (CacophoniumBlockEntity)te;
                Containers.dropItemStack((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)cacophonium.stack);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new CacophoniumBlockEntity(pos, state);
    }
}

