/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.CocoonBlockEntity;
import vazkii.botania.common.item.BotaniaItems;

public class CocoonBlock
extends BotaniaWaterloggedBlock
implements EntityBlock {
    private static final VoxelShape SHAPE = CocoonBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0);

    protected CocoonBlock(BlockBehaviour.Properties builder) {
        super(builder);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    @NotNull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity e) {
        if (!world.isClientSide && e instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)e;
            ItemStack stack = item.getItem();
            this.addStack(world, pos, stack, false);
            if (stack.isEmpty()) {
                item.discard();
            }
        }
    }

    public InteractionResult use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.getItemInHand(hand);
        return this.addStack(world, pos, stack, player.getAbilities().instabuild);
    }

    private InteractionResult addStack(Level world, BlockPos pos, ItemStack stack, boolean creative) {
        CocoonBlockEntity cocoon = (CocoonBlockEntity)world.getBlockEntity(pos);
        if (cocoon != null && (stack.is(Items.EMERALD) || stack.is(Items.CHORUS_FRUIT) || stack.is(BotaniaItems.lifeEssence))) {
            if (!world.isClientSide) {
                if (stack.is(Items.EMERALD) && cocoon.emeraldsGiven < 20) {
                    if (!creative) {
                        stack.shrink(1);
                    }
                    ++cocoon.emeraldsGiven;
                    ((ServerLevel)world).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, 1, 0.1, 0.05, 0.1, 0.5);
                } else if (stack.is(Items.CHORUS_FRUIT) && cocoon.chorusFruitGiven < 20) {
                    if (!creative) {
                        stack.shrink(1);
                    }
                    ++cocoon.chorusFruitGiven;
                    ((ServerLevel)world).sendParticles((ParticleOptions)ParticleTypes.PORTAL, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 32, 0.0, 0.0, 0.0, 0.5);
                } else if (stack.is(BotaniaItems.lifeEssence) && !cocoon.gaiaSpiritGiven) {
                    if (!creative) {
                        stack.shrink(1);
                    }
                    cocoon.forceRare();
                    WispParticleData data = WispParticleData.wisp(0.6f, 0.0f, 1.0f, 0.0f);
                    ((ServerLevel)world).sendParticles((ParticleOptions)data, (double)pos.getX() + 0.5, (double)pos.getY() + 0.7, (double)pos.getZ() + 0.5, 8, 0.1, 0.1, 0.1, 0.04);
                }
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new CocoonBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return CocoonBlock.createTickerHelper(type, BotaniaBlockEntities.COCOON, CocoonBlockEntity::commonTick);
    }
}

