/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.fx;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.core.helper.CoreShaders;
import vazkii.botania.xplat.ClientXplatAbstractions;

public class FXSparkle
extends TextureSheetParticle {
    private final boolean corrupt;
    public final boolean fake;
    public final int particle = 16;
    private final boolean slowdown = true;
    private final SpriteSet sprite;
    public static final ParticleRenderType NORMAL_RENDER = new ParticleRenderType(){

        public void begin(BufferBuilder bufferBuilder, TextureManager textureManager) {
            FXSparkle.beginRenderCommon(bufferBuilder, textureManager);
        }

        public void end(Tesselator tessellator) {
            tessellator.end();
            FXSparkle.endRenderCommon();
        }

        public String toString() {
            return "botania:sparkle";
        }
    };
    public static final ParticleRenderType CORRUPT_RENDER = new ParticleRenderType(){

        public void begin(BufferBuilder bufferBuilder, TextureManager textureManager) {
            FXSparkle.beginRenderCommon(bufferBuilder, textureManager);
            RenderSystem.setShader(CoreShaders::filmGrainParticle);
        }

        public void end(Tesselator tessellator) {
            tessellator.end();
            FXSparkle.endRenderCommon();
        }

        public String toString() {
            return "botania:corrupt_sparkle";
        }
    };

    public FXSparkle(ClientLevel world, double x, double y, double z, float size, float red, float green, float blue, int m, boolean fake, boolean noClip, boolean corrupt, SpriteSet sprite) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.rCol = red;
        this.gCol = green;
        this.bCol = blue;
        this.alpha = 0.75f;
        this.gravity = 0.0f;
        this.zd = 0.0;
        this.yd = 0.0;
        this.xd = 0.0;
        this.quadSize = (this.random.nextFloat() * 0.5f + 0.5f) * 0.2f * size;
        this.lifetime = 3 * m;
        this.setSize(0.01f, 0.01f);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.fake = fake;
        this.corrupt = corrupt;
        this.hasPhysics = !fake && !noClip;
        this.sprite = sprite;
        this.setSpriteFromAge(sprite);
    }

    public float getQuadSize(float partialTicks) {
        return this.quadSize * (float)(this.lifetime - this.age + 1) / (float)this.lifetime;
    }

    public void tick() {
        this.setSpriteFromAge(this.sprite);
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.yd -= 0.04 * (double)this.gravity;
        if (this.hasPhysics && !this.fake) {
            this.wiggleAround(this.x, (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.z);
        }
        this.move(this.xd, this.yd, this.zd);
        this.xd *= 0.9080000019073486;
        this.yd *= 0.9080000019073486;
        this.zd *= 0.9080000019073486;
        if (this.onGround) {
            this.xd *= (double)0.7f;
            this.zd *= (double)0.7f;
        }
        if (this.fake && this.age > 1) {
            this.remove();
        }
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return this.corrupt ? CORRUPT_RENDER : NORMAL_RENDER;
    }

    public void setGravity(float value) {
        this.gravity = value;
    }

    private void wiggleAround(double x, double y, double z) {
        BlockPos blockpos = BlockPos.containing((double)x, (double)y, (double)z);
        Vec3 Vector3d = new Vec3(x - (double)blockpos.getX(), y - (double)blockpos.getY(), z - (double)blockpos.getZ());
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        Direction direction = Direction.UP;
        double d0 = Double.MAX_VALUE;
        for (Direction direction1 : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.UP}) {
            double d2;
            blockpos$mutable.set((Vec3i)blockpos).move(direction1);
            if (this.level.getBlockState((BlockPos)blockpos$mutable).isCollisionShapeFullBlock((BlockGetter)this.level, (BlockPos)blockpos$mutable)) continue;
            double d1 = Vector3d.get(direction1.getAxis());
            double d = d2 = direction1.getAxisDirection() == Direction.AxisDirection.POSITIVE ? 1.0 - d1 : d1;
            if (!(d2 < d0)) continue;
            d0 = d2;
            direction = direction1;
        }
        float f = this.random.nextFloat() * 0.05f + 0.025f;
        float f1 = direction.getAxisDirection().getStep();
        float secondary = (this.random.nextFloat() - this.random.nextFloat()) * 0.1f;
        float secondary2 = (this.random.nextFloat() - this.random.nextFloat()) * 0.1f;
        if (direction.getAxis() == Direction.Axis.X) {
            this.xd = f1 * f;
            this.yd = secondary;
            this.zd = secondary2;
        } else if (direction.getAxis() == Direction.Axis.Y) {
            this.xd = secondary;
            this.yd = f1 * f;
            this.zd = secondary2;
        } else if (direction.getAxis() == Direction.Axis.Z) {
            this.xd = secondary;
            this.yd = secondary2;
            this.zd = f1 * f;
        }
    }

    private static void beginRenderCommon(BufferBuilder buffer, TextureManager textureManager) {
        Minecraft.getInstance().gameRenderer.lightTexture().turnOnLightLayer();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_PARTICLES);
        AbstractTexture tex = textureManager.getTexture(TextureAtlas.LOCATION_PARTICLES);
        ClientXplatAbstractions.INSTANCE.setFilterSave(tex, true, false);
        buffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
    }

    private static void endRenderCommon() {
        AbstractTexture tex = Minecraft.getInstance().getTextureManager().getTexture(TextureAtlas.LOCATION_PARTICLES);
        ClientXplatAbstractions.INSTANCE.restoreLastFilter(tex);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
    }
}

