/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.gui.bag.FlowerPouchContainer;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaDoubleFlowerBlock;
import vazkii.botania.common.block.BotaniaFlowerBlock;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.ItemBackedInventory;
import vazkii.botania.xplat.XplatAbstractions;

public class FlowerPouchItem
extends Item {
    public static final int DYE_COUNT = 16;
    public static final int SIZE = 32;

    public FlowerPouchItem(Item.Properties props) {
        super(props);
    }

    public static Item getFlowerForSlot(int slot) {
        if (slot < 16) {
            DyeColor color = DyeColor.byId((int)slot);
            return BotaniaBlocks.getFlower(color).asItem();
        }
        DyeColor color = DyeColor.byId((int)(slot - 16));
        return BotaniaBlocks.getDoubleFlower(color).asItem();
    }

    private static boolean isMysticalFlower(ItemStack stack) {
        Class<?> blockClass = Block.byItem((Item)stack.getItem()).getClass();
        return blockClass == BotaniaFlowerBlock.class || blockClass == BotaniaDoubleFlowerBlock.class;
    }

    public static SimpleContainer getInventory(ItemStack stack) {
        return new ItemBackedInventory(stack, 32){

            public boolean canPlaceItem(int slot, @NotNull ItemStack stack) {
                return stack.is(FlowerPouchItem.getFlowerForSlot(slot));
            }
        };
    }

    public static boolean onPickupItem(ItemEntity entity, Player player) {
        ItemStack entityStack = entity.getItem();
        Block block = Block.byItem((Item)entityStack.getItem());
        if (FlowerPouchItem.isMysticalFlower(entityStack) && entityStack.getCount() > 0) {
            int slot;
            if (block instanceof BotaniaDoubleFlowerBlock) {
                BotaniaDoubleFlowerBlock flower = (BotaniaDoubleFlowerBlock)block;
                slot = 16 + flower.color.getId();
            } else {
                slot = ((BotaniaFlowerBlock)block).color.getId();
            }
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                SimpleContainer bagInv;
                ItemStack existing;
                int newCount;
                int numPickedUp;
                ItemStack bag;
                if (i == player.getInventory().selected || (bag = player.getInventory().getItem(i)).isEmpty() || !bag.is(BotaniaItems.flowerBag) || (numPickedUp = (newCount = Math.min((existing = (bagInv = FlowerPouchItem.getInventory(bag)).getItem(slot)).getCount() + entityStack.getCount(), Math.min(existing.getMaxStackSize(), bagInv.getMaxStackSize()))) - existing.getCount()) <= 0) continue;
                if (existing.isEmpty()) {
                    bagInv.setItem(slot, entityStack.split(numPickedUp));
                } else {
                    existing.grow(numPickedUp);
                    entityStack.shrink(numPickedUp);
                }
                EntityHelper.syncItem(entity);
                bagInv.setChanged();
                player.take((Entity)entity, numPickedUp);
                return true;
            }
        }
        return false;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @NotNull InteractionHand hand) {
        if (!world.isClientSide) {
            final ItemStack stack = player.getItemInHand(hand);
            XplatAbstractions.INSTANCE.openMenu((ServerPlayer)player, new MenuProvider(){

                public Component getDisplayName() {
                    return stack.getHoverName();
                }

                public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                    return new FlowerPouchContainer(syncId, inv, stack);
                }
            }, buf -> buf.writeBoolean(hand == InteractionHand.MAIN_HAND));
        }
        return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)world.isClientSide());
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        Direction side = ctx.getClickedFace();
        BlockEntity tile = world.getBlockEntity(pos);
        if ((ctx.getPlayer() == null || ctx.getPlayer().isSecondaryUseActive()) && XplatAbstractions.INSTANCE.hasInventory(world, pos, side)) {
            if (!world.isClientSide) {
                SimpleContainer bagInv = FlowerPouchItem.getInventory(ctx.getItemInHand());
                for (int i = 0; i < bagInv.getContainerSize(); ++i) {
                    ItemStack flower = bagInv.getItem(i);
                    ItemStack rem = XplatAbstractions.INSTANCE.insertToInventory(world, pos, side, flower, false);
                    bagInv.setItem(i, rem);
                }
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        return InteractionResult.PASS;
    }

    public void onDestroyed(@NotNull ItemEntity entity) {
        SimpleContainer container = FlowerPouchItem.getInventory(entity.getItem());
        Stream<ItemStack> stream = IntStream.range(0, container.getContainerSize()).mapToObj(arg_0 -> ((SimpleContainer)container).getItem(arg_0)).filter(s -> !s.isEmpty());
        ItemUtils.onContainerDestroyed((ItemEntity)entity, stream);
        container.clearContent();
    }

    public boolean overrideStackedOnOther(@NotNull ItemStack bag, @NotNull Slot slot, @NotNull ClickAction clickAction, @NotNull Player player) {
        return InventoryHelper.overrideStackedOnOther(FlowerPouchItem::getInventory, player.containerMenu instanceof FlowerPouchContainer, bag, slot, clickAction, player);
    }

    public boolean overrideOtherStackedOnMe(@NotNull ItemStack bag, @NotNull ItemStack toInsert, @NotNull Slot slot, @NotNull ClickAction clickAction, @NotNull Player player, @NotNull SlotAccess cursorAccess) {
        return InventoryHelper.overrideOtherStackedOnMe(FlowerPouchItem::getInventory, player.containerMenu instanceof FlowerPouchContainer, bag, toInsert, clickAction, cursorAccess);
    }
}

