/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.entity.SparkBaseEntity;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;

public abstract class BaseSparkRenderer<T extends SparkBaseEntity>
extends EntityRenderer<T> {
    private final TextureAtlasSprite starSprite;
    private final TextureAtlasSprite worldSprite;

    public BaseSparkRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        Function atlas = Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS);
        this.starSprite = Objects.requireNonNull((TextureAtlasSprite)atlas.apply(ResourceLocationHelper.prefix("item/corporea_spark_star")));
        this.worldSprite = Objects.requireNonNull((TextureAtlasSprite)atlas.apply(ResourceLocationHelper.prefix("item/spark")));
    }

    public void render(@NotNull T tEntity, float yaw, float partialTicks, PoseStack ms, MultiBufferSource buffers, int light) {
        TextureAtlasSprite iicon = this.getBaseIcon(tEntity);
        ms.pushPose();
        double time = (float)(tEntity.level().getGameTime() % 24000L) + partialTicks + (float)new Random(tEntity.getId()).nextInt(200);
        float a = 0.1f + (float)(!tEntity.isInvisible() ? 1 : 0) * 0.8f;
        int alpha = (int)((0.7 + 0.3 * (Math.sin(time / 5.0) + 0.5) * 2.0) * (double)a * 255.0);
        int iconColor = 0xFFFFFF | alpha << 24;
        float scale = 0.75f + 0.1f * (float)Math.sin(time / 10.0);
        ms.scale(scale, scale, scale);
        VertexConsumer buffer = buffers.getBuffer(RenderHelper.SPARK);
        ms.pushPose();
        ms.mulPose(this.entityRenderDispatcher.cameraOrientation());
        ms.mulPose(VecHelper.rotateY(180.0f));
        this.renderIcon(ms, buffer, iicon, iconColor);
        ms.pushPose();
        ms.translate(-0.02 + Math.sin(time / 20.0) * 0.2, 0.24 + Math.cos(time / 20.0) * 0.2, 0.005);
        ms.scale(0.2f, 0.2f, 0.2f);
        int starColor = ColorHelper.getColorValue(((SparkBaseEntity)tEntity).getNetwork()) | (int)(a * 255.0f) << 24;
        this.renderIcon(ms, buffer, this.starSprite, starColor);
        ms.popPose();
        TextureAtlasSprite spinningIcon = this.getSpinningIcon(tEntity);
        if (spinningIcon != null) {
            ms.translate(-0.02 + Math.sin(time / 20.0) * -0.2, 0.24 + Math.cos(time / 20.0) * -0.2, 0.005);
            ms.scale(0.2f, 0.2f, 0.2f);
            this.renderIcon(ms, buffer, spinningIcon, iconColor);
        }
        ms.popPose();
        ms.popPose();
    }

    protected TextureAtlasSprite getBaseIcon(T entity) {
        return this.worldSprite;
    }

    @Nullable
    protected TextureAtlasSprite getSpinningIcon(T entity) {
        return null;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull SparkBaseEntity entity) {
        return InventoryMenu.BLOCK_ATLAS;
    }

    private void renderIcon(PoseStack ms, VertexConsumer buffer, TextureAtlasSprite icon, int color) {
        float f = icon.getU0();
        float f1 = icon.getU1();
        float f2 = icon.getV0();
        float f3 = icon.getV1();
        float f4 = 1.0f;
        float f5 = 0.5f;
        float f6 = 0.25f;
        int fullbright = 0xF000F0;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        Matrix4f mat = ms.last().pose();
        buffer.vertex(mat, 0.0f - f5, 0.0f - f6, 0.0f).color(r, g, b, a).uv(f, f3).uv2(fullbright).endVertex();
        buffer.vertex(mat, f4 - f5, 0.0f - f6, 0.0f).color(r, g, b, a).uv(f1, f3).uv2(fullbright).endVertex();
        buffer.vertex(mat, f4 - f5, f4 - f6, 0.0f).color(r, g, b, a).uv(f1, f2).uv2(fullbright).endVertex();
        buffer.vertex(mat, 0.0f - f5, f4 - f6, 0.0f).color(r, g, b, a).uv(f, f2).uv2(fullbright).endVertex();
    }
}

