/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.mixin.AbstractCauldronBlockAccessor;

public class SeasRodItem
extends Item {
    public static final int COST = 75;

    public SeasRodItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        BlockHitResult blockHitResult = SeasRodItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (blockHitResult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        if (blockHitResult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemStack);
        }
        BlockPos blockPos = blockHitResult.getBlockPos();
        Direction direction = blockHitResult.getDirection();
        BlockPos blockPos2 = blockPos.relative(direction);
        if (level.mayInteract(player, blockPos) && player.mayUseItemAt(blockPos2, direction, itemStack)) {
            boolean success;
            AbstractCauldronBlock cauldronBlock;
            CauldronInteraction interaction;
            Block block;
            BlockState blockState = level.getBlockState(blockPos);
            boolean manaSuccess = ManaItemHandler.instance().requestManaExactForTool(itemStack, player, 75, true);
            if (manaSuccess && !player.isShiftKeyDown() && (block = blockState.getBlock()) instanceof AbstractCauldronBlock && (interaction = ((AbstractCauldronBlockAccessor)(cauldronBlock = (AbstractCauldronBlock)block)).botania_getInteractions().get(Items.WATER_BUCKET)) != null) {
                InteractionResult result = interaction.interact(blockState, level, blockPos, player, interactionHand, itemStack);
                if (!ItemStack.matches((ItemStack)player.getItemInHand(interactionHand), (ItemStack)itemStack)) {
                    player.setItemInHand(interactionHand, itemStack);
                }
                if (result.consumesAction()) {
                    SeasRodItem.spawnParticles(player, blockPos);
                }
                return new InteractionResultHolder(result, (Object)itemStack);
            }
            BlockPos blockPos3 = blockState.getBlock() instanceof LiquidBlockContainer ? blockPos : blockPos2;
            boolean bl = success = manaSuccess && ((BucketItem)Items.WATER_BUCKET).emptyContents(player, level, blockPos3, blockHitResult);
            if (success) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.PLACED_BLOCK.trigger(serverPlayer, blockPos3, itemStack);
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                SeasRodItem.spawnParticles(player, blockPos3);
                return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
            }
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }

    private static void spawnParticles(Player player, BlockPos blockPos3) {
        SparkleParticleData data = SparkleParticleData.sparkle(1.0f, 0.2f, 0.2f, 1.0f, 5);
        for (int i = 0; i < 6; ++i) {
            player.level().addParticle((ParticleOptions)data, (double)blockPos3.getX() + Math.random(), (double)blockPos3.getY() + Math.random(), (double)blockPos3.getZ() + Math.random(), 0.0, 0.0, 0.0);
        }
    }

    public boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction action, Player player) {
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack other = slot.getItem();
        if (other.is(Items.BUCKET) && ManaItemHandler.instance().requestManaExactForTool(stack, player, 75, true)) {
            if (other.getCount() == 1) {
                slot.set(new ItemStack((ItemLike)Items.WATER_BUCKET));
            } else {
                other.shrink(1);
                player.getInventory().placeItemBackInInventory(new ItemStack((ItemLike)Items.WATER_BUCKET));
            }
            return true;
        }
        return false;
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        if (other.is(Items.BUCKET) && ManaItemHandler.instance().requestManaExactForTool(stack, player, 75, true)) {
            if (other.getCount() == 1) {
                access.set(new ItemStack((ItemLike)Items.WATER_BUCKET));
            } else {
                other.shrink(1);
                player.getInventory().placeItemBackInInventory(new ItemStack((ItemLike)Items.WATER_BUCKET));
            }
            return true;
        }
        return false;
    }
}

