/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.flower.generating;

import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.handler.BotaniaSounds;

import java.util.List;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1606;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_5712;

public class ShulkMeNotBlockEntity extends GeneratingFlowerBlockEntity {
	private static final int RADIUS = 8;

	public ShulkMeNotBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaFlowerBlocks.SHULK_ME_NOT, pos, state);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		int generate = getMaxMana();

		class_1937 world = method_10997();
		class_2338 pos = getEffectivePos();
		class_243 posD = new class_243(pos.method_10263(), pos.method_10264(), pos.method_10260());
		if (!world.field_9236) {
			List<class_1606> shulkers = world.method_18467(class_1606.class, new class_238(pos).method_1014(RADIUS));
			for (class_1606 shulker : shulkers) {
				if (getMaxMana() - getMana() < generate) {
					break;
				}

				if (shulker.method_5805() && shulker.method_5707(posD) < RADIUS * RADIUS) {
					class_1309 target = shulker.method_5968();
					if (target instanceof class_1569 && target.method_5805()
							&& target.method_5707(posD) < RADIUS * RADIUS && target.method_6112(class_1294.field_5902) != null) {
						target.method_31472();
						shulker.method_31472();

						for (int i = 0; i < 10; i++) {
							// so it's really loud >_>
							world.method_43128(null, pos.method_10263() + 0.5, pos.method_10264() + 0.5, pos.method_10260() + 0.5, BotaniaSounds.shulkMeNot, class_3419.field_15245, 10F, 1F);
						}
						particles(world, pos, target);
						particles(world, pos, shulker);

						world.method_33596(null, class_5712.field_28174, pos);
						addMana(generate);
						sync();
					}
				}
			}
		}
	}

	private void particles(class_1937 world, class_2338 pos, class_1297 entity) {
		if (world instanceof class_3218 ws) {
			ws.method_14199(class_2398.field_11236,
					entity.method_23317() + entity.method_17681() / 2,
					entity.method_23318() + entity.method_17682() / 2,
					entity.method_23321() + entity.method_17681() / 2,
					100, entity.method_17681(), entity.method_17682(), entity.method_17681(), 0.05);
			ws.method_14199(class_2398.field_11214, pos.method_10263() + 0.5, pos.method_10264() + 0.5, pos.method_10260() + 0.5, 40, 0, 0, 0, 0.6);
		}
	}

	@Override
	public int getColor() {
		return 0x815598;
	}

	@Override
	public RadiusDescriptor getRadius() {
		return new RadiusDescriptor.Circle(getEffectivePos(), RADIUS);
	}

	@Override
	public int getMaxMana() {
		return 75000;
	}

}
