/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1496;
import net.minecraft.class_1498;
import net.minecraft.class_1506;
import net.minecraft.class_1507;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_3730;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.mixin.AbstractHorseAccessor;

public class EquestrianVirusItem extends class_1792 {
	public EquestrianVirusItem(class_1793 builder) {
		super(builder);
	}

	@Override
	public class_1269 method_7847(class_1799 stack, class_1657 player, class_1309 living, class_1268 hand) {
		if (living.method_5805() && living instanceof class_1498 horse) {
			if (player.method_37908().field_9236) {
				return class_1269.field_5812;
			}
			if (horse.method_6727()) {
				class_1277 inv = ((AbstractHorseAccessor) horse).getInventory();
				class_1799 saddle = inv.method_5438(0);

				// Not all AbstractHorse's have saddles in slot 0
				if (!saddle.method_7960() && !saddle.method_31574(class_1802.field_8175)) {
					horse.method_5699(saddle, 0);
					saddle = class_1799.field_8037;
				}

				for (int i = 1; i < inv.method_5439(); i++) {
					if (!inv.method_5438(i).method_7960()) {
						horse.method_5699(inv.method_5438(i), 0);
					}
				}

				horse.method_31472();

				class_1496 newHorse = stack.method_31574(BotaniaItems.necroVirus)
						? class_1299.field_6048.method_5883(player.method_37908())
						: class_1299.field_6075.method_5883(player.method_37908());
				newHorse.method_6752(player);
				newHorse.method_5641(horse.method_23317(), horse.method_23318(), horse.method_23321(), horse.method_36454(), horse.method_36455());

				// Put the saddle back
				if (!saddle.method_7960()) {
					class_1277 newInv = ((AbstractHorseAccessor) newHorse).getInventory();
					newInv.method_5447(0, saddle);
				}

				class_1324 movementSpeed = newHorse.method_5996(class_5134.field_23719);
				movementSpeed.method_6192(horse.method_5996(class_5134.field_23719).method_6201());
				movementSpeed.method_26837(new class_1322("Ermergerd Virus D:", movementSpeed.method_6201(), class_1322.class_1323.field_6328));

				class_1324 health = newHorse.method_5996(class_5134.field_23716);
				health.method_6192(horse.method_5996(class_5134.field_23716).method_6201());
				health.method_26837(new class_1322("Ermergerd Virus D:", health.method_6201(), class_1322.class_1323.field_6328));

				class_1324 jumpHeight = newHorse.method_5996(class_5134.field_23728);
				jumpHeight.method_6192(horse.method_5996(class_5134.field_23728).method_6201());
				jumpHeight.method_26837(new class_1322("Ermergerd Virus D:", jumpHeight.method_6201() * 0.5, class_1322.class_1323.field_6328));

				newHorse.method_5783(BotaniaSounds.virusInfect, 1.0F + living.method_37908().field_9229.method_43057(), living.method_37908().field_9229.method_43057() * 0.7F + 1.3F);
				newHorse.method_5943((class_5425) player.method_37908(), player.method_37908().method_8404(newHorse.method_24515()), class_3730.field_16468, null, null);
				newHorse.method_5614(horse.method_5618());
				player.method_37908().method_8649(newHorse);
				newHorse.method_5990();

				stack.method_7934(1);
				return class_1269.field_5812;
			}
		}
		return class_1269.field_5811;
	}

	public static boolean onLivingHurt(class_1309 entity, class_1282 source) {
		if (entity.method_5765() && entity.method_5854() instanceof class_1309 vehicle) {
			entity = vehicle;
		}

		if ((entity instanceof class_1507 || entity instanceof class_1506)
				&& source == entity.method_48923().method_48827()
				&& ((class_1496) entity).method_6727()) {
			return true;
		}

		return false;
	}
}
