/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data;

import com.google.gson.JsonElement;
import net.minecraft.class_1767;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2405;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2521;
import net.minecraft.class_2544;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_2760;
import net.minecraft.class_2771;
import net.minecraft.class_2778;
import net.minecraft.class_2960;
import net.minecraft.class_4778;
import net.minecraft.class_4917;
import net.minecraft.class_4918;
import net.minecraft.class_4922;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4926.class_4927;
import net.minecraft.class_4926.class_4929;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4938;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;
import net.minecraft.data.models.blockstates.*;
import net.minecraft.data.models.model.*;
import net.minecraft.world.level.block.*;
import net.minecraft.world.level.block.state.properties.*;

import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.api.state.enums.AlfheimPortalState;
import vazkii.botania.api.state.enums.CraftyCratePattern;
import vazkii.botania.common.block.*;
import vazkii.botania.common.block.decor.BotaniaMushroomBlock;
import vazkii.botania.common.block.decor.BuriedPetalBlock;
import vazkii.botania.common.block.decor.FloatingFlowerBlock;
import vazkii.botania.common.block.decor.FlowerMotifBlock;
import vazkii.botania.common.block.decor.PetalBlock;
import vazkii.botania.common.block.decor.panes.BotaniaPaneBlock;
import vazkii.botania.common.block.red_string.RedStringBlock;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.lib.LibBlockNames;
import vazkii.botania.common.lib.LibMisc;
import vazkii.botania.mixin.BlockModelGeneratorsAccessor;
import vazkii.botania.mixin.TextureSlotAccessor;
import vazkii.botania.xplat.XplatAbstractions;

import java.nio.file.Path;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.function.*;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

import static net.minecraft.class_4941.method_25841;
import static net.minecraft.class_4944.method_25866;
import static vazkii.botania.common.block.BotaniaBlocks.*;
import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

import ;

public class BlockstateProvider implements class_2405 {
	protected final class_7784 packOutput;

	protected final List<class_4917> blockstates = new ArrayList<>();

	protected final Map<class_2960, Supplier<JsonElement>> models = new HashMap<>();
	protected final BiConsumer<class_2960, Supplier<JsonElement>> modelOutput = models::put;

	public BlockstateProvider(class_7784 packOutput) {
		this.packOutput = packOutput;
	}

	protected Logger getLogger() {
		return BotaniaAPI.LOGGER;
	}

	@NotNull
	@Override
	public String method_10321() {
		return "Botania Blockstates and Models";
	}

	@Override
	public CompletableFuture<?> method_10319(class_7403 cache) {
		try {
			registerStatesAndModels();
		} catch (Exception e) {
			getLogger().error("Error registering states and models", e);
		}

		class_7784.class_7489 blockstatePathProvider = packOutput.method_45973(class_7784.class_7490.field_39368, "blockstates");
		class_7784.class_7489 modelPathProvider = packOutput.method_45973(class_7784.class_7490.field_39368, "models");
		List<CompletableFuture<?>> output = new ArrayList<>();

		for (class_4917 state : blockstates) {
			class_2960 id = class_7923.field_41175.method_10221(state.method_25743());
			Path path = blockstatePathProvider.method_44107(id);
			output.add(class_2405.method_10320(cache, state.get(), path));
		}

		for (Map.Entry<class_2960, Supplier<JsonElement>> e : models.entrySet()) {
			class_2960 modelId = e.getKey();
			Path path = modelPathProvider.method_44107(modelId);
			output.add(class_2405.method_10320(cache, e.getValue().get(), path));
		}
		return CompletableFuture.allOf(output.toArray(CompletableFuture[]::new));
	}

	protected void registerStatesAndModels() {
		Set<class_2248> remainingBlocks = class_7923.field_41175.method_10220()
				.filter(b -> LibMisc.MOD_ID.equals(class_7923.field_41175.method_10221(b).method_12836()))
				.collect(Collectors.toSet());

		// Manually written blockstate + models
		remainingBlocks.remove(ghostRail);
		remainingBlocks.remove(solidVines);

		// Manually written model, generated blockstate
		manualModel(remainingBlocks, cocoon);
		manualModel(remainingBlocks, corporeaCrystalCube);
		manualModel(remainingBlocks, distributor);
		manualModel(remainingBlocks, prism);
		manualModel(remainingBlocks, runeAltar);
		manualModel(remainingBlocks, spawnerClaw);

		// Single blocks
		var alfPortalModel = class_4943.field_22972.method_25852(method_25842(alfPortal), class_4944.method_25864(alfPortal), this.modelOutput);
		var alfPortalActivatedModel = class_4943.field_22972.method_25852(method_25843(alfPortal, "_activated"), class_4944.method_25875(method_25843(alfPortal, "_activated")), this.modelOutput);
		this.blockstates.add(
				class_4925.method_25769(alfPortal).method_25775(
						class_4926.method_25783(BotaniaStateProperties.ALFPORTAL_STATE)
								.method_25793(AlfheimPortalState.OFF, class_4935.method_25824().method_25828(class_4936.field_22887, alfPortalModel))
								.method_25793(AlfheimPortalState.ON_X, class_4935.method_25824().method_25828(class_4936.field_22887, alfPortalActivatedModel))
								.method_25793(AlfheimPortalState.ON_Z, class_4935.method_25824().method_25828(class_4936.field_22887, alfPortalActivatedModel))
				));
		remainingBlocks.remove(alfPortal);

		singleVariantBlockState(bifrostPerm,
				class_4943.field_22972.method_25852(
						method_25842(bifrostPerm),
						class_4944.method_25864(bifrost), this.modelOutput));
		remainingBlocks.remove(bifrostPerm);

		singleVariantBlockState(cacophonium,
				class_4943.field_22976.method_25846(cacophonium, (new class_4944())
						.method_25868(class_4945.field_23018, method_25860(class_2246.field_10179))
						.method_25868(class_4945.field_23015, method_25866(cacophonium, "_top")), this.modelOutput));
		remainingBlocks.remove(cacophonium);

		var crateTemplate = new class_4942(Optional.of(prefix("block/shapes/crate")), Optional.empty(),
				class_4945.field_23014, class_4945.field_23018);
		var craftCrateBottomTex = method_25866(craftCrate, "_bottom");
		var crateDispatch = class_4926.method_25783(BotaniaStateProperties.CRATE_PATTERN);
		for (var pattern : CraftyCratePattern.values()) {
			String suffix = pattern == CraftyCratePattern.NONE ? "" : "_" + pattern.method_15434().substring("crafty_".length());
			var model = crateTemplate.method_25852(method_25843(craftCrate, suffix),
					new class_4944().method_25868(class_4945.field_23014, craftCrateBottomTex)
							.method_25868(class_4945.field_23018, method_25866(craftCrate, suffix)),
					this.modelOutput);
			crateDispatch = crateDispatch.method_25793(pattern, class_4935.method_25824().method_25828(class_4936.field_22887, model));
		}
		this.blockstates.add(class_4925.method_25769(craftCrate).method_25775(crateDispatch));
		remainingBlocks.remove(craftCrate);

		class_2960 corpSlabSide = prefix("block/corporea_slab_side");
		class_2960 corpBlock = method_25860(corporeaBlock);
		var corpSlabBottomModel = class_4943.field_22909.method_25846(corporeaSlab,
				new class_4944()
						.method_25868(class_4945.field_23014, corpBlock).method_25868(class_4945.field_23015, corpBlock).method_25868(class_4945.field_23018, corpBlock),
				this.modelOutput);
		var corpSlabTopModel = class_4943.field_22910.method_25852(method_25843(corporeaSlab, "_top"),
				new class_4944()
						.method_25868(class_4945.field_23014, corpBlock).method_25868(class_4945.field_23015, corpBlock).method_25868(class_4945.field_23018, corpBlock),
				this.modelOutput);
		var corpSlabDoubleModel = class_4943.field_22977.method_25852(prefix("block/corporea_double_slab"),
				new class_4944()
						.method_25868(class_4945.field_23018, corpSlabSide).method_25868(class_4945.field_23014, corpBlock).method_25868(class_4945.field_23015, corpBlock),
				this.modelOutput);
		blockstates.add(BlockModelGeneratorsAccessor.makeSlabState(corporeaSlab, corpSlabBottomModel, corpSlabTopModel, corpSlabDoubleModel));
		remainingBlocks.remove(corporeaSlab);

		stairsBlock(remainingBlocks, corporeaStairs, corpBlock, corpBlock, corpBlock);

		this.blockstates.add(class_4925.method_25771(elfGlass, IntStream.rangeClosed(0, 3)
				.mapToObj(i -> {
					var model = class_4943.field_22972.method_25852(
							method_25843(elfGlass, "_" + i),
							class_4944.method_25875(method_25866(elfGlass, "_" + i)),
							this.modelOutput);
					return class_4935.method_25824().method_25828(class_4936.field_22887, model);
				})
				.toArray(class_4935[]::new)));
		remainingBlocks.remove(elfGlass);

		singleVariantBlockState(enchantedSoil, class_4943.field_22977.method_25846(
				enchantedSoil,
				class_4944.method_25898(enchantedSoil).method_25868(class_4945.field_23014, method_25860(class_2246.field_10566)),
				this.modelOutput
		));
		remainingBlocks.remove(enchantedSoil);

		var pumpkinModel = class_4943.field_22978.method_25846(felPumpkin, new class_4944()
				.method_25868(class_4945.field_23018, method_25866(class_2246.field_10261, "_side"))
				.method_25868(class_4945.field_23016, method_25860(felPumpkin))
				.method_25868(class_4945.field_23015, method_25866(class_2246.field_10261, "_top")),
				this.modelOutput
		);
		this.blockstates.add(class_4925.method_25770(felPumpkin, class_4935.method_25824().method_25828(class_4936.field_22887, pumpkinModel))
				.method_25775(BlockModelGeneratorsAccessor.horizontalDispatch()));
		remainingBlocks.remove(felPumpkin);

		class_4942 eightByEightTemplate = new class_4942(Optional.of(prefix("block/shapes/eightbyeight")),
				Optional.empty(),
				class_4945.field_23014, class_4945.field_23015, class_4945.field_23019, class_4945.field_23020, class_4945.field_23022, class_4945.field_23021);
		singleVariantBlockState(forestEye, eightByEightTemplate.method_25846(forestEye,
				new class_4944()
						.method_25868(class_4945.field_23014, method_25866(forestEye, "_bottom"))
						.method_25868(class_4945.field_23015, method_25866(forestEye, "_top"))
						.method_25868(class_4945.field_23019, method_25866(forestEye, "_north"))
						.method_25868(class_4945.field_23020, method_25866(forestEye, "_south"))
						.method_25868(class_4945.field_23022, method_25866(forestEye, "_west"))
						.method_25868(class_4945.field_23021, method_25866(forestEye, "_east")),
				this.modelOutput));
		remainingBlocks.remove(forestEye);

		var plateFile = method_25842(incensePlate);
		this.blockstates.add(class_4925.method_25770(incensePlate, class_4935.method_25824().method_25828(class_4936.field_22887, plateFile))
				.method_25775(BlockModelGeneratorsAccessor.horizontalDispatch()));
		remainingBlocks.remove(incensePlate);

		var fourHighBottomTopTemplate = new class_4942(Optional.of(prefix("block/shapes/four_high_bottom_top")),
				Optional.empty(),
				class_4945.field_23014, class_4945.field_23015, class_4945.field_23018);
		singleVariantBlockState(lightLauncher, fourHighBottomTopTemplate.method_25846(lightLauncher,
				new class_4944()
						.method_25868(class_4945.field_23014, method_25866(lightLauncher, "_end"))
						.method_25868(class_4945.field_23015, method_25866(lightLauncher, "_end"))
						.method_25868(class_4945.field_23018, method_25866(lightLauncher, "_side")),
				this.modelOutput
		));
		remainingBlocks.remove(lightLauncher);

		singleVariantBlockState(openCrate,
				crateTemplate.method_25846(openCrate, new class_4944()
						.method_25868(class_4945.field_23018, method_25860(openCrate))
						.method_25868(class_4945.field_23014, method_25866(openCrate, "_bottom")),
						this.modelOutput
				));
		remainingBlocks.remove(openCrate);

		var threeHighBottomTopTemplate = new class_4942(Optional.of(prefix("block/shapes/three_high_bottom_top")),
				Optional.empty(),
				class_4945.field_23014, class_4945.field_23015, class_4945.field_23018);
		singleVariantBlockState(sparkChanger, threeHighBottomTopTemplate.method_25846(sparkChanger,
				class_4944.method_25898(sparkChanger),
				this.modelOutput));
		remainingBlocks.remove(sparkChanger);

		singleVariantBlockState(starfield, fourHighBottomTopTemplate.method_25846(starfield,
				class_4944.method_25898(starfield), this.modelOutput));
		remainingBlocks.remove(starfield);

		singleVariantBlockState(terraPlate, threeHighBottomTopTemplate.method_25846(terraPlate,
				class_4944.method_25898(terraPlate), this.modelOutput));
		remainingBlocks.remove(terraPlate);

		var tenByTenAllTemplate = new class_4942(Optional.of(prefix("block/shapes/tenbyten_all")),
				Optional.empty(),
				class_4945.field_23010);
		singleVariantBlockState(tinyPlanet, tenByTenAllTemplate.method_25846(tinyPlanet,
				class_4944.method_25864(tinyPlanet), this.modelOutput));
		remainingBlocks.remove(tinyPlanet);

		singleVariantBlockState(turntable, class_4943.field_22977.method_25846(turntable,
				class_4944.method_25898(turntable),
				this.modelOutput
		));
		remainingBlocks.remove(turntable);

		class_2960[] topTexs = new class_2960[6];
		class_2960[] sideTexs = new class_2960[6];
		class_2960[] topStrippedTexs = new class_2960[6];
		class_2960[] sideStrippedTexs = new class_2960[6];
		class_2960[] sideGlimmeringTexs = new class_2960[6];
		class_2960[] sideGlimmeringStrippedTexs = new class_2960[6];
		class_2960[] logModels = new class_2960[6];
		class_2960[] strippedLogModels = new class_2960[6];

		for (int i = 0; i < 6; i++) {
			String suffix = i == 0 ? "" : "_" + i;
			sideTexs[i] = method_25866(dreamwoodLog, suffix);
			topTexs[i] = method_25866(dreamwoodLog, "_top");
			sideStrippedTexs[i] = method_25866(dreamwoodLogStripped, suffix);
			topStrippedTexs[i] = method_25866(dreamwoodLogStripped, "_top");
			sideGlimmeringTexs[i] = method_25866(dreamwoodLogGlimmering, suffix);
			sideGlimmeringStrippedTexs[i] = method_25866(dreamwoodLogStrippedGlimmering, suffix);
			logModels[i] = method_25843(dreamwood, suffix);
			strippedLogModels[i] = method_25843(dreamwoodStripped, suffix);
		}

		pillarWithVariants(remainingBlocks, dreamwoodLog, topTexs, sideTexs);
		pillarWithVariants(remainingBlocks, dreamwood, sideTexs, sideTexs);
		pillarWithVariants(remainingBlocks, dreamwoodLogStripped, topStrippedTexs, sideStrippedTexs);
		pillarWithVariants(remainingBlocks, dreamwoodStripped, sideStrippedTexs, sideStrippedTexs);
		pillarWithVariants(remainingBlocks, dreamwoodLogGlimmering, topTexs, sideGlimmeringTexs);
		pillarWithVariants(remainingBlocks, dreamwoodGlimmering, sideGlimmeringTexs, sideGlimmeringTexs);
		pillarWithVariants(remainingBlocks, dreamwoodLogStrippedGlimmering, topStrippedTexs, sideGlimmeringStrippedTexs);
		pillarWithVariants(remainingBlocks, dreamwoodStrippedGlimmering, sideGlimmeringStrippedTexs, sideGlimmeringStrippedTexs);

		stairsBlockWithVariants(remainingBlocks, dreamwoodStairs, sideTexs, sideTexs, sideTexs);
		stairsBlockWithVariants(remainingBlocks, dreamwoodStrippedStairs, sideStrippedTexs, sideStrippedTexs, sideStrippedTexs);
		slabBlockWithVariants(remainingBlocks, dreamwoodSlab, logModels, sideTexs, sideTexs, sideTexs);
		slabBlockWithVariants(remainingBlocks, dreamwoodStrippedSlab, strippedLogModels, sideStrippedTexs, sideStrippedTexs, sideStrippedTexs);
		wallBlockWithVariants(remainingBlocks, dreamwoodWall, sideTexs);
		wallBlockWithVariants(remainingBlocks, dreamwoodStrippedWall, sideStrippedTexs);

		pillar(remainingBlocks, livingwoodLog, method_25866(livingwoodLog, "_top"), method_25860(livingwoodLog));
		pillar(remainingBlocks, livingwood, method_25860(livingwoodLog), method_25860(livingwoodLog));
		pillar(remainingBlocks, livingwoodLogStripped, method_25866(livingwoodLogStripped, "_top"), method_25860(livingwoodLogStripped));
		pillar(remainingBlocks, livingwoodStripped, method_25860(livingwoodLogStripped), method_25860(livingwoodLogStripped));
		pillar(remainingBlocks, livingwoodLogGlimmering, method_25866(livingwoodLog, "_top"), method_25860(livingwoodLogGlimmering));
		pillar(remainingBlocks, livingwoodGlimmering, method_25860(livingwoodLogGlimmering), method_25860(livingwoodLogGlimmering));
		pillar(remainingBlocks, livingwoodLogStrippedGlimmering, method_25866(livingwoodLogStripped, "_top"), method_25860(livingwoodLogStrippedGlimmering));
		pillar(remainingBlocks, livingwoodStrippedGlimmering, method_25860(livingwoodLogStrippedGlimmering), method_25860(livingwoodLogStrippedGlimmering));

		pillarAlt(remainingBlocks, livingwoodFramed, method_25860(livingwoodPatternFramed), method_25860(livingwoodFramed));
		pillarAlt(remainingBlocks, dreamwoodFramed, method_25860(dreamwoodPatternFramed), method_25860(dreamwoodFramed));

		stairsBlock(remainingBlocks, livingwoodStairs, method_25860(livingwoodLog), method_25860(livingwoodLog), method_25860(livingwoodLog));
		stairsBlock(remainingBlocks, livingwoodStrippedStairs, method_25860(livingwoodLogStripped), method_25860(livingwoodLogStripped), method_25860(livingwoodLogStripped));
		slabBlock(remainingBlocks, livingwoodSlab, method_25842(livingwood), method_25860(livingwoodLog), method_25860(livingwoodLog), method_25860(livingwoodLog));
		slabBlock(remainingBlocks, livingwoodStrippedSlab, method_25842(livingwoodStripped), method_25860(livingwoodLogStripped), method_25860(livingwoodLogStripped), method_25860(livingwoodLogStripped));
		wallBlock(remainingBlocks, livingwoodWall, method_25860(livingwoodLog));
		wallBlock(remainingBlocks, livingwoodStrippedWall, method_25860(livingwoodLogStripped));

		fenceBlock(remainingBlocks, dreamwoodFence, method_25860(dreamwoodPlanks));
		fenceGateBlock(remainingBlocks, dreamwoodFenceGate, method_25860(dreamwoodPlanks));
		fenceBlock(remainingBlocks, livingwoodFence, method_25860(livingwoodPlanks));
		fenceGateBlock(remainingBlocks, livingwoodFenceGate, method_25860(livingwoodPlanks));

		rotatedMirrored(remainingBlocks, livingrock, method_25860(livingrock));

		class_2960 polishedLivingrockTexture = method_25860(livingrockPolished);
		class_2960 polishedLivingrockSlabSideTexture = method_25860(livingrockPolishedSlab);
		class_2960 polishedLivingrockSlabDoubleModel = class_4943.field_22974.method_25852(
				method_25843(livingrockPolishedSlab, "_double"),
				new class_4944()
						.method_25868(class_4945.field_23018, polishedLivingrockSlabSideTexture)
						.method_25868(class_4945.field_23013, polishedLivingrockTexture),
				this.modelOutput
		);
		slabBlock(remainingBlocks, livingrockPolishedSlab, polishedLivingrockSlabDoubleModel, polishedLivingrockSlabSideTexture, polishedLivingrockTexture, polishedLivingrockTexture);

		var conjurationTexture = method_25860(conjurationCatalyst);
		var conjurationMirrored = method_25866(conjurationCatalyst, "_mirrored");
		checkeredBlockWithBlockstate(remainingBlocks, conjurationCatalyst, conjurationTexture, conjurationMirrored);

		// block entities with only particles
		particleOnly(remainingBlocks, animatedTorch, method_25860(class_2246.field_10523));
		particleOnly(remainingBlocks, avatar, method_25860(livingwoodLog));
		particleOnly(remainingBlocks, bellows, method_25860(livingwoodLog));
		particleOnly(remainingBlocks, brewery, method_25860(livingrock));
		particleOnly(remainingBlocks, corporeaIndex, method_25860(corporeaBlock));
		particleOnly(remainingBlocks, lightRelayDetector, method_25860(lightRelayDetector));
		singleVariantBlockState(fakeAir, new class_4942(Optional.empty(), Optional.empty()).method_25846(fakeAir, new class_4944(), this.modelOutput));
		remainingBlocks.remove(fakeAir);
		particleOnly(remainingBlocks, lightRelayFork, method_25860(lightRelayFork));
		particleOnly(remainingBlocks, gaiaHead, method_25860(class_2246.field_10114));
		particleOnly(remainingBlocks, gaiaHeadWall, method_25860(class_2246.field_10114));
		particleOnly(remainingBlocks, gaiaPylon, method_25860(elementiumBlock));
		particleOnly(remainingBlocks, hourglass, method_25860(manaGlass));
		particleOnly(remainingBlocks, lightRelayDefault, method_25860(lightRelayDefault));
		particleOnly(remainingBlocks, manaFlame, new class_2960("block/fire_0"));
		particleOnly(remainingBlocks, manaPylon, method_25860(manasteelBlock));
		particleOnly(remainingBlocks, naturaPylon, method_25860(terrasteelBlock));
		particleOnly(remainingBlocks, teruTeruBozu, method_25860(class_2246.field_10446));
		particleOnly(remainingBlocks, lightRelayToggle, method_25860(lightRelayToggle));

		// Block groups
		Predicate<class_2248> flowers = b -> XplatAbstractions.INSTANCE.isSpecialFlowerBlock(b)
				|| b instanceof BotaniaMushroomBlock
				|| b instanceof BotaniaFlowerBlock;
		class_4942 crossTemplate = new class_4942(Optional.of(prefix("block/shapes/cross")), Optional.empty(), class_4945.field_23025);
		takeAll(remainingBlocks, flowers).forEach(b -> singleVariantBlockState(b, crossTemplate.method_25846(b, class_4944.method_25877(b), this.modelOutput))
		);

		takeAll(remainingBlocks, b -> b instanceof FlowerMotifBlock).forEach(b -> {
			String name = class_7923.field_41175.method_10221(b).method_12832().replace("_motif", "");
			singleVariantBlockState(b, crossTemplate.method_25846(b, new class_4944()
					.method_25868(class_4945.field_23025, prefix("block/" + name)),
					this.modelOutput));
		});

		takeAll(remainingBlocks, corporeaFunnel, corporeaInterceptor, corporeaRetainer).forEach(b -> {
			singleVariantBlockState(b, class_4943.field_22974.method_25846(b,
					class_4944.method_25870(method_25866(b, "_side"), method_25866(b, "_end")),
					this.modelOutput));
		});

		var drumModelTemplate = new class_4942(Optional.of(prefix("block/shapes/drum")), Optional.empty(), class_4945.field_23015, class_4945.field_23018);
		takeAll(remainingBlocks, gatheringDrum, canopyDrum, wildDrum).forEach(b -> {
			singleVariantBlockState(b, drumModelTemplate.method_25846(b,
					new class_4944()
							.method_25868(class_4945.field_23015, prefix("block/drum_top"))
							.method_25868(class_4945.field_23018, method_25860(b)),
					this.modelOutput));
		});

		var outsideSlot = TextureSlotAccessor.make("outside");
		var coreSlot = TextureSlotAccessor.make("core");
		var spreaderTemplate = new class_4942(Optional.of(prefix("block/shapes/spreader")), Optional.empty(),
				class_4945.field_23018, class_4945.field_23017, class_4945.field_27791, outsideSlot);
		var spreaderCoreTemplate = new class_4942(Optional.of(prefix("block/shapes/spreader_core")), Optional.of("_core"),
				coreSlot);
		var spreaderPaddingTemplate = new class_4942(Optional.of(prefix("block/shapes/spreader_padding")),
				Optional.empty(), class_4945.field_23016, class_4945.field_23017, class_4945.field_23018);
		var spreaderScaffoldingTemplate = new class_4942(Optional.of(prefix("block/shapes/spreader_scaffolding")),
				Optional.of("_scaffolding"), class_4945.field_23015, class_4945.field_23018, class_4945.field_23014);
		takeAll(remainingBlocks, manaSpreader, redstoneSpreader, gaiaSpreader, elvenSpreader).forEach(b -> {
			class_2960 outside;
			if (b == redstoneSpreader || b == manaSpreader) {
				outside = method_25860(livingwoodLog);
			} else if (b == elvenSpreader) {
				outside = method_25866(dreamwoodLog, "_3");
			} else {
				outside = method_25866(b, "_outside");
			}
			class_2960 inside;
			if (b == redstoneSpreader || b == manaSpreader) {
				inside = method_25860(livingwoodLogStripped);
			} else if (b == elvenSpreader) {
				inside = method_25866(dreamwoodLogStripped, "_3");
			} else {
				inside = method_25866(b, "_inside");
			}
			singleVariantBlockState(b, spreaderTemplate.method_25846(b, new class_4944()
					.method_25868(class_4945.field_23018, method_25866(b, "_side"))
					.method_25868(class_4945.field_23017, method_25866(b, "_back"))
					.method_25868(class_4945.field_27791, inside)
					.method_25868(outsideSlot, outside), this.modelOutput));
			spreaderCoreTemplate.method_25846(b, new class_4944()
					.method_25868(coreSlot, method_25866(b, "_core")), this.modelOutput);
			if (b != redstoneSpreader) {
				spreaderScaffoldingTemplate.method_25846(b, new class_4944()
						.method_25868(class_4945.field_23015, method_25866(b, "_scaffolding_top"))
						.method_25868(class_4945.field_23018, method_25866(b, "_scaffolding_side"))
						.method_25868(class_4945.field_23014, method_25866(b, "_scaffolding_bottom")), this.modelOutput);
			}
		});
		ColorHelper.supportedColors().forEach(color -> {
			class_2248 wool = ColorHelper.WOOL_MAP.apply(color);
			spreaderPaddingTemplate.method_25852(prefix("block/" + color.method_7792() + "_spreader_padding"),
					new class_4944()
							.method_25868(class_4945.field_23016, method_25860(wool))
							.method_25868(class_4945.field_23017, method_25860(wool))
							.method_25868(class_4945.field_23018, method_25860(wool)),
					this.modelOutput);
		});

		var manaSlot = TextureSlotAccessor.make("mana");
		class_4945[] manaPoolSlots = new class_4945[] { class_4945.field_23018, class_4945.field_23015, class_4945.field_23014, class_4945.field_27791 };
		class_4945[] manaPoolFullSlots = new class_4945[] { class_4945.field_23018, class_4945.field_23015, class_4945.field_23014, class_4945.field_27791, manaSlot };
		var poolTemplate = new class_4942(Optional.of(prefix("block/shapes/mana_pool")), Optional.empty(), manaPoolSlots);
		var dilutedPoolTemplate = new class_4942(Optional.of(prefix("block/shapes/diluted_mana_pool")), Optional.empty(), manaPoolSlots);
		var creativePoolTemplate = new class_4942(Optional.of(prefix("block/shapes/creative_mana_pool")), Optional.empty(), manaPoolSlots);
		var poolFullTemplate = new class_4942(Optional.of(prefix("block/shapes/mana_pool_full")), Optional.of("_full"), manaPoolFullSlots);
		var dilutedPoolFullTemplate = new class_4942(Optional.of(prefix("block/shapes/diluted_mana_pool_full")), Optional.of("_full"), manaPoolFullSlots);
		var creativePoolFullTemplate = new class_4942(Optional.of(prefix("block/shapes/creative_mana_pool_full")), Optional.of("_full"), manaPoolFullSlots);
		takeAll(remainingBlocks, manaPool, dilutedPool, fabulousPool, creativePool).forEach(b -> {
			class_2248 blockForTexture = b == fabulousPool ? manaPool : b;
			class_2960 side = method_25866(blockForTexture, "_side");
			class_2960 top = method_25866(blockForTexture, "_top");
			class_2960 bottom = b == dilutedPool
					? method_25866(manaPool, "_bottom") : method_25866(blockForTexture, "_bottom");
			class_2960 inside = method_25866(blockForTexture, "_inside");
			class_4942 template = b == dilutedPool
					? dilutedPoolTemplate
					: b == creativePool
							? creativePoolTemplate
					: poolTemplate;
			class_4942 fullTemplate = b == dilutedPool
					? dilutedPoolFullTemplate
					: b == creativePool
							? creativePoolFullTemplate
					: poolFullTemplate;
			class_4944 mapping = new class_4944()
					.method_25868(class_4945.field_23018, side)
					.method_25868(class_4945.field_23015, top)
					.method_25868(class_4945.field_23014, bottom)
					.method_25868(class_4945.field_27791, inside);

			singleVariantBlockState(b, template.method_25846(b, mapping, this.modelOutput));
			fullTemplate.method_25846(b, mapping.method_25868(manaSlot, prefix("block/mana_water")), this.modelOutput);
		});

		takeAll(remainingBlocks, pump, tinyPotato).forEach(b -> this.blockstates.add(class_4925.method_25770(b, class_4935.method_25824().method_25828(class_4936.field_22887, method_25842(b)))
				.method_25775(BlockModelGeneratorsAccessor.horizontalDispatch()))
		);

		takeAll(remainingBlocks, enderEye, manaDetector).forEach(b -> {
			var offModel = class_4943.field_22972.method_25846(b, class_4944.method_25864(b), this.modelOutput);
			var onModel = class_4943.field_22972.method_25852(method_25843(b, "_powered"),
					class_4944.method_25875(method_25866(b, "_powered")), this.modelOutput);
			this.blockstates.add(class_4925.method_25769(b).method_25775(
					class_4926.method_25783(class_2741.field_12484)
							.method_25793(false, class_4935.method_25824().method_25828(class_4936.field_22887, offModel))
							.method_25793(true, class_4935.method_25824().method_25828(class_4936.field_22887, onModel))
			));
		});

		var petalBlockModel = new class_4942(Optional.of(prefix("block/shapes/cube_all_tinted")), Optional.empty(), class_4945.field_23010)
				.method_25852(prefix("block/petal_block"), new class_4944().method_25868(class_4945.field_23010, prefix("block/petal_block")), this.modelOutput);
		takeAll(remainingBlocks, b -> b instanceof PetalBlock).forEach(b -> singleVariantBlockState(b, petalBlockModel));

		takeAll(remainingBlocks, b -> b instanceof BotaniaGrassBlock).forEach(b -> {
			var model = class_4943.field_22977.method_25846(b, new class_4944()
					.method_25868(class_4945.field_23018, method_25866(b, "_side"))
					.method_25868(class_4945.field_23014, method_25860(class_2246.field_10566))
					.method_25868(class_4945.field_23015, method_25866(b, "_top")),
					this.modelOutput
			);
			this.blockstates.add(class_4925.method_25771(b, BlockModelGeneratorsAccessor.createRotatedVariants(model)));
		});

		takeAll(remainingBlocks, b -> b instanceof RedStringBlock).forEach(this::redStringBlock);

		takeAll(remainingBlocks, b -> b instanceof BotaniaDoubleFlowerBlock).forEach(b -> {
			var bottom = class_4943.field_22921.method_25846(b, class_4944.method_25877(b), this.modelOutput);
			var top = class_4943.field_22921.method_25852(method_25843(b, "_top"), class_4944.method_25880(method_25866(b, "_top")), this.modelOutput);
			this.blockstates.add(
					class_4925.method_25769(b)
							.method_25775(class_4926.method_25783(class_2521.field_10929)
									.method_25793(class_2756.field_12607, class_4935.method_25824().method_25828(class_4936.field_22887, bottom))
									.method_25793(class_2756.field_12609, class_4935.method_25824().method_25828(class_4936.field_22887, top))
							)
			);
		});

		var mountainTextures = new class_2960[] { method_25860(biomeStoneMountain), method_25866(biomeStoneMountain, "_1") };
		var mountainModels = new class_2960[] { method_25842(biomeStoneMountain), method_25843(biomeStoneMountain, "_1") };
		var mountainWeights = new Integer[] { 5, 1 };
		rotatedMirroredWithVariants(remainingBlocks, biomeStoneMountain, mountainTextures, mountainWeights);
		stairsBlockWithVariants(remainingBlocks, biomeStoneMountainStairs, mountainTextures, mountainTextures, mountainTextures, mountainWeights);
		slabBlockWithVariants(remainingBlocks, biomeStoneMountainSlab, mountainModels, mountainTextures, mountainTextures, mountainTextures, mountainWeights);
		wallBlockWithVariants(remainingBlocks, biomeStoneMountainWall, mountainTextures, mountainWeights);

		var mountainBrickTextures = new class_2960[] {
				method_25860(biomeBrickMountain),
				method_25866(biomeBrickMountain, "_1"),
				method_25866(biomeBrickMountain, "_2"),
				method_25866(biomeBrickMountain, "_3"),
				method_25866(biomeBrickMountain, "_4"),
				method_25866(biomeBrickMountain, "_5")
		};
		var mountainBrickModels = new class_2960[] {
				method_25842(biomeBrickMountain),
				method_25843(biomeBrickMountain, "_1"),
				method_25843(biomeBrickMountain, "_2"),
				method_25843(biomeBrickMountain, "_3"),
				method_25843(biomeBrickMountain, "_4"),
				method_25843(biomeBrickMountain, "_5"),
		};
		cubeAllWithVariants(remainingBlocks, biomeBrickMountain, mountainBrickTextures);
		stairsBlockWithVariants(remainingBlocks, biomeBrickMountainStairs, mountainBrickTextures, mountainBrickTextures, mountainBrickTextures);
		slabBlockWithVariants(remainingBlocks, biomeBrickMountainSlab, mountainBrickModels, mountainBrickTextures, mountainBrickTextures, mountainBrickTextures);
		wallBlockWithVariants(remainingBlocks, biomeBrickMountainWall, mountainBrickTextures);

		var taigaTextures = new class_2960[] { method_25860(biomeStoneTaiga), method_25866(biomeStoneTaiga, "_1") };
		var taigaModels = new class_2960[] { method_25842(biomeStoneTaiga), method_25843(biomeStoneTaiga, "_1") };
		rotatedMirroredWithVariants(remainingBlocks, biomeStoneTaiga, taigaTextures);
		stairsBlockWithVariants(remainingBlocks, biomeStoneTaigaStairs, taigaTextures, taigaTextures, taigaTextures);
		slabBlockWithVariants(remainingBlocks, biomeStoneTaigaSlab, taigaModels, taigaTextures, taigaTextures, taigaTextures);
		wallBlockWithVariants(remainingBlocks, biomeStoneTaigaWall, taigaTextures);

		var plainsBrickSide = method_25860(biomeBrickPlains);
		var plainsBrickTop = method_25866(biomeBrickPlains, "_top");
		pillarAlt(remainingBlocks, biomeBrickPlains, plainsBrickTop, plainsBrickSide);
		stairsBlock(remainingBlocks, biomeBrickPlainsStairs, plainsBrickSide, plainsBrickTop, plainsBrickTop);
		slabBlock(remainingBlocks, biomeBrickPlainsSlab, method_25842(biomeBrickPlains), plainsBrickSide, plainsBrickTop, plainsBrickTop);
		wallBlock(remainingBlocks, biomeBrickPlainsWall, plainsBrickSide, plainsBrickTop, plainsBrickTop);

		var forestBrickTextures = new class_2960[] { method_25860(biomeBrickForest), method_25866(biomeBrickForest, "_1") };
		var forestBrickModels = new class_2960[] { method_25842(biomeBrickForest), method_25843(biomeBrickForest, "_1") };
		var forestBrickWeights = new Integer[] { 2, 1 };
		cubeAllWithVariants(remainingBlocks, biomeBrickForest, forestBrickTextures, forestBrickWeights);
		stairsBlockWithVariants(remainingBlocks, biomeBrickForestStairs, forestBrickTextures, forestBrickTextures, forestBrickTextures, forestBrickWeights);
		slabBlockWithVariants(remainingBlocks, biomeBrickForestSlab, forestBrickModels, forestBrickTextures, forestBrickTextures, forestBrickTextures, forestBrickWeights);
		wallBlockWithVariants(remainingBlocks, biomeBrickForestWall, forestBrickTextures, forestBrickWeights);

		var fungalBrickTextures = new class_2960[] { method_25860(biomeBrickFungal), method_25866(biomeBrickFungal, "_1") };
		var fungalBrickModels = new class_2960[] { method_25842(biomeBrickFungal), method_25843(biomeBrickFungal, "_1") };
		cubeAllWithVariants(remainingBlocks, biomeBrickFungal, fungalBrickTextures);
		stairsBlockWithVariants(remainingBlocks, biomeBrickFungalStairs, fungalBrickTextures, fungalBrickTextures, fungalBrickTextures);
		slabBlockWithVariants(remainingBlocks, biomeBrickFungalSlab, fungalBrickModels, fungalBrickTextures, fungalBrickTextures, fungalBrickTextures);
		wallBlockWithVariants(remainingBlocks, biomeBrickFungalWall, fungalBrickTextures);

		var swampBrickTopTextures = new class_2960[] {
				method_25866(biomeBrickSwamp, "_top"),
				method_25866(biomeBrickSwamp, "_top_1")
		};
		var swampBrickBottomTextures = new class_2960[] {
				method_25866(biomeBrickSwamp, "_bottom"),
				method_25866(biomeBrickSwamp, "_bottom")
		};
		var swampBrickSideTextures = new class_2960[] {
				method_25860(biomeBrickSwamp),
				method_25860(biomeBrickSwamp)
		};
		var swampBrickModels = new class_2960[] {
				method_25842(biomeBrickSwamp),
				method_25843(biomeBrickSwamp, "_1")
		};
		directionalPillarWithVariants(remainingBlocks, biomeBrickSwamp, swampBrickTopTextures, swampBrickBottomTextures, swampBrickSideTextures);
		stairsBlockWithVariants(remainingBlocks, biomeBrickSwampStairs, swampBrickSideTextures, swampBrickBottomTextures, swampBrickTopTextures);
		slabBlockWithVariants(remainingBlocks, biomeBrickSwampSlab, swampBrickModels, swampBrickSideTextures, swampBrickBottomTextures, swampBrickTopTextures);
		wallBlockWithVariants(remainingBlocks, biomeBrickSwampWall, swampBrickSideTextures, swampBrickBottomTextures, swampBrickTopTextures);

		var swampChiseledBrickTopTextures = new class_2960[] {
				method_25866(biomeChiseledBrickSwamp, "_top"),
				method_25866(biomeChiseledBrickSwamp, "_top_1")
		};
		var swampChiseledBrickBottomTextures = new class_2960[] {
				method_25866(biomeChiseledBrickSwamp, "_bottom"),
				method_25866(biomeChiseledBrickSwamp, "_bottom")
		};
		var swampChiseledBrickSideTextures = new class_2960[] {
				method_25860(biomeChiseledBrickSwamp),
				method_25860(biomeChiseledBrickSwamp)
		};
		directionalPillarWithVariants(remainingBlocks, biomeChiseledBrickSwamp, swampChiseledBrickTopTextures, swampChiseledBrickBottomTextures, swampChiseledBrickSideTextures);

		var swampCobblestoneTextures = new class_2960[] { method_25860(biomeCobblestoneSwamp), method_25866(biomeCobblestoneSwamp, "_1") };
		var swampCobblestoneModels = new class_2960[] { method_25842(biomeCobblestoneSwamp), method_25843(biomeCobblestoneSwamp, "_1") };
		cubeAllWithVariants(remainingBlocks, biomeCobblestoneSwamp, swampCobblestoneTextures);
		stairsBlockWithVariants(remainingBlocks, biomeCobblestoneSwampStairs, swampCobblestoneTextures, swampCobblestoneTextures, swampCobblestoneTextures);
		slabBlockWithVariants(remainingBlocks, biomeCobblestoneSwampSlab, swampCobblestoneModels, swampCobblestoneTextures, swampCobblestoneTextures, swampCobblestoneTextures);
		wallBlockWithVariants(remainingBlocks, biomeCobblestoneSwampWall, swampCobblestoneTextures);

		var mesaBrick = method_25860(biomeBrickMesa);
		var mesaBrickMirrored = method_25866(biomeBrickMesa, "_mirrored");
		var mesaBrickModel = checkeredBlockWithBlockstate(remainingBlocks, biomeBrickMesa, mesaBrick, mesaBrickMirrored);
		checkeredSlabBlock(remainingBlocks, biomeBrickMesaSlab, mesaBrickModel, mesaBrick, mesaBrickMirrored);
		checkeredStairsBlock(remainingBlocks, biomeBrickMesaStairs, mesaBrick, mesaBrickMirrored);
		checkeredWallBlock(remainingBlocks, biomeBrickMesaWall, mesaBrick, mesaBrickMirrored);

		var mesaChiseledBrickSide = method_25860(biomeChiseledBrickMesa);
		var mesaChiseledBrickTop = method_25866(biomeChiseledBrickMesa, "_top");
		pillarAlt(remainingBlocks, biomeChiseledBrickMesa, mesaChiseledBrickTop, mesaChiseledBrickSide);

		// Remaining slabs, stairs, walls are handled automatically.
		for (class_2248 stone : new class_2248[] { biomeStoneDesert, biomeStoneForest, biomeStoneFungal, biomeStoneMesa, biomeStonePlains, biomeStoneSwamp }) {
			rotatedMirrored(remainingBlocks, stone, method_25860(stone));
		}

		for (String variant : new String[] { "dark", "mana", "blaze", "lavender", "red", "elf", "sunny" }) {
			class_2960 quartzId = prefix(variant + "_quartz");
			class_2248 quartz = class_7923.field_41175.method_10223(quartzId);
			singleVariantBlockState(quartz,
					class_4943.field_22977.method_25846(quartz, class_4944.method_25898(quartz), this.modelOutput));

			class_2960 pillarId = prefix(variant + "_quartz_pillar");
			class_2248 pillar = class_7923.field_41175.method_10223(pillarId);
			var pillarModel = class_4943.field_22974.method_25846(pillar,
					class_4944.method_25870(method_25866(pillar, "_side"), method_25866(pillar, "_end")),
					this.modelOutput);
			this.blockstates.add(BlockModelGeneratorsAccessor.createAxisAlignedPillarBlock(pillar, pillarModel));

			class_2960 chiseledId = prefix("chiseled_" + variant + "_quartz");
			class_2248 chiseled = class_7923.field_41175.method_10223(chiseledId);
			singleVariantBlockState(chiseled,
					class_4943.field_22974.method_25846(chiseled, new class_4944()
							.method_25868(class_4945.field_23018, method_25866(chiseled, "_side"))
							.method_25868(class_4945.field_23013, method_25866(chiseled, "_end")), this.modelOutput));

			remainingBlocks.remove(quartz);
			remainingBlocks.remove(pillar);
			remainingBlocks.remove(chiseled);
		}

		takeAll(remainingBlocks, b -> b instanceof BuriedPetalBlock).forEach(b -> {
			class_1767 color = ((BuriedPetalBlock) b).color;
			class_2960 wool = new class_2960("block/" + color.method_15434() + "_wool");
			particleOnly(remainingBlocks, b, wool);
		});

		var apothecaryTemplate = new class_4942(Optional.of(prefix("block/shapes/petal_apothecary")), Optional.empty(),
				class_4945.field_23018, class_4945.field_23015, class_4945.field_23014);
		takeAll(remainingBlocks, b -> b instanceof PetalApothecaryBlock).forEach(b -> singleVariantBlockState(b,
				apothecaryTemplate.method_25846(b, new class_4944()
						.method_25868(class_4945.field_23018, method_25866(b, "_side"))
						.method_25868(class_4945.field_23015, method_25866(b, "_top"))
						.method_25868(class_4945.field_23014, method_25866(b, "_bottom")), this.modelOutput))
		);

		takeAll(remainingBlocks, b -> b instanceof FloatingFlowerBlock).forEach(b -> {
			// Models generated by FloatingFlowerModelProvider
			singleVariantBlockState(b, method_25842(b));
		});

		takeAll(remainingBlocks, b -> b instanceof BotaniaPaneBlock).forEach(b -> {
			String name = class_7923.field_41175.method_10221(b).method_12832();
			var mapping = new class_4944()
					.method_25868(class_4945.field_23032, method_25860(b))
					.method_25868(class_4945.field_23031, prefix("block/" + name.substring(0, name.length() - "_pane".length())));
			class_2960 postModel = class_4943.field_22953.method_25846(b, mapping, this.modelOutput);
			class_2960 sideModel = class_4943.field_22954.method_25846(b, mapping, this.modelOutput);
			class_2960 sideAltModel = class_4943.field_22955.method_25846(b, mapping, this.modelOutput);
			class_2960 noSideModel = class_4943.field_22951.method_25846(b, mapping, this.modelOutput);
			class_2960 noSideAltModel = class_4943.field_22952.method_25846(b, mapping, this.modelOutput);

			// [VanillaCopy] BlockModelGenerator glass panes
			this.blockstates.add(class_4922.method_25758(b)
					.method_25763(class_4935.method_25824().method_25828(class_4936.field_22887, postModel))
					.method_25760(class_4918.method_25744().method_25751(class_2741.field_12489, true), class_4935.method_25824().method_25828(class_4936.field_22887, sideModel))
					.method_25760(class_4918.method_25744().method_25751(class_2741.field_12487, true), class_4935.method_25824().method_25828(class_4936.field_22887, sideModel).method_25828(class_4936.field_22886, class_4936.class_4937.field_22891))
					.method_25760(class_4918.method_25744().method_25751(class_2741.field_12540, true), class_4935.method_25824().method_25828(class_4936.field_22887, sideAltModel))
					.method_25760(class_4918.method_25744().method_25751(class_2741.field_12527, true), class_4935.method_25824().method_25828(class_4936.field_22887, sideAltModel).method_25828(class_4936.field_22886, class_4936.class_4937.field_22891))
					.method_25760(class_4918.method_25744().method_25751(class_2741.field_12489, false), class_4935.method_25824().method_25828(class_4936.field_22887, noSideModel))
					.method_25760(class_4918.method_25744().method_25751(class_2741.field_12487, false), class_4935.method_25824().method_25828(class_4936.field_22887, noSideAltModel))
					.method_25760(class_4918.method_25744().method_25751(class_2741.field_12540, false), class_4935.method_25824().method_25828(class_4936.field_22887, noSideAltModel).method_25828(class_4936.field_22886, class_4936.class_4937.field_22891))
					.method_25760(class_4918.method_25744().method_25751(class_2741.field_12527, false), class_4935.method_25824().method_25828(class_4936.field_22887, noSideModel).method_25828(class_4936.field_22886, class_4936.class_4937.field_22893)));
		});

		takeAll(remainingBlocks, b -> b instanceof class_2510).forEach(b -> {
			String name = class_7923.field_41175.method_10221(b).method_12832();
			String baseName = name.substring(0, name.length() - LibBlockNames.STAIR_SUFFIX.length());
			boolean quartz = name.contains("quartz");
			if (quartz) {
				class_2960 side = prefix("block/" + baseName + "_side");
				class_2960 bottom = prefix("block/" + baseName + "_bottom");
				class_2960 top = prefix("block/" + baseName + "_top");
				stairsBlock(new HashSet<>(), b, side, bottom, top);
			} else {
				var tex = prefix("block/" + baseName);
				stairsBlock(new HashSet<>(), b, tex, tex, tex);
			}
		});

		takeAll(remainingBlocks, b -> b instanceof class_2482).forEach(slabBlock -> {
			String name = class_7923.field_41175.method_10221(slabBlock).method_12832();
			String baseName = name.substring(0, name.length() - LibBlockNames.SLAB_SUFFIX.length());
			class_2248 base = class_7923.field_41175.method_10223(prefix(baseName));
			boolean quartz = name.contains("quartz");
			if (quartz) {
				var side = method_25866(base, "_side");
				var bottom = method_25866(base, "_bottom");
				var top = method_25866(base, "_top");
				var doubleModel = method_25842(base);
				slabBlock(new HashSet<>(), slabBlock, doubleModel, side, bottom, top);
			} else {
				var baseTex = method_25860(base);
				var doubleModel = method_25842(base);
				slabBlock(new HashSet<>(), slabBlock, doubleModel, baseTex, baseTex, baseTex);
			}
		});

		takeAll(remainingBlocks, b -> b instanceof class_2544).forEach(wallBlock -> {
			String name = class_7923.field_41175.method_10221(wallBlock).method_12832();
			String baseName = name.substring(0, name.length() - LibBlockNames.WALL_SUFFIX.length());
			class_2248 base = class_7923.field_41175.method_10223(prefix(baseName));
			var baseTexture = method_25860(base);
			wallBlock(new HashSet<>(), wallBlock, baseTexture);
		});

		remainingBlocks.forEach(this::cubeAllNoRemove);
	}

	protected void particleOnly(Set<class_2248> blocks, class_2248 b, class_2960 particle) {
		singleVariantBlockState(b, class_4943.field_22908.method_25846(b, class_4944.method_25891(particle), this.modelOutput));
		blocks.remove(b);
	}

	protected void manualModel(Set<class_2248> blocks, class_2248 b) {
		singleVariantBlockState(b, method_25842(b));
		blocks.remove(b);
	}

	protected void stairsBlock(Set<class_2248> blocks, class_2248 block, class_2960 sideTex, class_2960 bottomTex, class_2960 topTex) {
		stairsBlockWithVariants(blocks, block, new class_2960[] { sideTex }, new class_2960[] { bottomTex }, new class_2960[] { topTex });
	}

	protected void checkeredStairsBlock(Set<class_2248> blocks, class_2248 block, class_2960 texture, class_2960 mirroredTexture) {
		BiFunction<String, Optional<String>, class_4942> checkeredTemplate = (model, suffix) -> new class_4942(Optional.of(prefix("block/shapes/" + model)), suffix, class_4945.field_23018, class_4945.field_23019);
		class_4944 checkeredMapping = new class_4944().method_25868(class_4945.field_23018, texture).method_25868(class_4945.field_23019, mirroredTexture);

		var checkeredStairsModel = checkeredTemplate.apply("stairs_checkered", Optional.empty()).method_25846(biomeBrickMesaStairs, checkeredMapping, this.modelOutput);
		var checkeredStairsModelRot90 = checkeredTemplate.apply("stairs_checkered_90deg", Optional.of("_90deg")).method_25846(biomeBrickMesaStairs, checkeredMapping, this.modelOutput);
		var checkeredStairsOuterModel = checkeredTemplate.apply("stairs_outer_checkered", Optional.of("_outer")).method_25846(biomeBrickMesaStairs, checkeredMapping, this.modelOutput);
		var checkeredStairsOuterModelRot90 = checkeredTemplate.apply("stairs_outer_checkered_90deg", Optional.of("_outer_90deg")).method_25846(biomeBrickMesaStairs, checkeredMapping, this.modelOutput);
		var checkeredStairsInnerModel = checkeredTemplate.apply("stairs_inner_checkered", Optional.of("_inner")).method_25846(biomeBrickMesaStairs, checkeredMapping, this.modelOutput);
		var checkeredStairsInnerModelRot90 = checkeredTemplate.apply("stairs_inner_checkered_90deg", Optional.of("_inner_90deg")).method_25846(biomeBrickMesaStairs, checkeredMapping, this.modelOutput);

		stairsBlockWithModels(blocks, block, checkeredStairsInnerModel, checkeredStairsInnerModelRot90, checkeredStairsModel, checkeredStairsModelRot90, checkeredStairsOuterModel, checkeredStairsOuterModelRot90);
	}

	protected void stairsBlockWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] sideTextures, class_2960[] bottomTextures, class_2960[] topTextures) {
		var weights = new Integer[sideTextures.length];
		Arrays.fill(weights, 1);
		stairsBlockWithVariants(blocks, block, sideTextures, bottomTextures, topTextures, weights);
	}

	protected void stairsBlockWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] sideTextures, class_2960[] bottomTextures, class_2960[] topTextures, Integer[] weights) {
		int length = sideTextures.length;
		if (length != topTextures.length || length != bottomTextures.length || length != weights.length) {
			throw new IllegalArgumentException("Arrays must have equal length");
		}
		class_2960[] innerModels = new class_2960[length];
		class_2960[] straightModels = new class_2960[length];
		class_2960[] outerModels = new class_2960[length];
		for (int i = 0; i < length; i++) {
			String suffix = i == 0 ? "" : "_" + i;
			var mapping = new class_4944()
					.method_25868(class_4945.field_23018, sideTextures[i])
					.method_25868(class_4945.field_23014, bottomTextures[i])
					.method_25868(class_4945.field_23015, topTextures[i]);
			class_2960 modelIdInner = method_25843(block, "_inner" + suffix);
			class_2960 modelIdStraight = method_25843(block, suffix);
			class_2960 modelIdOuter = method_25843(block, "_outer" + suffix);
			innerModels[i] = class_4943.field_22913.method_25852(modelIdInner, mapping, this.modelOutput);
			straightModels[i] = class_4943.field_22912.method_25852(modelIdStraight, mapping, this.modelOutput);
			outerModels[i] = class_4943.field_22914.method_25852(modelIdOuter, mapping, this.modelOutput);
		}
		stairsBlockWithModels(blocks, block, innerModels, straightModels, outerModels, weights);
	}

	protected void stairsBlockWithModels(Set<class_2248> blocks, class_2248 block, class_2960[] innerModels, class_2960[] straightModels, class_2960[] outerModels, Integer[] weights) {
		stairsBlockWithModels(blocks, block, innerModels, straightModels, outerModels, weights, true);
	}

	protected void stairsBlockWithModels(Set<class_2248> blocks, class_2248 block, class_2960 innerModel, class_2960 innerModelRot90, class_2960 straightModel, class_2960 straightModelRot90, class_2960 outerModel, class_2960 outerModelRot90) {
		stairsBlockWithModels(blocks, block, new class_2960[] { innerModel }, new class_2960[] { innerModelRot90 }, new class_2960[] { straightModel }, new class_2960[] { straightModelRot90 }, new class_2960[] { outerModel }, new class_2960[] { outerModelRot90 }, new Integer[] { 1 }, true);
	}

	protected void stairsBlockWithModels(Set<class_2248> blocks, class_2248 block, class_2960[] innerModels, class_2960[] straightModels, class_2960[] outerModels, Integer[] weights, Boolean uvlock) {
		stairsBlockWithModels(blocks, block, innerModels, innerModels, straightModels, straightModels, outerModels, outerModels, weights, uvlock);
	}

	protected void stairsBlockWithModels(Set<class_2248> blocks, class_2248 block, class_2960[] innerModels, class_2960[] innerModelsRot90, class_2960[] straightModels, class_2960[] straightModelsRot90, class_2960[] outerModels, class_2960[] outerModelsRot90, Integer[] weights, Boolean uvlock) {
		int length = innerModels.length;
		if (length != straightModels.length || length != outerModels.length || length != weights.length) {
			throw new IllegalArgumentException("Arrays must have equal length");
		}
		var propertyDispatch = class_4926.method_25785(
				class_2741.field_12481,
				class_2741.field_12518,
				class_2741.field_12503
		);
		for (class_2350 direction : class_2350.class_2353.field_11062) {
			for (class_2760 half : class_2760.values()) {
				for (class_2778 stairsShape : class_2778.values()) {
					// Stair blockstates are super weird. If it's left and bottom, you need to rotate it 90deg ccw compared to
					// usual, and if it's right and top, you need to rotate it 90deg cw. This is the cleanest way I could think
					// of to do that.

					// Additionally, we're using an alternate model for everything that's rotated 90/270 degrees to be able to
					// have a consistent "checkered" texture for some stairs. Normal stairs just provide the same model twice
					// which makes no impact in the generated blockstate.
					boolean isLeft = stairsShape == class_2778.field_12712 || stairsShape == class_2778.field_12708;
					boolean isRight = stairsShape == class_2778.field_12713 || stairsShape == class_2778.field_12709;
					int rotationOffset = isLeft && half == class_2760.field_12617 ? -1 : isRight && half == class_2760.field_12619 ? 1 : 0;

					class_4936.class_4937[] rotations = class_4936.class_4937.values();
					class_4936.class_4937 yRot = switch (direction) {
						case field_11034 -> rotations[(4 + rotationOffset) % 4];
						case field_11039 -> rotations[(2 + rotationOffset) % 4];
						case field_11035 -> rotations[(1 + rotationOffset) % 4];
						case field_11043 -> rotations[(3 + rotationOffset) % 4];
						default -> throw new IllegalStateException();
					};
					class_4936.class_4937 xRot = switch (half) {
						case field_12617 -> class_4936.class_4937.field_22890;
						case field_12619 -> class_4936.class_4937.field_22892;
					};
					boolean rotatedModel = yRot == class_4936.class_4937.field_22891 || yRot == class_4936.class_4937.field_22893;
					class_2960[] models = switch (stairsShape) {
						case field_12710 -> rotatedModel ? straightModelsRot90 : straightModels;
						case field_12709, field_12708 -> rotatedModel ? outerModelsRot90 : outerModels;
						case field_12713, field_12712 -> rotatedModel ? innerModelsRot90 : innerModels;
					};
					var indices = IntStream.range(0, length).boxed();
					propertyDispatch.method_25807(direction, half, stairsShape, indices.map(i -> maybeUVLock(uvlock, maybeWeight(weights[i], maybeYRot(yRot, maybeXRot(xRot, class_4935.method_25824()
							.method_25828(class_4936.field_22887, models[i])
					))))
					).toList());
				}
			}
		}
		this.blockstates.add(class_4925.method_25769(block).method_25775(propertyDispatch));
		blocks.remove(block);
	}

	protected void slabBlock(Set<class_2248> blocks, class_2248 block, class_2960 doubleModel, class_2960 side, class_2960 bottom, class_2960 top) {
		slabBlockWithVariants(blocks, block, new class_2960[] { doubleModel }, new class_2960[] { side }, new class_2960[] { bottom }, new class_2960[] { top });
	}

	protected void checkeredSlabBlock(Set<class_2248> blocks, class_2248 block, class_2960 doubleModel, class_2960 texture, class_2960 mirroredTexture) {
		BiFunction<String, Optional<String>, class_4942> checkeredTemplate = (model, suffix) -> new class_4942(Optional.of(prefix("block/shapes/" + model)), suffix, class_4945.field_23018, class_4945.field_23019);
		class_4944 checkeredMapping = new class_4944().method_25868(class_4945.field_23018, texture).method_25868(class_4945.field_23019, mirroredTexture);

		var slabModel = checkeredTemplate.apply("slab_checkered", Optional.empty()).method_25846(biomeBrickMesaSlab, checkeredMapping, this.modelOutput);
		var slabTopModel = checkeredTemplate.apply("slab_top_checkered", Optional.of("_top")).method_25846(biomeBrickMesaSlab, checkeredMapping, this.modelOutput);
		slabBlockWithModels(blocks, block, slabModel, slabTopModel, doubleModel);
	}

	protected void slabBlockWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] doubleModels, class_2960[] sideTextures, class_2960[] bottomTextures, class_2960[] topTextures) {
		var weights = new Integer[sideTextures.length];
		Arrays.fill(weights, 1);
		slabBlockWithVariants(blocks, block, doubleModels, sideTextures, bottomTextures, topTextures, weights);
	}

	protected void slabBlockWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] doubleModels, class_2960[] sideTextures, class_2960[] bottomTextures, class_2960[] topTextures, Integer[] weights) {
		int length = sideTextures.length;
		if (length != topTextures.length || length != bottomTextures.length || length != weights.length) {
			throw new IllegalArgumentException("Arrays must have equal length");
		}
		class_2960[] bottomModels = new class_2960[length];
		class_2960[] topModels = new class_2960[length];
		for (int i = 0; i < length; i++) {
			String suffix = i == 0 ? "" : "_" + i;
			var mapping = new class_4944()
					.method_25868(class_4945.field_23018, sideTextures[i])
					.method_25868(class_4945.field_23014, bottomTextures[i])
					.method_25868(class_4945.field_23015, topTextures[i]);
			class_2960 modelIdBottom = method_25843(block, suffix);
			class_2960 modelIdTop = method_25843(block, "_top" + suffix);
			bottomModels[i] = class_4943.field_22909.method_25852(modelIdBottom, mapping, this.modelOutput);
			topModels[i] = class_4943.field_22910.method_25852(modelIdTop, mapping, this.modelOutput);
		}
		slabBlockWithModels(blocks, block, bottomModels, topModels, doubleModels, weights);
	}

	protected void slabBlockWithModels(Set<class_2248> blocks, class_2248 block, class_2960 bottomModel, class_2960 topModel, class_2960 doubleModel) {
		slabBlockWithModels(blocks, block, new class_2960[] { bottomModel }, new class_2960[] { topModel }, new class_2960[] { doubleModel }, new Integer[] { 1 });
	}

	protected void slabBlockWithModels(Set<class_2248> blocks, class_2248 block, class_2960[] bottomModels, class_2960[] topModels, class_2960[] doubleModels, Integer[] weights) {
		int length = doubleModels.length;
		if (length != topModels.length || length != bottomModels.length || length != weights.length) {
			throw new IllegalArgumentException("Arrays must have equal length");
		}
		var indicesBottom = IntStream.range(0, length).boxed();
		var indicesTop = IntStream.range(0, length).boxed();
		var indicesDouble = IntStream.range(0, length).boxed();
		this.blockstates.add(class_4925.method_25769(block).method_25775(
				class_4926.method_25783(class_2741.field_12485)
						.method_25794(class_2771.field_12681, indicesBottom.map(i -> maybeWeight(weights[i], class_4935.method_25824().method_25828(class_4936.field_22887, bottomModels[i]))).toList())
						.method_25794(class_2771.field_12679, indicesTop.map(i -> maybeWeight(weights[i], class_4935.method_25824().method_25828(class_4936.field_22887, topModels[i]))).toList())
						.method_25794(class_2771.field_12682, indicesDouble.map(i -> maybeWeight(weights[i], class_4935.method_25824().method_25828(class_4936.field_22887, doubleModels[i]))).toList())
		));
		blocks.remove(block);
	}

	protected void wallBlock(Set<class_2248> blocks, class_2248 block, class_2960 texture) {
		wallBlock(blocks, block, texture, texture, texture);
	}

	protected void wallBlock(Set<class_2248> blocks, class_2248 block, class_2960 sideTexture, class_2960 bottomTexture, class_2960 topTexture) {
		wallBlockWithVariants(blocks, block, new class_2960[] { sideTexture }, new class_2960[] { bottomTexture }, new class_2960[] { topTexture });
	}

	protected void checkeredWallBlock(Set<class_2248> blocks, class_2248 block, class_2960 texture, class_2960 mirroredTexture) {
		BiFunction<String, Optional<String>, class_4942> checkeredTemplate = (model, suffix) -> new class_4942(Optional.of(prefix("block/shapes/" + model)), suffix, class_4945.field_23018, class_4945.field_23019);
		class_4944 checkeredMapping = new class_4944().method_25868(class_4945.field_23018, texture).method_25868(class_4945.field_23019, mirroredTexture);

		var checkeredWallPostModel = checkeredTemplate.apply("wall_post_checkered", Optional.of("_post")).method_25846(biomeBrickMesaWall, checkeredMapping, this.modelOutput);
		var checkeredWallSideModel = checkeredTemplate.apply("wall_side_checkered", Optional.of("_side")).method_25846(biomeBrickMesaWall, checkeredMapping, this.modelOutput);
		var checkeredWallSideModelRot90 = checkeredTemplate.apply("wall_side_checkered_90deg", Optional.of("_side_90deg")).method_25846(biomeBrickMesaWall, checkeredMapping, this.modelOutput);
		var checkeredWallSideTallModel = checkeredTemplate.apply("wall_side_tall_checkered", Optional.of("_side_tall")).method_25846(biomeBrickMesaWall, checkeredMapping, this.modelOutput);
		var checkeredWallSideTallModelRot90 = checkeredTemplate.apply("wall_side_tall_checkered_90deg", Optional.of("_side_tall_90deg")).method_25846(biomeBrickMesaWall, checkeredMapping, this.modelOutput);

		wallBlockWithModels(blocks, block, checkeredWallPostModel, checkeredWallSideModel, checkeredWallSideModelRot90, checkeredWallSideTallModel, checkeredWallSideTallModelRot90);
	}

	protected void wallBlockWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] textures) {
		wallBlockWithVariants(blocks, block, textures, textures, textures);
	}

	protected void wallBlockWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] textures, Integer[] weights) {
		wallBlockWithVariants(blocks, block, textures, textures, textures, weights);
	}

	protected void wallBlockWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] sideTextures, class_2960[] bottomTextures, class_2960[] topTextures) {
		var weights = new Integer[sideTextures.length];
		Arrays.fill(weights, 1);
		wallBlockWithVariants(blocks, block, sideTextures, bottomTextures, topTextures, weights);
	}

	protected void wallBlockWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] sideTextures, class_2960[] bottomTextures, class_2960[] topTextures, Integer[] weights) {
		int length = sideTextures.length;
		if (length != bottomTextures.length && length != topTextures.length && length != weights.length) {
			throw new IllegalArgumentException("Arrays must have equal length");
		}
		class_2960[] postModels = new class_2960[length];
		class_2960[] lowModels = new class_2960[length];
		class_2960[] tallModels = new class_2960[length];
		for (int i = 0; i < length; i++) {
			String suffix = i == 0 ? "" : "_" + i;
			var mapping = new class_4944()
					.method_25868(class_4945.field_23027, sideTextures[i])
					.method_25868(class_4945.field_23014, bottomTextures[i])
					.method_25868(class_4945.field_23015, topTextures[i]);
			class_2960 modelIdPost = method_25843(block, "_post" + suffix);
			class_2960 modelIdLow = method_25843(block, "_side" + suffix);
			class_2960 modelIdTall = method_25843(block, "_side_tall" + suffix);
			var postTemplate = new class_4942(Optional.of(prefix("block/shapes/wall_post")), Optional.of("_post"),
					class_4945.field_23027, class_4945.field_23014, class_4945.field_23015);
			var sideTemplate = new class_4942(Optional.of(prefix("block/shapes/wall_side")), Optional.of("_side"),
					class_4945.field_23027, class_4945.field_23014, class_4945.field_23015);
			var sideTallTemplate = new class_4942(Optional.of(prefix("block/shapes/wall_side_tall")), Optional.of("_side_tall"),
					class_4945.field_23027, class_4945.field_23014, class_4945.field_23015);
			postModels[i] = postTemplate.method_25852(modelIdPost, mapping, this.modelOutput);
			lowModels[i] = sideTemplate.method_25852(modelIdLow, mapping, this.modelOutput);
			tallModels[i] = sideTallTemplate.method_25852(modelIdTall, mapping, this.modelOutput);
		}
		wallBlockWithModels(blocks, block, postModels, lowModels, tallModels, weights);
	}

	protected void wallBlockWithModels(Set<class_2248> blocks, class_2248 block, class_2960[] postModels, class_2960[] lowModels, class_2960[] tallModels, Integer[] weights) {
		wallBlockWithModels(blocks, block, postModels, lowModels, tallModels, weights, true);
	}

	protected void wallBlockWithModels(Set<class_2248> blocks, class_2248 block, class_2960 postModel, class_2960 lowModel, class_2960 lowModelRot90, class_2960 tallModel, class_2960 tallodelRot90) {
		wallBlockWithModels(blocks, block, new class_2960[] { postModel }, new class_2960[] { lowModel }, new class_2960[] { lowModelRot90 }, new class_2960[] { tallModel }, new class_2960[] { tallodelRot90 }, new Integer[] { 1 }, true);
	}

	protected void wallBlockWithModels(Set<class_2248> blocks, class_2248 block, class_2960[] postModels, class_2960[] lowModels, class_2960[] tallModels, Integer[] weights, Boolean uvlock) {
		wallBlockWithModels(blocks, block, postModels, lowModels, lowModels, tallModels, tallModels, weights, uvlock);
	}

	protected void wallBlockWithModels(Set<class_2248> blocks, class_2248 block, class_2960[] postModels, class_2960[] lowModels, class_2960[] lowModelsRot90, class_2960[] tallModels, class_2960[] tallodelsRot90, Integer[] weights, Boolean uvlock) {
		int length = postModels.length;
		if (length != lowModels.length || length != tallModels.length || length != weights.length) {
			throw new IllegalArgumentException("Arrays must have equal length");
		}
		var multiPartGenerator = class_4922.method_25758(block);
		var indicesPost = IntStream.range(0, length).boxed();
		multiPartGenerator.method_25762(class_4918.method_25744().method_25751(class_2741.field_12519, true),
				indicesPost.map(i -> maybeWeight(weights[i], class_4935.method_25824().method_25828(class_4936.field_22887, postModels[i]))).toArray(class_4935[]::new));
		var wallSides = List.of(class_2741.field_22174, class_2741.field_22177, class_2741.field_22176, class_2741.field_22175);

		// We're using an alternate model for everything that's rotated 90/270 degrees to be able to
		// have a consistent "checkered" texture for some walls. Normal walls just provide the same model twice
		// which makes no impact in the generated blockstate.
		for (class_2754<class_4778> wallSide : wallSides) {
			class_4936.class_4937 yRot =
					wallSide == class_2741.field_22174 ? class_4936.class_4937.field_22891
							: wallSide == class_2741.field_22177 ? class_4936.class_4937.field_22893
							: wallSide == class_2741.field_22176 ? class_4936.class_4937.field_22892
							: class_4936.class_4937.field_22890;
			boolean rotatedModel = yRot == class_4936.class_4937.field_22891 || yRot == class_4936.class_4937.field_22893;
			var indicesLow = IntStream.range(0, length).boxed();
			var indicesTall = IntStream.range(0, length).boxed();
			multiPartGenerator
					.method_25762(class_4918.method_25744().method_25751(wallSide, class_4778.field_22179), indicesLow.map(i -> maybeUVLock(uvlock, maybeWeight(weights[i], maybeYRot(yRot,
							class_4935.method_25824()
									.method_25828(class_4936.field_22887, rotatedModel ? lowModelsRot90[i] : lowModels[i])
					)))).toArray(class_4935[]::new))
					.method_25762(class_4918.method_25744().method_25751(wallSide, class_4778.field_22180), indicesTall.map(i -> maybeUVLock(uvlock, maybeWeight(weights[i], maybeYRot(yRot,
							class_4935.method_25824()
									.method_25828(class_4936.field_22887, rotatedModel ? tallodelsRot90[i] : tallModels[i])
					)))).toArray(class_4935[]::new));
		}
		this.blockstates.add(multiPartGenerator);
		blocks.remove(block);
	}

	protected void fenceBlock(Set<class_2248> blocks, class_2248 block, class_2960 tex) {
		var mapping = class_4944.method_25869(tex);
		var postModel = class_4943.field_22988.method_25846(block, mapping, this.modelOutput);
		var sideModel = class_4943.field_22989.method_25846(block, mapping, this.modelOutput);
		this.blockstates.add(BlockModelGeneratorsAccessor.makeFenceState(block, postModel, sideModel));
		blocks.remove(block);
	}

	protected void fenceGateBlock(Set<class_2248> blocks, class_2248 block, class_2960 tex) {
		var mapping = class_4944.method_25869(tex);
		var openModel = class_4943.field_22996.method_25846(block, mapping, this.modelOutput);
		var closedModel = class_4943.field_22995.method_25846(block, mapping, this.modelOutput);
		var openWallModel = class_4943.field_22905.method_25846(block, mapping, this.modelOutput);
		var closedWallModel = class_4943.field_22904.method_25846(block, mapping, this.modelOutput);
		this.blockstates.add(BlockModelGeneratorsAccessor.makeFenceGateState(block, openModel, closedModel, openWallModel, closedWallModel, false));
		blocks.remove(block);
	}

	protected void cubeAllNoRemove(class_2248 block) {
		cubeAll(new HashSet<>(), block);
	}

	protected void cubeAll(Set<class_2248> blocks, class_2248 block) {
		class_2960 texture = method_25860(block);
		cubeAllWithVariants(blocks, block, new class_2960[] { texture });
	}

	protected class_2960 checkeredBlockWithBlockstate(Set<class_2248> blocks, class_2248 block, class_2960 texture, class_2960 mirroredTexture) {
		BiFunction<String, Optional<String>, class_4942> checkeredTemplate = (model, suffix) -> new class_4942(Optional.of(prefix("block/shapes/" + model)), suffix, class_4945.field_23018, class_4945.field_23019);
		class_4944 checkeredMapping = new class_4944().method_25868(class_4945.field_23018, texture).method_25868(class_4945.field_23019, mirroredTexture);

		var blockModel = checkeredTemplate.apply("cube_checkered", Optional.empty()).method_25846(block, checkeredMapping, this.modelOutput);
		cubeAllWithModels(blocks, block, new class_2960[] { blockModel }, new Integer[] { 1 });
		return blockModel;
	}

	protected void cubeAllWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] textures) {
		var weights = new Integer[textures.length];
		Arrays.fill(weights, 1);
		cubeAllWithVariants(blocks, block, textures, weights);
	}

	protected void cubeAllWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] textures, Integer[] weights) {
		int length = textures.length;
		if (length != weights.length) {
			throw new IllegalArgumentException("Arrays must have equal length");
		}
		class_2960[] models = new class_2960[length];
		for (int i = 0; i < length; i++) {
			String suffix = i == 0 ? "" : "_" + i;
			class_2960 modelId = method_25843(block, suffix);
			models[i] = class_4943.field_22972.method_25852(modelId, class_4944.method_25875(textures[i]), this.modelOutput);
		}
		cubeAllWithModels(blocks, block, models, weights);
	}

	protected void cubeAllWithModels(Set<class_2248> blocks, class_2248 block, class_2960[] models, Integer[] weights) {
		int length = models.length;
		if (length != weights.length) {
			throw new IllegalArgumentException("Arrays must have equal length");
		}
		var indices = IntStream.range(0, length).boxed();
		this.blockstates.add(class_4925.method_25771(block, indices.map(i -> maybeWeight(weights[i], class_4935.method_25824().method_25828(class_4936.field_22887, models[i]))
		).toArray(class_4935[]::new)));
		blocks.remove(block);
	}

	protected void singleVariantBlockState(class_2248 b, class_2960 model) {
		this.blockstates.add(class_4925.method_25770(b, class_4935.method_25824().method_25828(class_4936.field_22887, model)));
	}

	protected void rotatedMirrored(Set<class_2248> blocks, class_2248 block, class_2960 texture) {
		rotatedMirroredWithVariants(blocks, block, new class_2960[] { texture });
	}

	protected void rotatedMirroredWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] textures) {
		var weights = new Integer[textures.length];
		Arrays.fill(weights, 1);
		rotatedMirroredWithVariants(blocks, block, textures, weights);
	}

	protected void rotatedMirroredWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] textures, Integer[] weights) {
		int length = textures.length;
		if (length != weights.length) {
			throw new IllegalArgumentException("Arrays must have equal length");
		}
		class_2960[] models = new class_2960[length];
		class_2960[] mirroredModels = new class_2960[length];
		for (int i = 0; i < length; i++) {
			String suffix = i == 0 ? "" : "_" + i;
			class_2960 modelId = method_25843(block, suffix);
			class_2960 mirriredModelId = method_25843(block, "_mirrored" + suffix);
			models[i] = class_4943.field_22972.method_25852(modelId, class_4944.method_25875(textures[i]), this.modelOutput);
			mirroredModels[i] = class_4943.field_22973.method_25852(mirriredModelId, class_4944.method_25875(textures[i]), this.modelOutput);
		}
		rotatedMirroredWithModels(blocks, block, models, mirroredModels, weights);
	}

	protected void rotatedMirroredWithModels(Set<class_2248> blocks, class_2248 block, class_2960[] models, class_2960[] mirroredModels, Integer[] weights) {
		int length = models.length;
		if (length != mirroredModels.length || length != weights.length) {
			throw new IllegalArgumentException("Arrays must have equal length");
		}
		var indices = IntStream.range(0, length).boxed();
		this.blockstates.add(class_4925.method_25771(block, indices.flatMap(i -> Stream.of(
				maybeWeight(weights[i], class_4935.method_25824().method_25828(class_4936.field_22887, models[i])),
				maybeWeight(weights[i], class_4935.method_25824().method_25828(class_4936.field_22887, mirroredModels[i])),
				maybeWeight(weights[i], class_4935.method_25824()
						.method_25828(class_4936.field_22887, models[i])
						.method_25828(class_4936.field_22886, class_4936.class_4937.field_22892)),
				maybeWeight(weights[i], class_4935.method_25824()
						.method_25828(class_4936.field_22887, mirroredModels[i])
						.method_25828(class_4936.field_22886, class_4936.class_4937.field_22892))
		)).toArray(class_4935[]::new)));
		blocks.remove(block);
	}

	protected void pillar(Set<class_2248> blocks, class_2248 block, class_2960 top, class_2960 side) {
		pillarWithVariants(blocks, block, new class_2960[] { top }, new class_2960[] { side });
	}

	protected void pillarWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] topTextures, class_2960[] sideTextures) {
		var weights = new Integer[topTextures.length];
		Arrays.fill(weights, 1);
		pillarWithVariants(blocks, block, topTextures, sideTextures, weights);
	}

	protected void pillarWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] topTextures, class_2960[] sideTextures, Integer[] weights) {
		int length = topTextures.length;
		if (length != sideTextures.length || length != weights.length) {
			throw new IllegalArgumentException("Arrays must have equal length");
		}
		class_2960[] topModels = new class_2960[length];
		class_2960[] horizontalModels = new class_2960[length];
		for (int i = 0; i < length; i++) {
			String suffix = i == 0 ? "" : "_" + i;
			class_2960 modelIdTop = method_25843(block, suffix);
			class_2960 modelIdHorizontal = method_25843(block, "_horizontal" + suffix);
			topModels[i] = class_4943.field_22974.method_25852(modelIdTop, class_4944.method_25870(sideTextures[i], topTextures[i]), this.modelOutput);
			horizontalModels[i] = class_4943.field_22975.method_25852(modelIdHorizontal, class_4944.method_25870(sideTextures[i], topTextures[i]), this.modelOutput);
		}
		pillarWithModels(blocks, block, topModels, horizontalModels, weights);
	}

	protected void pillarWithModels(Set<class_2248> blocks, class_2248 block, class_2960[] topModels, class_2960[] horizontalModels, Integer[] weights) {
		int length = topModels.length;
		if (length != horizontalModels.length || length != weights.length) {
			throw new IllegalArgumentException("Arrays must have equal length");
		}
		var indicesX = IntStream.range(0, length).boxed();
		var indicesY = IntStream.range(0, length).boxed();
		var indicesZ = IntStream.range(0, length).boxed();
		this.blockstates.add(class_4925.method_25769(block).method_25775(
				class_4926.method_25783(class_2741.field_12496)
						.method_25794(class_2350.class_2351.field_11052, indicesX.map(i -> maybeWeight(weights[i], class_4935.method_25824()
								.method_25828(class_4936.field_22887, topModels[i]))).toList())
						.method_25794(class_2350.class_2351.field_11051, indicesY.map(i -> maybeWeight(weights[i], class_4935.method_25824()
								.method_25828(class_4936.field_22887, horizontalModels[i])
								.method_25828(class_4936.field_22885, class_4936.class_4937.field_22891))).toList())
						.method_25794(class_2350.class_2351.field_11048, indicesZ.map(i -> maybeWeight(weights[i], class_4935.method_25824()
								.method_25828(class_4936.field_22887, horizontalModels[i])
								.method_25828(class_4936.field_22885, class_4936.class_4937.field_22891)
								.method_25828(class_4936.field_22886, class_4936.class_4937.field_22891))).toList())
		));
		blocks.remove(block);
	}

	// Alternative pillar model that rotates and mirrors some additional faces
	protected void pillarAlt(Set<class_2248> blocks, class_2248 block, class_2960 top, class_2960 side) {
		pillarAltWithVariants(blocks, block, new class_2960[] { top }, new class_2960[] { side });
	}

	protected void pillarAltWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] topTextures, class_2960[] sideTextures) {
		int length = topTextures.length;
		if (length != sideTextures.length) {
			throw new IllegalArgumentException("Arrays must have equal length");
		}
		class_2960[] topModels = new class_2960[length];
		class_2960[] horizontalXModels = new class_2960[length];
		class_2960[] horizontalZModels = new class_2960[length];
		class_4942 horizontalXTemplate = new class_4942(Optional.of(prefix("block/shapes/cube_column_horizontal_x")), Optional.of("_horizontal_x"), class_4945.field_23013, class_4945.field_23018);
		class_4942 horizontalZTemplate = new class_4942(Optional.of(prefix("block/shapes/cube_column_horizontal_z")), Optional.of("_horizontal_z"), class_4945.field_23013, class_4945.field_23018);
		for (int i = 0; i < length; i++) {
			String suffix = i == 0 ? "" : "_" + i;
			class_2960 modelIdTop = method_25843(block, suffix);
			class_2960 modelIdHorizontalX = method_25843(block, "_horizontal_x" + suffix);
			class_2960 modelIdHorizontalZ = method_25843(block, "_horizontal_z" + suffix);
			topModels[i] = class_4943.field_22974.method_25852(modelIdTop, class_4944.method_25870(sideTextures[i], topTextures[i]), this.modelOutput);
			horizontalXModels[i] = horizontalXTemplate.method_25852(modelIdHorizontalX, class_4944.method_25870(sideTextures[i], topTextures[i]), this.modelOutput);
			horizontalZModels[i] = horizontalZTemplate.method_25852(modelIdHorizontalZ, class_4944.method_25870(sideTextures[i], topTextures[i]), this.modelOutput);
		}
		pillarAltWithModels(blocks, block, topModels, horizontalXModels, horizontalZModels);
	}

	protected void pillarAltWithModels(Set<class_2248> blocks, class_2248 block, class_2960[] yModels, class_2960[] xModels, class_2960[] zModels) {
		this.blockstates.add(class_4925.method_25769(block).method_25775(
				class_4926.method_25783(class_2741.field_12496)
						.method_25794(class_2350.class_2351.field_11052, Stream.of(yModels).map(rl -> class_4935.method_25824().method_25828(class_4936.field_22887, rl)).toList())
						.method_25794(class_2350.class_2351.field_11048, Stream.of(xModels).map(rl -> class_4935.method_25824().method_25828(class_4936.field_22887, rl)).toList())
						.method_25794(class_2350.class_2351.field_11051, Stream.of(zModels).map(rl -> class_4935.method_25824().method_25828(class_4936.field_22887, rl)).toList())
		));
		blocks.remove(block);
	}

	protected void directionalPillar(Set<class_2248> blocks, class_2248 block, class_2960 top, class_2960 bottom, class_2960 side) {
		directionalPillarWithVariants(blocks, block, new class_2960[] { top }, new class_2960[] { top }, new class_2960[] { side });
	}

	protected void directionalPillarWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] topTextures, class_2960[] bottomTextures, class_2960[] sideTextures) {
		var weights = new Integer[topTextures.length];
		Arrays.fill(weights, 1);
		directionalPillarWithVariants(blocks, block, topTextures, bottomTextures, sideTextures, weights);
	}

	protected void directionalPillarWithVariants(Set<class_2248> blocks, class_2248 block, class_2960[] topTextures, class_2960[] bottomTextures, class_2960[] sideTextures, Integer[] weights) {
		int length = topTextures.length;
		if (length != bottomTextures.length || length != sideTextures.length || length != weights.length) {
			throw new IllegalArgumentException("Arrays must have equal length");
		}
		class_2960[] topModels = new class_2960[length];
		class_2960[] horizontalModels = new class_2960[length];
		class_4942 topTemplate = new class_4942(Optional.of(prefix("block/shapes/cube_column_directional")), Optional.empty(), class_4945.field_23015, class_4945.field_23014, class_4945.field_23018);
		class_4942 horizontalTemplate = new class_4942(Optional.of(prefix("block/shapes/cube_column_directional_horizontal")), Optional.of("_horizontal"), class_4945.field_23015, class_4945.field_23014, class_4945.field_23018);
		for (int i = 0; i < length; i++) {
			class_4944 mapping = new class_4944()
					.method_25868(class_4945.field_23018, sideTextures[i])
					.method_25868(class_4945.field_23015, topTextures[i])
					.method_25868(class_4945.field_23014, bottomTextures[i]);
			String suffix = i == 0 ? "" : "_" + i;
			class_2960 modelIdTop = method_25843(block, suffix);
			class_2960 modelIdHorizontal = method_25843(block, "_horizontal" + suffix);
			topModels[i] = topTemplate.method_25852(modelIdTop, mapping, this.modelOutput);
			horizontalModels[i] = horizontalTemplate.method_25852(modelIdHorizontal, mapping, this.modelOutput);
		}
		directionalPillarWithModels(blocks, block, topModels, horizontalModels, weights);
	}

	protected void directionalPillarWithModels(Set<class_2248> blocks, class_2248 block, class_2960[] topModels, class_2960[] horizontalModels, Integer[] weights) {
		int length = topModels.length;
		if (length != horizontalModels.length || length != weights.length) {
			throw new IllegalArgumentException("Arrays must have equal length");
		}
		var indicesUp = IntStream.range(0, length).boxed();
		var indicesDown = IntStream.range(0, length).boxed();
		var indicesNorth = IntStream.range(0, length).boxed();
		var indicesSouth = IntStream.range(0, length).boxed();
		var indicesEast = IntStream.range(0, length).boxed();
		var indicesWest = IntStream.range(0, length).boxed();
		this.blockstates.add(class_4925.method_25769(block).method_25775(
				class_4926.method_25783(class_2741.field_12525)
						.method_25794(class_2350.field_11036, indicesUp.map(i -> maybeWeight(weights[i], class_4935.method_25824()
								.method_25828(class_4936.field_22887, topModels[i]))).toList())
						.method_25794(class_2350.field_11033, indicesDown.map(i -> maybeWeight(weights[i], class_4935.method_25824()
								.method_25828(class_4936.field_22887, topModels[i])
								.method_25828(class_4936.field_22885, class_4936.class_4937.field_22892))).toList())
						.method_25794(class_2350.field_11043, indicesNorth.map(i -> maybeWeight(weights[i], class_4935.method_25824()
								.method_25828(class_4936.field_22887, horizontalModels[i]))).toList())
						.method_25794(class_2350.field_11035, indicesSouth.map(i -> maybeWeight(weights[i], class_4935.method_25824()
								.method_25828(class_4936.field_22887, horizontalModels[i])
								.method_25828(class_4936.field_22886, class_4936.class_4937.field_22892))).toList())
						.method_25794(class_2350.field_11034, indicesEast.map(i -> maybeWeight(weights[i], class_4935.method_25824()
								.method_25828(class_4936.field_22887, horizontalModels[i])
								.method_25828(class_4936.field_22886, class_4936.class_4937.field_22891))).toList())
						.method_25794(class_2350.field_11039, indicesWest.map(i -> maybeWeight(weights[i], class_4935.method_25824()
								.method_25828(class_4936.field_22887, horizontalModels[i])
								.method_25828(class_4936.field_22886, class_4936.class_4937.field_22893))).toList())
		));
		blocks.remove(block);
	}

	protected <T> class_4935 withMaybe(class_4938<T> property, T value, boolean shouldAdd, class_4935 variant) {
		if (shouldAdd) {
			variant.method_25828(property, value);
		}
		return variant;
	}

	protected class_4935 maybeUVLock(Boolean uvlock, class_4935 variant) {
		return withMaybe(class_4936.field_22888, uvlock, uvlock, variant);
	}

	protected class_4935 maybeWeight(int weight, class_4935 variant) {
		return withMaybe(class_4936.field_22889, weight, weight != 1, variant);
	}

	protected class_4935 maybeXRot(class_4936.class_4937 rotation, class_4935 variant) {
		return withMaybe(class_4936.field_22885, rotation, rotation != class_4936.class_4937.field_22890, variant);
	}

	protected class_4935 maybeYRot(class_4936.class_4937 rotation, class_4935 variant) {
		return withMaybe(class_4936.field_22886, rotation, rotation != class_4936.class_4937.field_22890, variant);
	}

	@SafeVarargs
	@SuppressWarnings("varargs")
	public final <T> Collection<T> takeAll(Set<T> src, T... items) {
		List<T> ret = Arrays.asList(items);
		for (T item : items) {
			if (!src.contains(item)) {
				getLogger().warn("Item {} not found in set", item);
			}
		}
		if (!src.removeAll(ret)) {
			getLogger().warn("takeAll array didn't yield anything ({})", Arrays.toString(items));
		}
		return ret;
	}

	public final <T> Collection<T> takeAll(Set<T> src, Predicate<T> pred) {
		List<T> ret = new ArrayList<>();

		Iterator<T> iter = src.iterator();
		while (iter.hasNext()) {
			T item = iter.next();
			if (pred.test(item)) {
				iter.remove();
				ret.add(item);
			}
		}

		if (ret.isEmpty()) {
			getLogger().warn("takeAll predicate yielded nothing", new Throwable());
		}
		return ret;
	}

	protected void redStringBlock(class_2248 b) {
		class_2960 selfName = method_25860(b);
		class_2960 front = prefix("block/red_string_sender");
		var model = class_4943.field_22978.method_25846(b, new class_4944()
				.method_25868(class_4945.field_23015, selfName)
				.method_25868(class_4945.field_23016, front)
				.method_25868(class_4945.field_23018, selfName), this.modelOutput);
		this.blockstates.add(class_4925.method_25770(b, class_4935.method_25824().method_25828(class_4936.field_22887, model))
				.method_25775(BlockModelGeneratorsAccessor.facingDispatch()));
	}
}
