/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.bauble;

import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1548;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3738;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5354;
import net.minecraft.class_572;
import net.minecraft.class_811;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.*;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.block.flower.functional.HeiseiDreamBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.mixin.CreeperAccessor;
import vazkii.botania.mixin.EntityAccessor;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.List;
import java.util.function.Predicate;

public class CharmOfTheDivaItem extends BaubleItem {
	public static final int MANA_COST = 250;
	public static final int CHARM_RANGE = 20;

	public CharmOfTheDivaItem(class_1793 props) {
		super(props);
		Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
	}

	private static Predicate<class_1308> getCharmTargetPredicate(class_1657 player, class_1308 mobToCharm) {
		return mob -> mob != mobToCharm && mob.method_5805() && mob.method_33190() && !mob.method_5794(mobToCharm)
				&& (!(mob instanceof class_1321 tamable) || !tamable.method_6171(player))
				&& (mob instanceof class_1569 || mob instanceof class_5354 neutralMob && (neutralMob.method_29515(player)
						|| mob.method_5968() instanceof class_1321 targetTamable && targetTamable.method_6171(player)));
	}

	private static void charmMobs(class_1799 amulet, class_1657 player, class_1308 target) {
		if (!ManaItemHandler.instance().requestManaExact(amulet, player, MANA_COST, false)) {
			return;
		}
		if (target.method_5805()
				&& (target instanceof class_1569 || target instanceof class_5354)
				// don't encourage being a bad pet owner
				&& (!(target instanceof class_1321 tamable) || !tamable.method_6171(player))
				// check that target is still nearby, since it was marked some time earlier
				&& player.method_19538().method_24802(target.method_19538(), CHARM_RANGE)) {
			List<class_1308> potentialTargets = player.method_37908().method_8390(class_1308.class,
					class_238.method_30048(target.method_19538(), 2 * CHARM_RANGE, 2 * CHARM_RANGE, 2 * CHARM_RANGE),
					getCharmTargetPredicate(player, target));
			if (!potentialTargets.isEmpty() && HeiseiDreamBlockEntity.brainwashEntity(target, potentialTargets)) {
				target.method_6025(target.method_6063());
				((EntityAccessor) target).callUnsetRemoved();
				if (target instanceof class_1548) {
					((CreeperAccessor) target).setCurrentFuseTime(2);
				}

				ManaItemHandler.instance().requestManaExact(amulet, player, MANA_COST, true);
				player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), BotaniaSounds.divaCharm, class_3419.field_15248, 1F, 1F);
				XplatAbstractions.INSTANCE.sendToTracking(target, new BotaniaEffectPacket(EffectType.DIVA_EFFECT, target.method_23317(), target.method_23318(), target.method_23321(), target.method_5628()));
			}
		}
	}

	public static void onEntityDamaged(class_1657 player, class_1309 entity) {
		if (entity instanceof class_1308 target
				&& !target.method_37908().field_9236
				// TODO 1.21: Use an actual boss identification method (likely via entity tag)
				&& target.method_5822()
				&& Math.random() < 0.6) {
			MinecraftServer server = player.method_37908().method_8503();
			class_1799 amulet = EquipmentHandler.findOrEmpty(BotaniaItems.divaCharm, player);

			if (server != null && !amulet.method_7960()) {
				// schedule for immediate execution after everything else in this tick
				server.method_18858(new class_3738(0, () -> charmMobs(amulet, player, target)));
			}
		}
	}

	public static class Renderer implements AccessoryRenderer {
		@Override
		public void doRender(class_572<?> bipedModel, class_1799 stack, class_1309 living, class_4587 ms, class_4597 buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
			bipedModel.field_3398.method_22703(ms);
			ms.method_22904(0.15, -0.42, -0.35);
			ms.method_22905(0.4F, -0.4F, -0.4F);
			class_310.method_1551().method_1480().method_23178(stack, class_811.field_4315,
					light, class_4608.field_21444, ms, buffers, living.method_37908(), living.method_5628());
		}
	}
}
