/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity.red_string;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;

public class RedStringComparatorBlockEntity extends RedStringBlockEntity {
	private int comparatorValue = 0;

	public RedStringComparatorBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaBlockEntities.RED_STRING_COMPARATOR, pos, state);
	}

	public static void commonTick(class_1937 level, class_2338 worldPosition, class_2680 state, RedStringComparatorBlockEntity self) {
		RedStringBlockEntity.commonTick(level, worldPosition, state, self);
		class_2338 binding = self.getBinding();
		class_2680 bindState = self.getStateAtBinding();
		int origVal = self.comparatorValue;

		if (bindState.method_26221()) {
			self.comparatorValue = bindState.method_26176(level, binding);
		} else {
			self.comparatorValue = 0;
		}

		if (origVal != self.comparatorValue) {
			level.method_8455(worldPosition, state.method_26204());
		}
	}

	public int getComparatorValue() {
		return comparatorValue;
	}

	@Override
	public boolean acceptBlock(class_2338 pos) {
		return field_11863.method_8320(pos).method_26221();
	}

}
