/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity.corporea;

import vazkii.botania.api.corporea.CorporeaInterceptor;
import vazkii.botania.api.corporea.CorporeaNode;
import vazkii.botania.api.corporea.CorporeaRequestMatcher;
import vazkii.botania.api.corporea.CorporeaSpark;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.helper.FilterHelper;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1533;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;

public class CorporeaInterceptorBlockEntity extends BaseCorporeaBlockEntity implements CorporeaInterceptor {
	public CorporeaInterceptorBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaBlockEntities.CORPOREA_INTERCEPTOR, pos, state);
	}

	@Override
	public void interceptRequest(CorporeaRequestMatcher request, int count, CorporeaSpark spark, CorporeaSpark source, List<class_1799> stacks, Set<CorporeaNode> nodes, boolean doit) {}

	@Override
	public void interceptRequestLast(CorporeaRequestMatcher request, int count, CorporeaSpark spark, CorporeaSpark source, List<class_1799> stacks, Set<CorporeaNode> nodes, boolean doit) {
		List<class_1799> filter = getFilter();

		boolean filterMatch = false;
		for (class_1799 stack : filter) {
			if (request.test(stack)) {
				filterMatch = true;
			}
		}

		if (filterMatch || filter.isEmpty()) {
			int missing = count;
			for (class_1799 stack : stacks) {
				missing -= stack.method_7947();
			}

			if (missing > 0 && !method_11010().method_11654(class_2741.field_12484)) {
				class_2338 requestorPos = source.getSparkNode().getPos();

				List<CorporeaRetainerBlockEntity> retainers = new ArrayList<>();
				for (class_2350 dir : class_2350.values()) {
					class_2586 tile = field_11863.method_8321(field_11867.method_10093(dir));
					if (tile instanceof CorporeaRetainerBlockEntity retainer) {
						retainers.add(retainer);
						retainer.forget();
					}
				}

				field_11863.method_8501(method_11016(), method_11010().method_11657(class_2741.field_12484, true));
				field_11863.method_39279(method_11016(), method_11010().method_26204(), 2);

				for (CorporeaRetainerBlockEntity retainer : retainers) {
					retainer.remember(requestorPos, request, count, missing);
				}
			}
		}
	}

	private List<class_1799> getFilter() {
		List<class_1799> filter = new ArrayList<>();

		for (class_2350 dir : class_2350.values()) {
			List<class_1533> frames = field_11863.method_18467(class_1533.class, new class_238(field_11867.method_10093(dir), field_11867.method_10093(dir).method_10069(1, 1, 1)));
			for (class_1533 frame : frames) {
				class_2350 orientation = frame.method_5735();
				if (orientation == dir) {
					filter.addAll(FilterHelper.getFilterItems(frame));
				}
			}
		}

		return filter;
	}

}
