/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.flower.generating;

import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.xplat.BotaniaConfig;

import java.util.*;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2397;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_5712;
import net.minecraft.class_6088;

public class MunchdewBlockEntity extends GeneratingFlowerBlockEntity {
	public static final String TAG_COOLDOWN = "cooldown";
	private static final String TAG_ATE_ONCE = "ateOnce";

	private static final int RANGE = 8;
	private static final int RANGE_Y = 16;

	private boolean ateOnce = false;
	private int ticksWithoutEating = -1;
	private int cooldown = 0;

	public MunchdewBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaFlowerBlocks.MUNCHDEW, pos, state);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (method_10997().field_9236) {
			if (cooldown > 0) {
				if (Math.random() < 0.5) {
					class_243 offset = method_10997().method_8320(method_11016()).method_26226(method_10997(), method_11016());
					double x = method_11016().method_10263() + offset.field_1352 + 0.2 + Math.random() * 0.6;
					double y = method_11016().method_10264() + offset.field_1351 + 0.6 + Math.random() * 0.3;
					double z = method_11016().method_10260() + offset.field_1350 + 0.2 + Math.random() * 0.6;
					WispParticleData data = WispParticleData.wisp(0.05F, 0.5F, 0.5F, 0.5F);
					method_10997().method_8406(data, x, y, z, 0, 0.025F, 0);
				}
				cooldown--;
			}
			return;
		}

		if (cooldown > 0) {
			cooldown--;
			ticksWithoutEating = 0;
			ateOnce = false; // don't start ticking ticksWithoutEating again until we eat again
			return;
		}

		int manaPerLeaf = 160;
		eatLeaves: {
			if (getMaxMana() - getMana() >= manaPerLeaf && ticksExisted % 4 == 0) {
				Map<class_2338, Float> coordsMap = new HashMap<>();
				Random rng = new Random();
				class_2338 pos = getEffectivePos();

				for (class_2338 pos_ : class_2338.method_10097(pos.method_10069(-RANGE, 0, -RANGE),
						pos.method_10069(RANGE, RANGE_Y, RANGE))) {
					class_2680 state = method_10997().method_8320(pos_);
					if (state.method_26164(class_3481.field_15503)) {
						for (class_2350 dir : class_2350.values()) {
							if (method_10997().method_22347(pos_.method_10093(dir))) {
								coordsMap.put(pos_.method_10062(), (state.method_28498(class_2397.field_11199)
										? state.method_11654(class_2397.field_11199) : 1) + 2.0f * rng.nextFloat());
								break;
							}
						}
					}
				}

				if (coordsMap.isEmpty()) {
					break eatLeaves;
				}

				float maxDistance = 0F;
				for (float distance : coordsMap.values()) {
					maxDistance = Math.max(maxDistance, distance);
				}

				float finalMaxDistance = maxDistance;
				coordsMap.values().removeIf(dist -> dist < finalMaxDistance - 1f);
				List<class_2338> coords = new ArrayList<>(coordsMap.keySet());

				class_2338 breakCoords = coords.get(field_11863.method_8409().method_43048(coords.size()));
				class_2680 state = method_10997().method_8320(breakCoords);
				method_10997().method_8650(breakCoords, false);
				ticksWithoutEating = 0;
				ateOnce = true;
				if (BotaniaConfig.common().blockBreakParticles()) {
					method_10997().method_20290(class_6088.field_31144, breakCoords, class_2248.method_9507(state));
				}
				method_10997().method_33596(null, class_5712.field_28165, breakCoords);
				addMana(manaPerLeaf);
			}
		}

		if (ateOnce) {
			ticksWithoutEating++;
			if (ticksWithoutEating >= 5) {
				cooldown = 1600;
				sync();
			}
		}
	}

	@Override
	public RadiusDescriptor getRadius() {
		return RadiusDescriptor.Rectangle.square(getEffectivePos(), RANGE);
	}

	@Override
	public void writeToPacketNBT(class_2487 cmp) {
		super.writeToPacketNBT(cmp);

		cmp.method_10569(TAG_COOLDOWN, cooldown);
		cmp.method_10556(TAG_ATE_ONCE, ateOnce);
	}

	@Override
	public void readFromPacketNBT(class_2487 cmp) {
		super.readFromPacketNBT(cmp);

		cooldown = cmp.method_10550(TAG_COOLDOWN);
		ateOnce = cmp.method_10577(TAG_ATE_ONCE);
	}

	@Override
	public int getColor() {
		return 0x79C42F;
	}

	@Override
	public int getMaxMana() {
		return 10000;
	}

}
