/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.recipe.RunicAltarRecipe;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.SimpleInventoryBlockEntity;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.item.material.RuneItem;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.xplat.XplatAbstractions;

public class RunicAltarBlockEntity
extends SimpleInventoryBlockEntity
implements ManaReceiver,
Wandable {
    private static final String TAG_MANA = "mana";
    private static final String TAG_MANA_TO_GET = "manaToGet";
    private static final int SET_KEEP_TICKS_EVENT = 0;
    private static final int SET_COOLDOWN_EVENT = 1;
    private static final int CRAFT_EFFECT_EVENT = 2;
    private RunicAltarRecipe currentRecipe;
    public int manaToGet = 0;
    private int mana = 0;
    private int cooldown = 0;
    public int signal = 0;
    private List<ItemStack> lastRecipe = null;
    private int recipeKeepTicks = 0;

    public RunicAltarBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.RUNE_ALTAR, pos, state);
    }

    public boolean addItem(@Nullable Player player, ItemStack stack, @Nullable InteractionHand hand) {
        if (this.cooldown > 0 || stack.getItem() instanceof WandOfTheForestItem || stack.is((Item)BotaniaItems.lexicon)) {
            return false;
        }
        if (stack.is(BotaniaBlocks.livingrock.asItem())) {
            if (!this.level.isClientSide) {
                ItemStack toSpawn = player != null && player.getAbilities().instabuild ? stack.copy().split(1) : stack.split(1);
                ItemEntity item = new ItemEntity(this.level, (double)this.getBlockPos().getX() + 0.5, (double)(this.getBlockPos().getY() + 1), (double)this.getBlockPos().getZ() + 0.5, toSpawn);
                item.setPickUpDelay(40);
                item.setDeltaMovement(Vec3.ZERO);
                this.level.addFreshEntity((Entity)item);
            }
            return true;
        }
        if (this.manaToGet != 0) {
            return false;
        }
        boolean did = false;
        for (int i = 0; i < this.inventorySize(); ++i) {
            if (!this.getItemHandler().getItem(i).isEmpty()) continue;
            did = true;
            ItemStack stackToAdd = stack.copyWithCount(1);
            this.getItemHandler().setItem(i, stackToAdd);
            if (player != null && player.getAbilities().instabuild) break;
            stack.shrink(1);
            break;
        }
        if (did) {
            this.level.gameEvent(null, GameEvent.BLOCK_CHANGE, this.getBlockPos());
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
        return true;
    }

    public boolean triggerEvent(int id, int param) {
        switch (id) {
            case 0: {
                this.recipeKeepTicks = param;
                return true;
            }
            case 1: {
                this.cooldown = param;
                return true;
            }
            case 2: {
                if (this.level.isClientSide) {
                    for (int i = 0; i < 25; ++i) {
                        float red = (float)Math.random();
                        float green = (float)Math.random();
                        float blue = (float)Math.random();
                        SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 10);
                        this.level.addParticle((ParticleOptions)data, (double)this.worldPosition.getX() + 0.5 + Math.random() * 0.4 - 0.2, (double)(this.worldPosition.getY() + 1), (double)this.worldPosition.getZ() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.0, 0.0);
                    }
                    this.level.playLocalSound((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), BotaniaSounds.runeAltarCraft, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
                return true;
            }
        }
        return super.triggerEvent(id, param);
    }

    private void tickCooldown() {
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (this.recipeKeepTicks > 0) {
            --this.recipeKeepTicks;
        } else {
            this.lastRecipe = null;
        }
    }

    public static void serverTick(Level level, BlockPos worldPosition, BlockState state, RunicAltarBlockEntity self) {
        if (self.manaToGet == 0) {
            List items = level.getEntitiesOfClass(ItemEntity.class, new AABB(worldPosition, worldPosition.offset(1, 1, 1)));
            for (ItemEntity item : items) {
                ItemStack stack;
                if (!item.isAlive() || item.getItem().isEmpty() || item.getItem().is(BotaniaBlocks.livingrock.asItem()) || XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)item).runicAltarSpawned || !self.addItem(null, stack = item.getItem(), null)) continue;
                EntityHelper.syncItem(item);
            }
        }
        int newSignal = 0;
        if (self.manaToGet > 0) {
            ++newSignal;
            if (self.mana >= self.manaToGet) {
                ++newSignal;
            }
        }
        if (newSignal != self.signal) {
            self.signal = newSignal;
            level.updateNeighbourForOutputSignal(worldPosition, state.getBlock());
        }
        self.updateRecipe();
        self.tickCooldown();
    }

    public static void clientTick(Level level, BlockPos worldPosition, BlockState state, RunicAltarBlockEntity self) {
        if (self.manaToGet > 0 && self.mana >= self.manaToGet && level.random.nextInt(20) == 0) {
            Vec3 vec = Vec3.atCenterOf((Vec3i)self.getBlockPos());
            Vec3 endVec = vec.add(0.0, 2.5, 0.0);
            Proxy.INSTANCE.lightningFX(level, vec, endVec, 2.0f, 38027, 58583);
        }
        if (self.cooldown > 0) {
            WispParticleData data = WispParticleData.wisp(0.2f, 0.2f, 0.2f, 0.2f, 1.0f);
            level.addParticle((ParticleOptions)data, (double)worldPosition.getX() + Math.random(), (double)worldPosition.getY() + 0.8, (double)worldPosition.getZ() + Math.random(), 0.0, (double)0.025f, 0.0);
        }
        self.tickCooldown();
    }

    private void updateRecipe() {
        int manaToGet = this.manaToGet;
        this.manaToGet = this.currentRecipe != null ? this.currentRecipe.getManaUsage() : this.level.getRecipeManager().getRecipeFor(BotaniaRecipeTypes.RUNE_TYPE, this.getItemHandler(), this.level).map(RunicAltarRecipe::getManaUsage).orElse(0).intValue();
        if (manaToGet != this.manaToGet) {
            this.level.playSound(null, this.worldPosition, BotaniaSounds.runeAltarStart, SoundSource.BLOCKS, 1.0f, 1.0f);
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    private void saveLastRecipe() {
        ItemStack stack;
        this.lastRecipe = new ArrayList<ItemStack>();
        for (int i = 0; i < this.inventorySize() && !(stack = this.getItemHandler().getItem(i)).isEmpty(); ++i) {
            this.lastRecipe.add(stack.copy());
        }
        this.recipeKeepTicks = 400;
        this.level.blockEvent(this.getBlockPos(), BotaniaBlocks.runeAltar, 0, 400);
    }

    public InteractionResult trySetLastRecipe(Player player) {
        if (player.level().isClientSide()) {
            return InteractionResult.sidedSuccess((boolean)true);
        }
        boolean success = InventoryHelper.tryToSetLastRecipe(player, this.getItemHandler(), this.lastRecipe, null);
        if (success) {
            this.level.gameEvent(null, GameEvent.BLOCK_CHANGE, this.getBlockPos());
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
        return success ? InteractionResult.sidedSuccess((boolean)false) : InteractionResult.PASS;
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack wand, Direction side) {
        if (this.level.isClientSide) {
            return true;
        }
        RunicAltarRecipe recipe = null;
        if (this.currentRecipe != null) {
            recipe = this.currentRecipe;
        } else {
            Optional maybeRecipe = this.level.getRecipeManager().getRecipeFor(BotaniaRecipeTypes.RUNE_TYPE, this.getItemHandler(), this.level);
            if (maybeRecipe.isPresent()) {
                recipe = (RunicAltarRecipe)maybeRecipe.get();
            }
        }
        if (recipe != null && this.manaToGet > 0 && this.mana >= this.manaToGet) {
            List items = this.level.getEntitiesOfClass(ItemEntity.class, new AABB(this.worldPosition, this.worldPosition.offset(1, 1, 1)));
            ItemEntity livingrock = null;
            for (ItemEntity item : items) {
                if (!item.isAlive() || item.getItem().isEmpty() || !item.getItem().is(BotaniaBlocks.livingrock.asItem())) continue;
                livingrock = item;
                break;
            }
            if (livingrock != null) {
                int mana = recipe.getManaUsage();
                this.receiveMana(-mana);
                ItemStack output = recipe.assemble(this.getItemHandler(), this.getLevel().registryAccess());
                ItemEntity outputItem = new ItemEntity(this.level, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.5, (double)this.worldPosition.getZ() + 0.5, output);
                XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)outputItem).runicAltarSpawned = true;
                if (player != null) {
                    player.triggerRecipeCrafted((Recipe)recipe, List.of(output));
                    output.onCraftedBy(this.level, player, output.getCount());
                }
                this.level.addFreshEntity((Entity)outputItem);
                this.currentRecipe = null;
                this.level.gameEvent(null, GameEvent.BLOCK_ACTIVATE, this.getBlockPos());
                this.level.blockEvent(this.getBlockPos(), BotaniaBlocks.runeAltar, 1, 60);
                this.level.blockEvent(this.getBlockPos(), BotaniaBlocks.runeAltar, 2, 0);
                this.saveLastRecipe();
                for (int i = 0; i < this.inventorySize(); ++i) {
                    ItemStack stack = this.getItemHandler().getItem(i);
                    if (stack.isEmpty()) continue;
                    if (stack.getItem() instanceof RuneItem && (player == null || !player.getAbilities().instabuild)) {
                        ItemEntity outputRune = new ItemEntity(this.level, (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 1.5, (double)this.getBlockPos().getZ() + 0.5, stack.copy());
                        XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)outputRune).runicAltarSpawned = true;
                        this.level.addFreshEntity((Entity)outputRune);
                    }
                    this.getItemHandler().setItem(i, ItemStack.EMPTY);
                }
                EntityHelper.shrinkItem(livingrock);
            }
        }
        return true;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.inventorySize(); ++i) {
            if (this.getItemHandler().getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void writePacketNBT(CompoundTag tag) {
        super.writePacketNBT(tag);
        tag.putInt(TAG_MANA, this.mana);
        tag.putInt(TAG_MANA_TO_GET, this.manaToGet);
    }

    @Override
    public void readPacketNBT(CompoundTag tag) {
        super.readPacketNBT(tag);
        this.mana = tag.getInt(TAG_MANA);
        this.manaToGet = tag.getInt(TAG_MANA_TO_GET);
    }

    @Override
    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(16){

            public int getMaxStackSize() {
                return 1;
            }
        };
    }

    @Override
    public Level getManaReceiverLevel() {
        return this.getLevel();
    }

    @Override
    public BlockPos getManaReceiverPos() {
        return this.getBlockPos();
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public boolean isFull() {
        return this.mana >= this.manaToGet;
    }

    @Override
    public void receiveMana(int mana) {
        this.mana = Math.min(this.mana + mana, this.manaToGet);
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return !this.isFull();
    }

    public boolean canAddLastRecipe() {
        return this.isEmpty();
    }

    public int getTargetMana() {
        return this.manaToGet;
    }

    public static class Hud {
        public static void render(RunicAltarBlockEntity altar, GuiGraphics gui, Minecraft mc) {
            PoseStack ms = gui.pose();
            int xc = mc.getWindow().getGuiScaledWidth() / 2;
            int yc = mc.getWindow().getGuiScaledHeight() / 2;
            float angle = -90.0f;
            int radius = 24;
            int amt = 0;
            for (int i = 0; i < altar.inventorySize() && !altar.getItemHandler().getItem(i).isEmpty(); ++i) {
                ++amt;
            }
            if (amt > 0 && altar.manaToGet > 0) {
                float anglePer = 360.0f / (float)amt;
                altar.level.getRecipeManager().getRecipeFor(BotaniaRecipeTypes.RUNE_TYPE, altar.getItemHandler(), altar.level).ifPresent(recipe -> {
                    RenderSystem.enableBlend();
                    RenderSystem.blendFunc((int)770, (int)771);
                    float progress = (float)altar.mana / (float)altar.manaToGet;
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderHelper.drawTexturedModalRect(gui, HUDHandler.manaBar, xc + radius + 9, yc - 8, progress == 1.0f ? 0 : 22, 8, 22, 15);
                    if (progress == 1.0f) {
                        gui.renderFakeItem(new ItemStack((ItemLike)BotaniaBlocks.livingrock), xc + radius + 16, yc + 8);
                        ms.pushPose();
                        ms.translate(0.0f, 0.0f, 100.0f);
                        ItemStack playerWand = PlayerHelper.getFirstHeldItemClass((LivingEntity)mc.player, WandOfTheForestItem.class);
                        if (playerWand.isEmpty()) {
                            playerWand = PlayerHelper.getItemClassFromInventory((Player)mc.player, WandOfTheForestItem.class);
                        }
                        ItemStack wandToRender = playerWand.isEmpty() ? new ItemStack((ItemLike)BotaniaItems.twigWand) : playerWand;
                        gui.renderFakeItem(wandToRender, xc + radius + 24, yc + 8);
                        ms.popPose();
                    }
                    RenderHelper.renderProgressPie(gui, xc + radius + 32, yc - 8, progress, recipe.assemble(altar.getItemHandler(), altar.getLevel().registryAccess()));
                    if (progress == 1.0f) {
                        gui.drawString(mc.font, "+", xc + radius + 14, yc + 12, 0xFFFFFF, false);
                    }
                });
                for (int i = 0; i < amt; ++i) {
                    double xPos = (double)xc + Math.cos((double)angle * Math.PI / 180.0) * (double)radius - 8.0;
                    double yPos = (double)yc + Math.sin((double)angle * Math.PI / 180.0) * (double)radius - 8.0;
                    ms.pushPose();
                    ms.translate(xPos, yPos, 0.0);
                    gui.renderFakeItem(altar.getItemHandler().getItem(i), 0, 0);
                    ms.popPose();
                    angle += anglePer;
                }
            }
            if (altar.recipeKeepTicks > 0 && altar.canAddLastRecipe()) {
                String s = I18n.get((String)"botaniamisc.altarRefill0", (Object[])new Object[0]);
                gui.drawString(mc.font, s, xc - mc.font.width(s) / 2, yc + 10, 0xFFFFFF);
                s = I18n.get((String)"botaniamisc.altarRefill1", (Object[])new Object[0]);
                gui.drawString(mc.font, s, xc - mc.font.width(s) / 2, yc + 20, 0xFFFFFF);
            }
        }
    }
}

