/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.StateIngredientHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.data.recipes.BotaniaRecipeProvider;

public class PureDaisyProvider
extends BotaniaRecipeProvider {
    public PureDaisyProvider(PackOutput packOutput) {
        super(packOutput);
    }

    @Override
    public void buildRecipes(Consumer<net.minecraft.data.recipes.FinishedRecipe> consumer) {
        consumer.accept(new FinishedRecipe(PureDaisyProvider.id("livingrock"), StateIngredientHelper.of(Blocks.STONE), BotaniaBlocks.livingrock.defaultBlockState()));
        consumer.accept(new StateCopyingRecipe(PureDaisyProvider.id("livingwood"), StateIngredientHelper.of((TagKey<Block>)BlockTags.LOGS), BotaniaBlocks.livingwoodLog));
        consumer.accept(new FinishedRecipe(PureDaisyProvider.id("cobblestone"), StateIngredientHelper.of(Blocks.NETHERRACK), Blocks.COBBLESTONE.defaultBlockState()));
        consumer.accept(new FinishedRecipe(PureDaisyProvider.id("end_stone_to_cobbled_deepslate"), StateIngredientHelper.of(Blocks.END_STONE), Blocks.COBBLED_DEEPSLATE.defaultBlockState(), 150, ResourceLocationHelper.prefix("ender_air_release")));
        consumer.accept(new FinishedRecipe(PureDaisyProvider.id("sand"), StateIngredientHelper.of(Blocks.SOUL_SAND), Blocks.SAND.defaultBlockState()));
        consumer.accept(new FinishedRecipe(PureDaisyProvider.id("packed_ice"), StateIngredientHelper.of(Blocks.ICE), Blocks.PACKED_ICE.defaultBlockState()));
        consumer.accept(new FinishedRecipe(PureDaisyProvider.id("blue_ice"), StateIngredientHelper.of(Blocks.PACKED_ICE), Blocks.BLUE_ICE.defaultBlockState()));
        consumer.accept(new FinishedRecipe(PureDaisyProvider.id("obsidian"), StateIngredientHelper.of(BotaniaBlocks.blazeBlock), Blocks.OBSIDIAN.defaultBlockState()));
        consumer.accept(new FinishedRecipe(PureDaisyProvider.id("snow_block"), StateIngredientHelper.of(Blocks.WATER), Blocks.SNOW_BLOCK.defaultBlockState()));
    }

    public String getName() {
        return "Botania Pure Daisy recipes";
    }

    private static ResourceLocation id(String path) {
        return ResourceLocationHelper.prefix("pure_daisy/" + path);
    }

    protected static class FinishedRecipe
    implements net.minecraft.data.recipes.FinishedRecipe {
        public static final int DEFAULT_TIME = 150;
        protected final ResourceLocation id;
        protected final StateIngredient input;
        protected final BlockState outputState;
        protected final int time;
        @Nullable
        private final ResourceLocation function;

        public FinishedRecipe(ResourceLocation id, StateIngredient input, BlockState state) {
            this(id, input, state, 150);
        }

        public FinishedRecipe(ResourceLocation id, StateIngredient input, BlockState state, int time) {
            this(id, input, state, time, null);
        }

        public FinishedRecipe(ResourceLocation id, StateIngredient input, BlockState state, int time, @Nullable ResourceLocation function) {
            Preconditions.checkArgument((time >= 0 ? 1 : 0) != 0, (Object)"Time must be nonnegative");
            this.id = id;
            this.input = input;
            this.outputState = state;
            this.time = time;
            this.function = function;
        }

        public void serializeRecipeData(JsonObject json) {
            json.add("input", (JsonElement)this.input.serialize());
            json.add("output", (JsonElement)StateIngredientHelper.serializeBlockState(this.outputState));
            if (this.time != 150) {
                json.addProperty("time", (Number)this.time);
            }
            if (this.function != null) {
                json.addProperty("success_function", this.function.toString());
            }
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public RecipeSerializer<?> getType() {
            return BotaniaRecipeTypes.PURE_DAISY_SERIALIZER;
        }

        @Nullable
        public JsonObject serializeAdvancement() {
            return null;
        }

        @Nullable
        public ResourceLocation getAdvancementId() {
            return null;
        }
    }

    protected static class StateCopyingRecipe
    extends FinishedRecipe {
        public StateCopyingRecipe(ResourceLocation id, StateIngredient input, Block block) {
            super(id, input, block.defaultBlockState());
        }

        @Override
        public void serializeRecipeData(JsonObject json) {
            json.add("input", (JsonElement)this.input.serialize());
            json.addProperty("output", BuiltInRegistries.BLOCK.getKey((Object)this.outputState.getBlock()).toString());
            if (this.time != 150) {
                json.addProperty("time", (Number)this.time);
            }
        }

        @Override
        public RecipeSerializer<?> getType() {
            return BotaniaRecipeTypes.COPYING_PURE_DAISY_SERIALIZER;
        }
    }
}

