/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.network.serverbound.DodgePacket;
import vazkii.botania.xplat.ClientXplatAbstractions;

public class RingOfDexterousMotionItem
extends BaubleItem {
    public static final String TAG_DODGE_COOLDOWN = "dodgeCooldown";
    public static final int MAX_CD = 20;
    private static boolean oldLeftDown;
    private static boolean oldRightDown;
    private static boolean oldForwardDown;
    private static boolean oldBackDown;
    private static int leftDown;
    private static int rightDown;
    private static int forwardDown;
    private static int backDown;

    public RingOfDexterousMotionItem(Item.Properties props) {
        super(props);
    }

    @Override
    public void onWornTick(ItemStack stack, LivingEntity living) {
        int cd = ItemNBTHelper.getInt(stack, TAG_DODGE_COOLDOWN, 0);
        if (cd > 0) {
            ItemNBTHelper.setInt(stack, TAG_DODGE_COOLDOWN, cd - 1);
        }
    }

    private static void dodge(Player player, Direction dir) {
        if (player.getAbilities().flying || !player.onGround() || dir == Direction.UP || dir == Direction.DOWN) {
            return;
        }
        float yaw = player.getYRot();
        float x = Mth.sin((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float z = Mth.cos((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        if (dir == Direction.NORTH || dir == Direction.SOUTH) {
            x = Mth.cos((float)(-yaw * ((float)Math.PI / 180)));
            z = Mth.sin((float)(yaw * ((float)Math.PI / 180)));
        }
        Vec3 lookVec = new Vec3((double)x, 0.0, (double)z);
        Vec3 sideVec = lookVec.cross(new Vec3(0.0, dir == Direction.WEST || dir == Direction.NORTH ? 1.0 : (double)(dir == Direction.EAST || dir == Direction.SOUTH ? -1 : 0), 0.0)).scale(1.25);
        player.setDeltaMovement(sideVec);
        ClientXplatAbstractions.INSTANCE.sendToServer(DodgePacket.INSTANCE);
    }

    public static class ClientLogic {
        public static void onKeyDown() {
            int oldBack;
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == null) {
                return;
            }
            ItemStack ringStack = EquipmentHandler.findOrEmpty(BotaniaItems.dodgeRing, (LivingEntity)mc.player);
            if (ringStack.isEmpty() || ItemNBTHelper.getInt(ringStack, RingOfDexterousMotionItem.TAG_DODGE_COOLDOWN, 0) > 0) {
                return;
            }
            int threshold = 5;
            if (mc.options.keyLeft.isDown() && !oldLeftDown) {
                leftDown = ClientTickHandler.ticksInGame;
                int oldLeft = leftDown;
                if (leftDown - oldLeft < threshold) {
                    RingOfDexterousMotionItem.dodge((Player)mc.player, Direction.WEST);
                }
            } else if (mc.options.keyRight.isDown() && !oldRightDown) {
                rightDown = ClientTickHandler.ticksInGame;
                int oldRight = rightDown;
                if (rightDown - oldRight < threshold) {
                    RingOfDexterousMotionItem.dodge((Player)mc.player, Direction.EAST);
                }
            } else if (mc.options.keyUp.isDown() && !oldForwardDown) {
                forwardDown = ClientTickHandler.ticksInGame;
                int oldForward = forwardDown;
                if (forwardDown - oldForward < threshold) {
                    RingOfDexterousMotionItem.dodge((Player)mc.player, Direction.NORTH);
                }
            } else if (mc.options.keyDown.isDown() && !oldBackDown && (backDown = ClientTickHandler.ticksInGame) - (oldBack = backDown) < threshold) {
                RingOfDexterousMotionItem.dodge((Player)mc.player, Direction.SOUTH);
            }
            oldLeftDown = mc.options.keyLeft.isDown();
            oldRightDown = mc.options.keyRight.isDown();
            oldForwardDown = mc.options.keyUp.isDown();
            oldBackDown = mc.options.keyDown.isDown();
        }

        public static void renderHUD(GuiGraphics gui, Player player, ItemStack stack, float pticks) {
            int xo = Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2 - 20;
            int y = Minecraft.getInstance().getWindow().getGuiScaledHeight() / 2 + 20;
            if (!player.getAbilities().flying) {
                int cd = ItemNBTHelper.getInt(stack, RingOfDexterousMotionItem.TAG_DODGE_COOLDOWN, 0);
                int width = Math.min((int)(((float)cd - pticks) * 2.0f), 40);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (width > 0) {
                    gui.fill(xo, y - 2, xo + 40, y - 1, -2013265920);
                    gui.fill(xo, y - 2, xo + width, y - 1, -1);
                }
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

