/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.network.serverbound;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.common.block.block_entity.corporea.CorporeaIndexBlockEntity;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.network.BotaniaPacket;

public record IndexKeybindRequestPacket(ItemStack stack) implements BotaniaPacket
{
    public static final ResourceLocation ID = ResourceLocationHelper.prefix("idx");

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeItem(this.stack());
    }

    @Override
    public ResourceLocation getFabricId() {
        return ID;
    }

    public static IndexKeybindRequestPacket decode(FriendlyByteBuf buf) {
        return new IndexKeybindRequestPacket(buf.readItem());
    }

    public void handle(MinecraftServer server, ServerPlayer player) {
        ItemStack stack = this.stack();
        server.execute(() -> {
            if (player.isSpectator()) {
                return;
            }
            for (CorporeaIndexBlockEntity index : CorporeaIndexBlockEntity.getNearbyValidIndexes((Player)player)) {
                index.performPlayerRequest(player, CorporeaHelper.instance().createMatcher(stack, true), stack.getCount());
            }
        });
    }
}

