/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.forge.data;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.forge.data.ForgeBlockTagProvider;

public class ForgeItemTagProvider
extends ItemTagsProvider {
    public ForgeItemTagProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTagProvider, ExistingFileHelper helper) {
        super(packOutput, lookupProvider, blockTagProvider, "botania", helper);
    }

    public String getName() {
        return "Botania item tags (Forge-specific)";
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.tag(ForgeItemTagProvider.forge("dusts/mana")).addTag(BotaniaTags.Items.DUSTS_MANA);
        this.tag(ForgeItemTagProvider.forge("dusts")).addTag(ForgeItemTagProvider.forge("dusts/mana"));
        this.tag(ForgeItemTagProvider.forge("gems/dragonstone")).addTag(BotaniaTags.Items.GEMS_DRAGONSTONE);
        this.tag(ForgeItemTagProvider.forge("gems/mana_diamond")).addTag(BotaniaTags.Items.GEMS_MANA_DIAMOND);
        this.tag(ForgeItemTagProvider.forge("gems")).addTag(ForgeItemTagProvider.forge("gems/dragonstone")).addTag(ForgeItemTagProvider.forge("gems/mana_diamond"));
        this.tag(ForgeItemTagProvider.forge("ingots/elementium")).addTag(BotaniaTags.Items.INGOTS_ELEMENTIUM);
        this.tag(ForgeItemTagProvider.forge("ingots/manasteel")).addTag(BotaniaTags.Items.INGOTS_MANASTEEL);
        this.tag(ForgeItemTagProvider.forge("ingots/terrasteel")).addTag(BotaniaTags.Items.INGOTS_TERRASTEEL);
        this.tag(ForgeItemTagProvider.forge("ingots")).addTag(ForgeItemTagProvider.forge("ingots/elementium")).addTag(ForgeItemTagProvider.forge("ingots/manasteel")).addTag(ForgeItemTagProvider.forge("ingots/terrasteel"));
        this.tag(ForgeItemTagProvider.forge("nuggets/elementium")).addTag(BotaniaTags.Items.NUGGETS_ELEMENTIUM);
        this.tag(ForgeItemTagProvider.forge("nuggets/manasteel")).addTag(BotaniaTags.Items.NUGGETS_MANASTEEL);
        this.tag(ForgeItemTagProvider.forge("nuggets/terrasteel")).addTag(BotaniaTags.Items.NUGGETS_TERRASTEEL);
        this.tag(ForgeItemTagProvider.forge("nuggets")).addTag(ForgeItemTagProvider.forge("nuggets/elementium")).addTag(ForgeItemTagProvider.forge("nuggets/manasteel")).addTag(ForgeItemTagProvider.forge("nuggets/terrasteel"));
        this.tag(Tags.Items.HEADS).add((Object)BotaniaBlocks.gaiaHead.asItem());
        this.copyToSameName(ForgeBlockTagProvider.ELEMENTIUM);
        this.copyToSameName(ForgeBlockTagProvider.MANASTEEL);
        this.copyToSameName(ForgeBlockTagProvider.TERRASTEEL);
        this.copyToSameName(ForgeBlockTagProvider.MANA_DIAMOND);
        this.copyToSameName(ForgeBlockTagProvider.DRAGONSTONE);
        this.copyToSameName(ForgeBlockTagProvider.BLAZE_MESH);
        ColorHelper.supportedColors().map(ForgeBlockTagProvider.PETAL_BLOCKS::get).forEach(this::copyToSameName);
        this.copy(ForgeBlockTagProvider.MUSHROOMS, Tags.Items.MUSHROOMS);
        this.copy(Tags.Blocks.STORAGE_BLOCKS_QUARTZ, Tags.Items.STORAGE_BLOCKS_QUARTZ);
        this.copy(Tags.Blocks.STORAGE_BLOCKS, Tags.Items.STORAGE_BLOCKS);
        this.copy(Tags.Blocks.GLASS, Tags.Items.GLASS);
        this.copy(Tags.Blocks.GLASS_PANES, Tags.Items.GLASS_PANES);
        this.copy(Tags.Blocks.FENCES_WOODEN, Tags.Items.FENCES_WOODEN);
        this.copy(Tags.Blocks.FENCE_GATES_WOODEN, Tags.Items.FENCE_GATES_WOODEN);
        this.tag(BotaniaTags.Items.LENS_GLUE).addTag(Tags.Items.SLIMEBALLS).add((Object)Items.HONEY_BOTTLE);
        this.generateToolTags();
        this.generateAccessoryTags();
        this.generateQuarkTags();
    }

    private void generateToolTags() {
        this.tag(Tags.Items.SHEARS).add((Object[])new Item[]{BotaniaItems.manasteelShears, BotaniaItems.elementiumShears});
        this.tag(Tags.Items.TOOLS_BOWS).add((Object[])new Item[]{BotaniaItems.livingwoodBow, BotaniaItems.crystalBow});
        this.tag(Tags.Items.ARMORS_HELMETS).add((Object[])new Item[]{BotaniaItems.manasteelHelm, BotaniaItems.manaweaveHelm, BotaniaItems.elementiumHelm, BotaniaItems.terrasteelHelm});
        this.tag(Tags.Items.ARMORS_CHESTPLATES).add((Object[])new Item[]{BotaniaItems.manasteelChest, BotaniaItems.manaweaveChest, BotaniaItems.elementiumChest, BotaniaItems.terrasteelChest});
        this.tag(Tags.Items.ARMORS_LEGGINGS).add((Object[])new Item[]{BotaniaItems.manasteelLegs, BotaniaItems.manaweaveLegs, BotaniaItems.elementiumLegs, BotaniaItems.terrasteelLegs});
        this.tag(Tags.Items.ARMORS_BOOTS).add((Object[])new Item[]{BotaniaItems.manasteelBoots, BotaniaItems.manaweaveBoots, BotaniaItems.elementiumBoots, BotaniaItems.terrasteelBoots});
    }

    private void generateAccessoryTags() {
        this.tag(ForgeItemTagProvider.accessory("belt")).add((Object[])new Item[]{BotaniaItems.knockbackBelt, BotaniaItems.speedUpBelt, BotaniaItems.superTravelBelt, BotaniaItems.travelBelt});
        this.tag(ForgeItemTagProvider.accessory("body")).add((Object[])new Item[]{BotaniaItems.balanceCloak, BotaniaItems.holyCloak, BotaniaItems.invisibilityCloak, BotaniaItems.thirdEye, BotaniaItems.unholyCloak});
        this.tag(ForgeItemTagProvider.accessory("charm")).add((Object[])new Item[]{BotaniaItems.divaCharm, BotaniaItems.goddessCharm, BotaniaItems.monocle, BotaniaItems.tinyPlanet});
        this.tag(ForgeItemTagProvider.accessory("head")).add((Object[])new Item[]{BotaniaItems.flightTiara, BotaniaItems.itemFinder});
        this.tag(ForgeItemTagProvider.accessory("necklace")).add((Object[])new Item[]{BotaniaItems.bloodPendant, BotaniaItems.cloudPendant, BotaniaItems.icePendant, BotaniaItems.lavaPendant, BotaniaItems.superCloudPendant, BotaniaItems.superLavaPendant});
        this.tag(ForgeItemTagProvider.accessory("ring")).add((Object[])new Item[]{BotaniaItems.auraRing, BotaniaItems.auraRingGreater, BotaniaItems.dodgeRing, BotaniaItems.lokiRing, BotaniaItems.magnetRing, BotaniaItems.magnetRingGreater, BotaniaItems.manaRing, BotaniaItems.manaRingGreater, BotaniaItems.miningRing, BotaniaItems.odinRing, BotaniaItems.pixieRing, BotaniaItems.reachRing, BotaniaItems.swapRing, BotaniaItems.thorRing, BotaniaItems.waterRing});
        this.tag(ForgeItemTagProvider.accessory("curio")).add((Object[])new Item[]{BotaniaItems.blackBowtie, BotaniaItems.blackTie, BotaniaItems.redGlasses, BotaniaItems.puffyScarf, BotaniaItems.engineerGoggles, BotaniaItems.eyepatch, BotaniaItems.wickedEyepatch, BotaniaItems.redRibbons, BotaniaItems.pinkFlowerBud, BotaniaItems.polkaDottedBows, BotaniaItems.blueButterfly, BotaniaItems.catEars, BotaniaItems.witchPin, BotaniaItems.devilTail, BotaniaItems.kamuiEye, BotaniaItems.googlyEyes, BotaniaItems.fourLeafClover, BotaniaItems.clockEye, BotaniaItems.unicornHorn, BotaniaItems.devilHorns, BotaniaItems.hyperPlus, BotaniaItems.botanistEmblem, BotaniaItems.ancientMask, BotaniaItems.eerieMask, BotaniaItems.alienAntenna, BotaniaItems.anaglyphGlasses, BotaniaItems.orangeShades, BotaniaItems.grouchoGlasses, BotaniaItems.thickEyebrows, BotaniaItems.lusitanicShield, BotaniaItems.tinyPotatoMask, BotaniaItems.questgiverMark, BotaniaItems.thinkingHand});
    }

    private void generateQuarkTags() {
        this.tag(ForgeItemTagProvider.quark("big_harvest_hoes")).add((Object)BotaniaItems.elementiumHoe);
        this.tag(ForgeItemTagProvider.quark("reacharound_able")).add((Object[])new Item[]{BotaniaItems.dirtRod, BotaniaItems.cobbleRod, BotaniaItems.blackHoleTalisman});
    }

    private static TagKey<Item> accessory(String name) {
        return ItemTags.create((ResourceLocation)new ResourceLocation("curios", name));
    }

    private static TagKey<Item> forge(String name) {
        return ItemTags.create((ResourceLocation)new ResourceLocation("forge", name));
    }

    private static TagKey<Item> quark(String name) {
        return ItemTags.create((ResourceLocation)new ResourceLocation("quark", name));
    }

    private void copyToSameName(TagKey<Block> source) {
        this.copy(source, ItemTags.create((ResourceLocation)source.location()));
    }
}

