/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.entity.ThrowableCopyEntity;
import vazkii.botania.xplat.BotaniaConfig;

public class FallingStarEntity
extends ThrowableCopyEntity {
    private static final String TAG_HAS_BEEN_IN_AIR = "hasBeenInAir";
    private boolean hasBeenInAir = false;

    public FallingStarEntity(EntityType<FallingStarEntity> type, Level world) {
        super(type, world);
    }

    public FallingStarEntity(LivingEntity e, Level world) {
        super(BotaniaEntities.FALLING_STAR, e, world);
    }

    protected void defineSynchedData() {
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.hasBeenInAir && !this.level().isClientSide) {
            BlockState bs = this.getFeetBlockState();
            this.hasBeenInAir = bs.isAir() || this.isInWater() || this.isInLava();
        }
        float dist = 1.5f;
        SparkleParticleData data = SparkleParticleData.sparkle(2.0f, 1.0f, 0.4f, 1.0f, 6);
        for (int i = 0; i < 10; ++i) {
            float xs = (float)(Math.random() - 0.5) * dist;
            float ys = (float)(Math.random() - 0.5) * dist;
            float zs = (float)(Math.random() - 0.5) * dist;
            this.level().addAlwaysVisibleParticle((ParticleOptions)data, this.getX() + (double)xs, this.getY() + (double)ys, this.getZ() + (double)zs, 0.0, 0.0, 0.0);
        }
        Entity thrower = this.getOwner();
        if (!this.level().isClientSide && thrower != null) {
            AABB axis = new AABB(this.getX(), this.getY(), this.getZ(), this.xOld, this.yOld, this.zOld).inflate(2.0);
            List entities = this.level().getEntitiesOfClass(LivingEntity.class, axis);
            for (LivingEntity living : entities) {
                if (living == thrower || living.hurtTime != 0) continue;
                this.onHit((HitResult)new EntityHitResult((Entity)living));
                return;
            }
        }
        if (this.tickCount > 200) {
            this.discard();
        }
    }

    protected void onHitEntity(@NotNull EntityHitResult hit) {
        super.onHitEntity(hit);
        Entity e = hit.getEntity();
        if (e instanceof Villager) {
            return;
        }
        if (!this.level().isClientSide) {
            if (e != this.getOwner() && e.isAlive()) {
                Entity entity = this.getOwner();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    e.hurt(player.damageSources().playerAttack(player), Math.random() < 0.25 ? 10.0f : 5.0f);
                } else {
                    e.hurt(e.damageSources().generic(), Math.random() < 0.25 ? 10.0f : 5.0f);
                }
            }
            this.discard();
        }
    }

    protected void onHitBlock(BlockHitResult hit) {
        super.onHitBlock(hit);
        if (!this.level().isClientSide) {
            BlockPos bpos = hit.getBlockPos();
            BlockState state = this.level().getBlockState(bpos);
            if (this.hasBeenInAir) {
                if (BotaniaConfig.common().blockBreakParticles() && !state.isAir()) {
                    this.level().levelEvent(2001, bpos, Block.getId((BlockState)state));
                }
                this.discard();
            }
        }
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean(TAG_HAS_BEEN_IN_AIR, this.hasBeenInAir);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.hasBeenInAir = tag.getBoolean(TAG_HAS_BEEN_IN_AIR);
    }
}

