/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.patchouli.processor;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.ManaInfusionRecipe;
import vazkii.botania.client.patchouli.PatchouliUtils;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ManaInfusionProcessor
implements IComponentProcessor {
    private List<ManaInfusionRecipe> recipes;
    private boolean hasCustomHeading;

    public void setup(Level level, IVariableProvider variables) {
        if (variables.has("recipes") && variables.has("group")) {
            BotaniaAPI.LOGGER.warn("Mana infusion template has both 'recipes' and 'group', ignoring 'recipes'");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        if (variables.has("group")) {
            String group = variables.get("group").asString();
            builder.addAll(PatchouliUtils.getRecipeGroup(BotaniaRecipeTypes.MANA_INFUSION_TYPE, group));
        } else {
            for (IVariable s : variables.get("recipes").asListOrSingleton()) {
                ManaInfusionRecipe recipe = PatchouliUtils.getRecipe(level, BotaniaRecipeTypes.MANA_INFUSION_TYPE, new ResourceLocation(s.asString()));
                if (recipe == null) continue;
                builder.add((Object)recipe);
            }
        }
        this.recipes = builder.build();
        this.hasCustomHeading = variables.has("heading");
    }

    public IVariable process(Level level, String key) {
        if (this.recipes.isEmpty()) {
            return null;
        }
        switch (key) {
            case "heading": {
                if (!this.hasCustomHeading) {
                    return IVariable.from((Object)this.recipes.get(0).getResultItem(level.registryAccess()).getHoverName());
                }
                return null;
            }
            case "input": {
                return PatchouliUtils.interweaveIngredients(this.recipes.stream().map(r -> (Ingredient)r.getIngredients().get(0)).collect(Collectors.toList()));
            }
            case "output": {
                return IVariable.wrapList((Iterable)this.recipes.stream().map(r -> r.getResultItem(level.registryAccess())).map(IVariable::from).collect(Collectors.toList()));
            }
            case "catalyst": {
                return IVariable.wrapList((Iterable)this.recipes.stream().map(ManaInfusionRecipe::getRecipeCatalyst).flatMap(ingr -> {
                    if (ingr == null) {
                        return Stream.of(ItemStack.EMPTY);
                    }
                    return ingr.getDisplayedStacks().stream();
                }).map(IVariable::from).collect(Collectors.toList()));
            }
            case "mana": {
                return IVariable.wrapList((Iterable)this.recipes.stream().mapToInt(ManaInfusionRecipe::getManaToConsume).mapToObj(IVariable::wrap).collect(Collectors.toList()));
            }
            case "drop": {
                MutableComponent q = Component.literal((String)"(?)").withStyle(ChatFormatting.BOLD);
                return IVariable.from((Object)Component.translatable((String)"botaniamisc.drop").append(" ").append((Component)q));
            }
            case "dropTip2": 
            case "dropTip1": {
                MutableComponent drop = Component.keybind((String)"key.drop").withStyle(ChatFormatting.GREEN);
                return IVariable.from((Object)Component.translatable((String)("botaniamisc." + key), (Object[])new Object[]{drop}));
            }
            case "dropTip3": {
                return IVariable.from((Object)Component.translatable((String)("botaniamisc." + key)));
            }
        }
        return null;
    }
}

