/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.block.Avatar;
import vazkii.botania.api.item.AvatarWieldable;
import vazkii.botania.api.item.BlockProvider;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.xplat.XplatAbstractions;

public class LandsRodItem
extends Item {
    private static final ResourceLocation avatarOverlay = new ResourceLocation("botania:textures/model/avatar_dirt.png");
    static final int COST = 75;

    public LandsRodItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        return LandsRodItem.place(ctx, Blocks.DIRT, 75, 0.35f, 0.2f, 0.05f);
    }

    public static InteractionResult place(UseOnContext ctx, Block block, int cost, float r, float g, float b) {
        Player player = ctx.getPlayer();
        ItemStack stack = ctx.getItemInHand();
        Level world = ctx.getLevel();
        Direction side = ctx.getClickedFace();
        BlockPos pos = ctx.getClickedPos();
        if (player != null && ManaItemHandler.instance().requestManaExactForTool(stack, player, cost, false)) {
            InteractionResult result = PlayerHelper.substituteUse(ctx, new ItemStack((ItemLike)block));
            if (result.consumesAction()) {
                ManaItemHandler.instance().requestManaExactForTool(stack, player, cost, true);
                SparkleParticleData data = SparkleParticleData.sparkle(1.0f, r, g, b, 5);
                for (int i = 0; i < 6; ++i) {
                    world.addParticle((ParticleOptions)data, (double)(pos.getX() + side.getStepX()) + Math.random(), (double)(pos.getY() + side.getStepY()) + Math.random(), (double)(pos.getZ() + side.getStepZ()) + Math.random(), 0.0, 0.0, 0.0);
                }
                return result;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public static class AvatarBehavior
    implements AvatarWieldable {
        @Override
        public void onAvatarUpdate(Avatar tile) {
            BlockPos pos;
            BlockState state;
            BlockEntity te = (BlockEntity)tile;
            Level world = te.getLevel();
            ManaReceiver receiver = XplatAbstractions.INSTANCE.findManaReceiver(world, te.getBlockPos(), te.getBlockState(), te, null);
            if (!world.isClientSide && receiver.getCurrentMana() >= 75 && tile.getElapsedFunctionalTicks() % 4 == 0 && world.random.nextInt(8) == 0 && tile.isEnabled() && (state = world.getBlockState(pos = te.getBlockPos().relative(tile.getAvatarFacing()))).isAir()) {
                world.setBlockAndUpdate(pos, Blocks.DIRT.defaultBlockState());
                world.levelEvent(2001, pos, Block.getId((BlockState)Blocks.DIRT.defaultBlockState()));
                receiver.receiveMana(-75);
            }
        }

        @Override
        public ResourceLocation getOverlayResource(Avatar tile) {
            return avatarOverlay;
        }
    }

    public static class BlockProviderImpl
    implements BlockProvider {
        private final ItemStack stack;

        public BlockProviderImpl(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public boolean provideBlock(Player player, ItemStack requestor, Block block, boolean doit) {
            if (block == Blocks.DIRT) {
                return doit && ManaItemHandler.instance().requestManaExactForTool(requestor, player, 75, true) || !doit && ManaItemHandler.instance().requestManaExactForTool(requestor, player, 75, false);
            }
            return false;
        }

        @Override
        public int getBlockCount(Player player, ItemStack requestor, Block block) {
            if (block == Blocks.DIRT) {
                return ManaItemHandler.instance().getInvocationCountForTool(requestor, player, 75);
            }
            return 0;
        }
    }
}

