/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.model.BotaniaModelLayers;
import vazkii.botania.client.model.GaiaPylonModel;
import vazkii.botania.client.model.ManaPylonModel;
import vazkii.botania.client.model.NaturaPylonModel;
import vazkii.botania.client.model.PylonModel;
import vazkii.botania.client.render.block_entity.TEISR;
import vazkii.botania.common.block.PylonBlock;
import vazkii.botania.common.block.block_entity.PylonBlockEntity;
import vazkii.botania.common.helper.VecHelper;

public class PylonBlockEntityRenderer
implements BlockEntityRenderer<PylonBlockEntity> {
    public static final ResourceLocation MANA_TEXTURE = new ResourceLocation("botania:textures/model/pylon_mana.png");
    public static final ResourceLocation NATURA_TEXTURE = new ResourceLocation("botania:textures/model/pylon_natura.png");
    public static final ResourceLocation GAIA_TEXTURE = new ResourceLocation("botania:textures/model/pylon_gaia.png");
    private final ManaPylonModel manaModel;
    private final NaturaPylonModel naturaModel;
    private final GaiaPylonModel gaiaModel;
    private static PylonBlock.Variant forceVariant = PylonBlock.Variant.MANA;
    private static ItemDisplayContext forceTransform = ItemDisplayContext.NONE;

    public PylonBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.manaModel = new ManaPylonModel(ctx.bakeLayer(BotaniaModelLayers.PYLON_MANA));
        this.naturaModel = new NaturaPylonModel(ctx.bakeLayer(BotaniaModelLayers.PYLON_NATURA));
        this.gaiaModel = new GaiaPylonModel(ctx.bakeLayer(BotaniaModelLayers.PYLON_GAIA));
    }

    public void render(@Nullable PylonBlockEntity pylon, float pticks, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        ResourceLocation texture;
        PylonModel model;
        boolean renderingItem = pylon == null;
        boolean direct = renderingItem && (forceTransform == ItemDisplayContext.GUI || forceTransform.firstPerson());
        PylonBlock.Variant type = renderingItem ? forceVariant : ((PylonBlock)pylon.getBlockState().getBlock()).variant;
        RenderType shaderLayer = switch (type) {
            default -> {
                model = this.manaModel;
                texture = MANA_TEXTURE;
                yield direct ? RenderHelper.MANA_PYLON_GLOW_DIRECT : RenderHelper.MANA_PYLON_GLOW;
            }
            case PylonBlock.Variant.NATURA -> {
                model = this.naturaModel;
                texture = NATURA_TEXTURE;
                yield direct ? RenderHelper.NATURA_PYLON_GLOW_DIRECT : RenderHelper.NATURA_PYLON_GLOW;
            }
            case PylonBlock.Variant.GAIA -> {
                model = this.gaiaModel;
                texture = GAIA_TEXTURE;
                yield direct ? RenderHelper.GAIA_PYLON_GLOW_DIRECT : RenderHelper.GAIA_PYLON_GLOW;
            }
        };
        ms.pushPose();
        float worldTime = (float)ClientTickHandler.ticksInGame + pticks;
        worldTime += pylon == null ? 0.0f : (float)new Random(pylon.getBlockPos().hashCode()).nextInt(360);
        ms.translate(0.0, pylon == null ? 1.35 : 1.5, 0.0);
        ms.scale(1.0f, -1.0f, -1.0f);
        ms.pushPose();
        ms.translate(0.5f, 0.0f, -0.5f);
        if (pylon != null) {
            ms.mulPose(VecHelper.rotateY(worldTime * 1.5f));
        }
        RenderType layer = RenderType.entityTranslucent((ResourceLocation)texture);
        VertexConsumer buffer = buffers.getBuffer(layer);
        model.renderRing(ms, buffer, light, overlay);
        if (pylon != null) {
            ms.translate(0.0, Math.sin((double)worldTime / 20.0) / 20.0 - 0.025, 0.0);
        }
        ms.popPose();
        ms.pushPose();
        if (pylon != null) {
            ms.translate(0.0, Math.sin((double)worldTime / 20.0) / 17.5, 0.0);
        }
        ms.translate(0.5f, 0.0f, -0.5f);
        if (pylon != null) {
            ms.mulPose(VecHelper.rotateY(-worldTime));
        }
        buffer = buffers.getBuffer(shaderLayer);
        model.renderCrystal(ms, buffer, light, overlay);
        ms.popPose();
        ms.popPose();
    }

    public static class ItemRenderer
    extends TEISR {
        public ItemRenderer(Block block) {
            super(block);
        }

        @Override
        public void render(ItemStack stack, ItemDisplayContext type, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
            Block block = Block.byItem((Item)stack.getItem());
            if (block instanceof PylonBlock) {
                PylonBlock pylon = (PylonBlock)block;
                forceVariant = pylon.variant;
                forceTransform = type;
                super.render(stack, type, ms, buffers, light, overlay);
            }
        }
    }
}

